/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.verrari.realm;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.verrari.AttributeConfiguable;
import org.tizen.common.verrari.Realm;
import org.tizen.common.verrari.realm.Query;
import org.tizen.common.verrari.util.QueryFactory;

public abstract class CommonRealm
implements Realm,
AttributeConfiguable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected HashMap<String, String> attributes;

    public static String[] separate(String value) {
        if (value == null) {
            return null;
        }
        Pattern p = Pattern.compile("[,;]+");
        return p.split(value);
    }

    @Override
    public Collection<String> getAttributeKeys() {
        return this.attributes.keySet();
    }

    @Override
    public String getAttribute(String key) {
        String value = this.attributes.get(key);
        this.logger.debug("Key :{}, Value :{}", (Object)key, (Object)value);
        if (value == null) {
            return null;
        }
        return QueryFactory.getInstance().query(value, new HashMap<String, Object>());
    }

    @Override
    public void setAttributes(Map<String, String> attrs) {
        if (this.attributes != null) {
            throw new IllegalStateException("Setting attributes is duplicated");
        }
        this.attributes = new HashMap<String, String>(attrs);
    }

    public void setAttributes(String key, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(key, value);
    }

    protected Query getTemplateQuery(Realm realm) {
        QueryFactory factory = QueryFactory.getInstance();
        return factory.createTemplateQuery(realm);
    }
}

