/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.builder.core;

import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.builder.BuildResult;
import org.tizen.common.builder.core.AbstractBuilder;
import org.tizen.common.builder.exception.BuildException;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.IResource;
import org.tizen.common.file.Resource;
import org.tizen.common.util.IOUtil;

public class CopyBuilder
extends AbstractBuilder {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CopyBuilder(String outputPath) {
        super(outputPath);
    }

    @Override
    public boolean canBuild(IResource resource) {
        if (!super.canBuild(resource)) {
            return false;
        }
        String path = resource.getPath();
        try {
            return FileHandler.Type.DIRECTORY != resource.getFileHandler().get(path, FileHandler.Attribute.TYPE) || !this.getOutputFileHandler().is(path, FileHandler.Attribute.EXISTS);
        }
        catch (IOException e) {
            this.logger.debug(String.valueOf(path) + "does not exists.", (Throwable)e);
            return false;
        }
    }

    @Override
    protected BuildResult doBuild(IResource resource) throws BuildException {
        BuildResult result = new BuildResult(BuildResult.Status.UNKNOWN);
        InputStream contents = null;
        try {
            try {
                FileHandler fh = this.getOutputFileHandler();
                String path = resource.getPath();
                Resource out = new Resource(fh, path);
                if (FileHandler.Type.DIRECTORY == resource.getFileHandler().get(path, FileHandler.Attribute.TYPE)) {
                    fh.makeDirectory(path, true);
                } else {
                    contents = resource.getContents();
                    out.setContents(contents);
                }
                result.addDependency(resource, (IResource)out);
            }
            catch (IOException e) {
                throw new BuildException(e);
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{contents});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{contents});
        return result;
    }
}

