/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.verrari.engine.jsoup;

import java.io.InputStream;
import java.io.OutputStream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.tizen.common.util.Assert;
import org.tizen.common.util.IOUtil;
import org.tizen.common.verrari.IModelProvider;
import org.tizen.common.verrari.ITemplate;
import org.tizen.common.verrari.engine.AbstractTemplateEngine;

public class JsoupTemplateEngine
extends AbstractTemplateEngine {
    protected static final String BASE_URI = "http://www.tizen.org/sdk/ide/verrari";
    public static String DEFAULT_ENCODING = "UTF-8";

    @Override
    public String getEngineVersion() {
        return "1.6.3";
    }

    @Override
    public void generate(String templateKey, IModelProvider modelProvider, OutputStream output) throws Exception {
        this.logger.trace("Template Key :{}, Models :{}", (Object)templateKey, (Object)modelProvider);
        ITemplate template = this.getTemplate(templateKey);
        this.logger.trace("Template :{}", (Object)template);
        Assert.notNull((Object)template, (String)("Template is null for " + templateKey));
        if (template == null) {
            throw new Exception("Template is null for " + templateKey);
        }
        String encoding = template.getEncoding();
        if (encoding == null) {
            encoding = DEFAULT_ENCODING;
        }
        InputStream input = null;
        try {
            input = template.open();
            Document doc = Jsoup.parse((InputStream)input, (String)encoding, (String)BASE_URI);
            doc.outputSettings().prettyPrint(false);
            for (String key : modelProvider.keys()) {
                Elements elements = doc.select(key);
                if (elements.isEmpty()) continue;
                Element element = elements.get(0);
                Object attr = modelProvider.getModel(key);
                if (attr instanceof Attribute) {
                    element.attr(((Attribute)attr).getKey(), ((Attribute)attr).getValue());
                    continue;
                }
                if (attr instanceof Attributes) {
                    Attributes attributes = (Attributes)attr;
                    for (Attribute attribute : attributes) {
                        element.attr(attribute.getKey(), attribute.getValue());
                    }
                    continue;
                }
                element.attr(key, (String)attr);
            }
            output.write(doc.html().getBytes(encoding));
            output.flush();
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{input});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{input});
    }
}

