/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.util;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.OSChecker;
import org.tizen.common.util.StringUtil;
import org.tizen.ncli.core.config.NCLIConfigLoader;

public class CommandUtil {
    protected static Logger logger = LoggerFactory.getLogger(CommandUtil.class);

    public static String getConfigValue(String configKey) {
        if (configKey == null) {
            return null;
        }
        Properties local = NCLIConfigLoader.loadLocalConf();
        String localValue = local.getProperty(configKey);
        if (!StringUtil.isEmpty((CharSequence)localValue)) {
            return localValue;
        }
        Properties global = NCLIConfigLoader.loadGlobalConf();
        String globalValue = global.getProperty(configKey);
        if (!StringUtil.isEmpty((CharSequence)globalValue)) {
            return globalValue;
        }
        return null;
    }

    public static String resolvePath(File workingDir, String path) {
        if (path == null) {
            return null;
        }
        File retFile = new File(path);
        if (!retFile.isAbsolute()) {
            if (!OSChecker.isWindows() && path.startsWith("~")) {
                String rpath = path.replaceFirst("~", System.getProperty("user.home"));
                retFile = new File(rpath);
            } else {
                retFile = new File(workingDir, path);
            }
        }
        try {
            return retFile.getCanonicalPath();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return null;
        }
    }
}

