/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.rpklib.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.tizen.rpklib.RPK;
import org.tizen.rpklib.core.sign.ISigner;
import org.tizen.rpklib.exception.RPKException;
import org.tizen.tpklib.lib.Command;
import org.tizen.tpklib.lib.Log;
import org.tizen.tpklib.lib.PathUtil;
import org.tizen.tpklib.lib.Printer;
import org.tizen.tpklib.lib.StringUtil;
import org.tizen.tpklib.lib.file.FileUtil;
import org.tizen.tpklib.lib.zip.IZip;
import org.tizen.tpklib.lib.zip.ZipProvider;
import org.tizen.tpklib.model.BuildOption;

public class RPKSystem {
    private Log log = RPK.log;
    private BuildOption bOpt = null;
    private OutputStream outStream = null;
    private OutputStream errStream = null;

    public void initializeRPK(String packageDir) throws RPKException {
        this.print("Initialize... ");
        this.bOpt = new BuildOption();
        File packageDirFile = new File(packageDir);
        try {
            this.bOpt.setProjectPath(packageDirFile.getParentFile().getCanonicalPath());
            this.bOpt.setPackageDirPath(PathUtil.addPath((String[])new String[]{FileUtil.getCanonicalPath((String)packageDir)}));
        }
        catch (IOException e) {
            throw new RPKException(e);
        }
        this.print("OK\n");
    }

    public void install(String parentPath, String packageDir) throws RPKException {
        try {
            FileUtils.deleteDirectory((File)new File(packageDir));
            FileUtils.copyDirectory((File)new File(parentPath), (File)new File(packageDir));
            if (FileUtil.existsPath((String)(packageDir + File.separator + ".sign"))) {
                FileUtil.removeFile((String)(packageDir + File.separator + ".sign"));
            }
        }
        catch (IOException e) {
            throw new RPKException(e);
        }
    }

    public void signing(boolean isSign, String profilePath, String profileName, ISigner signer) throws RPKException {
        this.signing(isSign, this.bOpt.getProjectPath(), this.bOpt.getPackageDirPath(), this.bOpt.getPackageDirPath(), profilePath, profileName, signer);
    }

    public void signing(boolean isSign, String projectPath, String pathToSign, String targetPath, String profilePath, String profileName, ISigner signer) throws RPKException {
        if (isSign && this.isSign(signer)) {
            this.print("Signing... ");
            signer.sign(projectPath, pathToSign, targetPath, profilePath, profileName);
            this.print("OK\n");
        }
    }

    public boolean packaging(String packageDir, String pkgName, String pkgVersion) throws RPKException {
        this.cleanRPKPackageFile(packageDir, pkgName, pkgVersion);
        String packagePath = this.getRPKPackagePath(packageDir, pkgName, pkgVersion);
        this.println("Zip path: " + packagePath);
        if (PathUtil.existsFile((String)packagePath)) {
            try {
                Command.remove((String)packagePath);
            }
            catch (IOException e) {
                throw new RPKException(e);
            }
            catch (InterruptedException e) {
                throw new RPKException(e);
            }
        }
        IZip zip = ZipProvider.getZipInstance();
        try {
            if (this.outStream != null) {
                zip.setOutputStream(this.outStream);
            }
            if (zip.zipping(new File(PathUtil.addPath((String[])new String[]{packageDir})), packagePath, 493)) {
                this.print("Zipping... OK\n");
                return true;
            }
            throw new RPKException(String.format("Cannot create package(%s)", packagePath));
        }
        catch (FileNotFoundException e) {
            throw new RPKException(e);
        }
        catch (IOException e) {
            throw new RPKException(e);
        }
        catch (InterruptedException e) {
            throw new RPKException(e);
        }
    }

    public boolean cleanTemporaryRPKFiles(String packageDir) {
        try {
            BuildOption.getInstance().clear();
            FileUtil.removeFile((String)PathUtil.addPath((String[])new String[]{FileUtil.getCanonicalPath((String)packageDir), ".rpk"}));
            FileUtil.removeFile((String)PathUtil.addPath((String[])new String[]{packageDir, ".packaging"}));
            return true;
        }
        catch (IOException e) {
            this.log.exception((Throwable)e);
            return false;
        }
    }

    private boolean cleanRPKPackageFile(String packageDir, String pkgName, String pkgVersion) throws RPKException {
        String rpkFilePath = PathUtil.addPath((String[])new String[]{packageDir, pkgName + "-" + pkgVersion});
        String rpkPath = rpkFilePath + ".rpk";
        String rpkDebugPath = rpkFilePath + "-debug.zip";
        try {
            if (FileUtil.existsPath((String)rpkPath) && !Command.rm((String)rpkPath)) {
                throw new RPKException(String.format("Cannot remove \"%s\"", rpkPath));
            }
            if (FileUtil.existsPath((String)rpkDebugPath) && !Command.rm((String)rpkDebugPath)) {
                throw new RPKException(String.format("Cannot remove \"%s\"", rpkDebugPath));
            }
        }
        catch (IOException e) {
            throw new RPKException(e);
        }
        catch (InterruptedException e) {
            throw new RPKException(e);
        }
        return true;
    }

    public void print(String message) {
        try {
            Printer.print((OutputStream)this.outStream, (String)message);
        }
        catch (IOException e) {
            this.log.exception((Throwable)e);
        }
    }

    public void println(String message) {
        if (message == null) {
            return;
        }
        this.print(message + "\n");
    }

    private boolean isSign(ISigner signer) {
        return signer != null;
    }

    private String getRPKPackagePath(String packageDir, String pkgName, String pkgVersion) {
        if (pkgName == null || pkgVersion == null) {
            return null;
        }
        return PathUtil.addPath((String[])new String[]{packageDir, StringUtil.addWordWithSeperator((String)"-", (String[])new String[]{pkgName, pkgVersion}) + ".rpk"});
    }

    public void setOutputStream(OutputStream stream) {
        this.outStream = stream;
    }

    public void setErrorStream(OutputStream stream) {
        this.errStream = stream;
    }
}

