/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor.dlg;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.tizen.nativecore.ext.manifest.DataControl;
import org.tizen.nativecore.ext.manifest.Manifest;
import org.tizen.nativecore.ext.manifest.Privilege;
import org.tizen.nativecore.ext.manifest.ProviderPrivilege;
import org.tizen.nativecore.misc.core.PrivilegeManager;
import org.tizen.nativecore.misc.utils.IApplicationUtil;

public class UiDataControlDlg
extends SelectionStatusDialog {
    private Text fProviderIdText;
    private Button fSqlRadio;
    private Button fMapRadio;
    private Button fReadCheck;
    private Button fWriteCheck;
    private Button fTrustedCheck;
    private Button fAddButton;
    private Button fRemoveButton;
    private TableViewer fAddedPrivilegesViewer;
    private TableViewer fSupportedPrivilegesViewer;
    private String fDefaultProviderID;
    private String apiVersion;
    private DataControl fDataControl;
    private Manifest manifest;
    private Set<Privilege> addedPrivilegeList;
    private Set<Privilege> supportedPrivilegeList;

    public UiDataControlDlg(Manifest manifest) {
        super(Display.getDefault().getActiveShell());
        this.manifest = manifest;
        this.apiVersion = manifest.getApiVersion();
        String appName = manifest.getDefaultApp().getExec().replace(" ", "");
        this.fDefaultProviderID = "http://" + appName + ".com/datacontrol/provider/" + appName;
        this.setStatusLineAboveButtons(true);
        this.setHelpAvailable(false);
        this.setTitle("Add Data Control");
    }

    public void setInput(DataControl dataControl) {
        this.fDataControl = dataControl;
        this.setTitle("Edit Data Control");
    }

    public DataControl getDataControl() {
        return this.fDataControl;
    }

    private void loadPrivilegeLists() {
        this.addedPrivilegeList = new HashSet<Privilege>();
        this.supportedPrivilegeList = new HashSet<Privilege>();
        if (this.fDataControl != null) {
            for (Privilege privilege : this.fDataControl.getPrivilegeList()) {
                if (this.addedPrivilegeList.contains(privilege)) continue;
                this.addedPrivilegeList.add(privilege);
            }
        }
        for (Privilege privilege : this.manifest.getPrivilege_map().values()) {
            if (this.addedPrivilegeList.contains(privilege)) continue;
            this.supportedPrivilegeList.add(privilege);
        }
        for (ProviderPrivilege providerPrivilege : this.manifest.getProviderPrivilege_map().values()) {
            Privilege privilege = new Privilege(providerPrivilege.getValue());
            if (this.supportedPrivilegeList.contains(privilege) || this.addedPrivilegeList.contains(privilege)) continue;
            this.supportedPrivilegeList.add(privilege);
        }
        for (Privilege privilege : PrivilegeManager.getPlatformPrivileges()) {
            if (this.supportedPrivilegeList.contains(privilege) || this.addedPrivilegeList.contains(privilege)) continue;
            this.supportedPrivilegeList.add(privilege);
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.loadPrivilegeLists();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginTop = 20;
        layout.marginBottom = 9;
        layout.marginLeft = 20;
        layout.marginRight = 20;
        layout.verticalSpacing = 20;
        composite.setLayout((Layout)layout);
        composite.setBackground(new Color(null, 255, 255, 255));
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 540;
        composite.setLayoutData((Object)gd);
        Label labelProvId = new Label(composite, 0);
        labelProvId.setText("Provider ID");
        labelProvId.setBackground(new Color(null, 255, 255, 255));
        GridData lgd = new GridData();
        lgd.widthHint = 150;
        labelProvId.setLayoutData((Object)lgd);
        this.fProviderIdText = new Text(composite, 2048);
        this.fProviderIdText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.fProviderIdText.setBackground(new Color(null, 255, 255, 255));
        Label labelType = new Label(composite, 0);
        labelType.setText("Type");
        labelType.setLayoutData((Object)lgd);
        labelType.setBackground(new Color(null, 255, 255, 255));
        SelectionAdapter buttonListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UiDataControlDlg.this.validate();
            }
        };
        this.fSqlRadio = new Button(composite, 16);
        this.fSqlRadio.setBackground(new Color(null, 255, 255, 255));
        this.fSqlRadio.setText("SQL");
        this.fSqlRadio.addSelectionListener((SelectionListener)buttonListener);
        this.fMapRadio = new Button(composite, 16);
        this.fMapRadio.setBackground(new Color(null, 255, 255, 255));
        this.fMapRadio.setText("Map");
        this.fMapRadio.addSelectionListener((SelectionListener)buttonListener);
        Label labelAccess = new Label(composite, 0);
        labelAccess.setBackground(new Color(null, 255, 255, 255));
        labelAccess.setText("Access rights");
        labelAccess.setLayoutData((Object)lgd);
        this.fReadCheck = new Button(composite, 32);
        this.fReadCheck.setBackground(new Color(null, 255, 255, 255));
        this.fReadCheck.setText("Read");
        this.fReadCheck.addSelectionListener((SelectionListener)buttonListener);
        this.fWriteCheck = new Button(composite, 32);
        this.fWriteCheck.setBackground(new Color(null, 255, 255, 255));
        this.fWriteCheck.setText("Write");
        this.fWriteCheck.addSelectionListener((SelectionListener)buttonListener);
        if (IApplicationUtil.compareVersion(this.apiVersion, "4.0") >= 0) {
            this.fTrustedCheck = new Button(composite, 32);
            this.fTrustedCheck.setBackground(new Color(null, 255, 255, 255));
            this.fTrustedCheck.setText("Trusted");
            this.fTrustedCheck.addSelectionListener((SelectionListener)buttonListener);
            gd = new GridData();
            gd.horizontalSpan = 3;
            this.fTrustedCheck.setLayoutData((Object)gd);
            this.createPrivilegeSection(composite);
            if (this.fDataControl != null) {
                if (this.fDataControl.getTrusted().equals("true")) {
                    this.fTrustedCheck.setSelection(true);
                } else {
                    this.fTrustedCheck.setSelection(false);
                }
            }
        }
        if (this.fDataControl != null) {
            String v;
            this.fProviderIdText.setText(this.fDataControl.getProviderid());
            if (this.fDataControl.getType().equals("Sql")) {
                this.fSqlRadio.setSelection(true);
            }
            if (this.fDataControl.getType().equals("Map")) {
                this.fMapRadio.setSelection(true);
            }
            if ((v = this.fDataControl.getAccess()).equals("ReadOnly")) {
                this.fReadCheck.setSelection(true);
            } else if (v.equals("WriteOnly")) {
                this.fWriteCheck.setSelection(true);
            } else if (v.equals("ReadWrite")) {
                this.fReadCheck.setSelection(true);
                this.fWriteCheck.setSelection(true);
            }
        } else {
            this.fProviderIdText.setText(this.fDefaultProviderID);
        }
        this.fProviderIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UiDataControlDlg.this.validate();
            }
        });
        this.validate();
        return composite;
    }

    private void validate() {
        this.computeResult();
        Status status = null;
        String value = this.fDataControl.getProviderid();
        if (value.isEmpty()) {
            status = new Status(4, "org.tizen.nativecore.misc", "Enter provider ID");
            this.updateStatus((IStatus)status);
            return;
        }
        value = this.fDataControl.getType();
        if (value == null || value.isEmpty()) {
            status = new Status(4, "org.tizen.nativecore.misc", "Select type");
            this.updateStatus((IStatus)status);
            return;
        }
        value = this.fDataControl.getAccess();
        if (value == null || value.isEmpty()) {
            status = new Status(4, "org.tizen.nativecore.misc", "Select access rights");
            this.updateStatus((IStatus)status);
            return;
        }
        if (this.fDataControl.getProviderid().startsWith("http://tizen.org")) {
            status = new Status(2, "org.tizen.nativecore.misc", "The specified provider ID requires the platform level signing key.");
        }
        if (status == null) {
            status = new Status(0, "org.tizen.nativecore.misc", null);
        }
        this.updateStatus((IStatus)status);
    }

    protected void computeResult() {
        if (this.fDataControl == null) {
            this.fDataControl = new DataControl();
        }
        this.fDataControl.setProviderid(this.fProviderIdText.getText());
        String value = "";
        if (this.fSqlRadio.getSelection()) {
            value = "Sql";
        } else if (this.fMapRadio.getSelection()) {
            value = "Map";
        }
        this.fDataControl.setType(value);
        value = "";
        if (this.fReadCheck.getSelection() && this.fWriteCheck.getSelection()) {
            value = "ReadWrite";
        } else if (this.fReadCheck.getSelection()) {
            value = "ReadOnly";
        } else if (this.fWriteCheck.getSelection()) {
            value = "WriteOnly";
        }
        this.fDataControl.setAccess(value);
        if (IApplicationUtil.compareVersion(this.apiVersion, "4.0") >= 0) {
            if (this.fTrustedCheck.getSelection()) {
                this.fDataControl.setTrusted("true");
            } else {
                this.fDataControl.setTrusted(null);
            }
            this.fDataControl.getPrivilegeList().clear();
            for (Privilege prv : this.addedPrivilegeList) {
                if (this.fDataControl.getPrivilegeList().contains(prv)) continue;
                this.fDataControl.getPrivilegeList().add(prv);
            }
        }
    }

    private void createPrivilegeSection(Composite composite) {
        this.fAddedPrivilegesViewer = new TableViewer(composite, 68354);
        Table table1 = this.fAddedPrivilegesViewer.getTable();
        table1.setHeaderVisible(true);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.heightHint = 200;
        table1.setLayoutData((Object)gd);
        TableViewerColumn nameColumn = new TableViewerColumn(this.fAddedPrivilegesViewer, 0);
        nameColumn.getColumn().setText("Added Privileges");
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
        this.fAddedPrivilegesViewer.getTable().setLayout((Layout)tableLayout);
        this.fAddedPrivilegesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                HashSet model = (HashSet)inputElement;
                return model.toArray();
            }
        });
        this.fAddedPrivilegesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Privilege) {
                    return ((Privilege)element).getValue();
                }
                if (element instanceof ProviderPrivilege) {
                    return ((ProviderPrivilege)element).getValue();
                }
                return null;
            }
        });
        this.fAddedPrivilegesViewer.setInput(this.addedPrivilegeList);
        this.fAddedPrivilegesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (!sel.isEmpty()) {
                    UiDataControlDlg.this.fRemoveButton.setEnabled(true);
                } else {
                    UiDataControlDlg.this.fRemoveButton.setEnabled(false);
                }
            }
        });
        Composite buttoncomposite = new Composite(composite, 0);
        buttoncomposite.setBackground(new Color(null, 255, 255, 255));
        buttoncomposite.setLayout((Layout)new GridLayout(2, true));
        gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 3;
        buttoncomposite.setLayoutData((Object)gd);
        this.fAddButton = new Button(buttoncomposite, 140);
        this.fAddButton.setLayoutData((Object)new GridData(131072, 0x1000000, true, true, 1, 1));
        this.fAddButton.setText("Add");
        this.fAddButton.setEnabled(false);
        this.fAddButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                IStructuredSelection sel = UiDataControlDlg.this.fSupportedPrivilegesViewer.getStructuredSelection();
                if (sel.isEmpty()) {
                    return;
                }
                UiDataControlDlg.this.addedPrivilegeList.add((Privilege)sel.getFirstElement());
                UiDataControlDlg.this.supportedPrivilegeList.remove(sel.getFirstElement());
                UiDataControlDlg.this.fAddedPrivilegesViewer.refresh();
                UiDataControlDlg.this.fSupportedPrivilegesViewer.refresh();
            }
        });
        this.fRemoveButton = new Button(buttoncomposite, 1036);
        this.fRemoveButton.setText("Remove");
        this.fRemoveButton.setEnabled(false);
        this.fRemoveButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, true, 1, 1));
        this.fRemoveButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                IStructuredSelection sel = UiDataControlDlg.this.fAddedPrivilegesViewer.getStructuredSelection();
                if (sel.isEmpty()) {
                    return;
                }
                UiDataControlDlg.this.addedPrivilegeList.remove(sel.getFirstElement());
                UiDataControlDlg.this.supportedPrivilegeList.add((Privilege)sel.getFirstElement());
                UiDataControlDlg.this.fAddedPrivilegesViewer.refresh();
                UiDataControlDlg.this.fSupportedPrivilegesViewer.refresh();
            }
        });
        this.fSupportedPrivilegesViewer = new TableViewer(composite, 68354);
        Table table2 = this.fSupportedPrivilegesViewer.getTable();
        table2.setHeaderVisible(true);
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.heightHint = 200;
        table2.setLayoutData((Object)gd);
        TableViewerColumn nameColumn1 = new TableViewerColumn(this.fSupportedPrivilegesViewer, 0);
        nameColumn1.getColumn().setText("Supported Privileges");
        TableLayout tableLayout1 = new TableLayout();
        tableLayout1.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
        this.fSupportedPrivilegesViewer.getTable().setLayout((Layout)tableLayout1);
        this.fSupportedPrivilegesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                Set model = (Set)inputElement;
                return model.toArray();
            }
        });
        this.fSupportedPrivilegesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Privilege) {
                    return ((Privilege)element).getValue();
                }
                if (element instanceof ProviderPrivilege) {
                    return ((ProviderPrivilege)element).getValue();
                }
                return null;
            }
        });
        this.fSupportedPrivilegesViewer.setInput(this.supportedPrivilegeList);
        this.fSupportedPrivilegesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.isEmpty()) {
                    UiDataControlDlg.this.fAddButton.setEnabled(false);
                } else {
                    UiDataControlDlg.this.fAddButton.setEnabled(true);
                }
            }
        });
    }
}

