/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.tizen.common.util.OSChecker;

public class PathUtil {
    public static String convertMinGWPath(String path) {
        if (path == null) {
            return null;
        }
        if (OSChecker.isLinux()) {
            return path;
        }
        if (OSChecker.isWindows()) {
            if (path.matches("/[[a-z][A-Z]]/.*")) {
                char alphabet = path.charAt(1);
                return new Path(path.replaceFirst("/[[a-z][A-Z]]/", String.valueOf(alphabet) + ":/")).toOSString();
            }
            return new Path(path).toOSString();
        }
        return path;
    }

    public static boolean equalPath(IPath path1, IPath path2) {
        if (path1.isAbsolute() != path2.isAbsolute() || path1.isUNC() != path2.isUNC()) {
            return false;
        }
        int i = path1.segmentCount();
        if (i != path2.segmentCount()) {
            return false;
        }
        boolean caseSensitive = !OSChecker.isWindows();
        while (--i >= 0) {
            if (!(caseSensitive ? !path1.segment(i).equals(path2.segment(i)) : !path1.segment(i).equalsIgnoreCase(path2.segment(i)))) continue;
            return false;
        }
        if (path1.getDevice() == null) {
            return path2.getDevice() == null;
        }
        return path1.getDevice().equalsIgnoreCase(path2.getDevice());
    }
}

