/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.build;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ITizenProject;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.TizenProjectType;
import org.tizen.common.core.command.Command;
import org.tizen.common.core.command.CommandCancelException;
import org.tizen.common.core.command.Executor;
import org.tizen.common.core.command.file.EclipseCopyHandlingCommand;
import org.tizen.common.util.FileUtil;
import org.tizen.nativecommon.IXMLStore;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.TizenNativePackageInfoStore;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.nativecommon.resconfig.model.ResConfigHandler;
import org.tizen.sdblib.util.StringUtil;
import org.tizen.tpklib.TPK;
import org.tizen.tpklib.lib.PathUtil;

public abstract class AbstractMultiPackager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String FILE_NAME_MULTI_MANIFEST = "manifest_multi.xml";
    protected static final String FOLDER_DATA = "data";
    private static final String FOLDER_HOME = "home";
    protected static final String FOLDER_RES = "res";
    protected static final String FOLDER_SHARE = "shared";
    protected static final String FOLDER_BIN = "bin";
    protected static final String FOLDER_LIB = "lib";
    public static final String FOLDER_MULTIAPP_TEMP = ".packaging";
    protected static final String FOLDER_MULTIAPP_TEMP_DIR = "temp";
    protected static final String FOLDER_MULTIAPP_TEMP_BIN = "tempbin";
    protected static final String FOLDER_MULTIAPP_TEMP_LIB = "templib";
    protected static final String FOLDER_MULTIAPP_TEMP_RES = "tempres";
    protected static final String FOLDER_MULTIAPP_TEMP_DATA = "tempdata";
    protected static final String FOLDER_MULTIAPP_TEMP_SHARE = "tempshared";
    public static final String EXT_BINARY_EXECUTABLE = ".exe";
    protected Executor executor;
    protected String outputPath;

    public AbstractMultiPackager(Executor executor) {
        this(executor, null);
    }

    public AbstractMultiPackager(Executor executor, String outputPath) {
        this.executor = executor;
        this.outputPath = outputPath;
    }

    public void doMultiPreProcess() throws Exception {
        if (!this.validateMultiPackage()) {
            return;
        }
        this.removeMutilAppResources();
        this.mergeApplicationXML();
        this.copyFiles();
        this.mergeResMetaFile();
    }

    public void mergeResMetaFile() {
        IConfiguration config = ManagedBuildManager.getBuildInfo((IResource)this.getRootProject()).getDefaultConfiguration();
        String location = FileUtil.appendPath((String)config.getName(), (String)FOLDER_MULTIAPP_TEMP);
        ProjectUtil.generateResMetaFile(this.getRootProject(), location);
    }

    public void removeMutilAppResources() {
        File multiTempFile;
        File outputFile = new File(this.getOutputPath());
        File multiappTempFolder = new File(outputFile, FOLDER_MULTIAPP_TEMP);
        if (multiappTempFolder.exists()) {
            FileUtil.recursiveDelete((File)multiappTempFolder);
        }
        if ((multiTempFile = new File(outputFile, FILE_NAME_MULTI_MANIFEST)).exists()) {
            multiTempFile.delete();
        }
    }

    protected void mergeApplicationXML() throws Exception {
        IXMLStore rootStore = this.getIXmlStore();
        if (rootStore != null) {
            String outputPath = this.getOutputPath();
            rootStore.setProject(outputPath);
            rootStore.loadXml();
            String[] stringArray = this.getRefPrjPaths();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String refPath = stringArray[n2];
                IXMLStore refStore = this.getIXmlStore();
                if (refStore != null) {
                    refStore.setProject(refPath);
                    if (refStore.loadXml()) {
                        rootStore.mergeManifest(refStore);
                    }
                }
                ++n2;
            }
            FileUtil.createTextFile((String)FILE_NAME_MULTI_MANIFEST, (String)"", (String)outputPath, null);
            rootStore.storeXml(new File(outputPath, FILE_NAME_MULTI_MANIFEST));
        }
    }

    private void copyFiles() throws Exception {
        this.buildPrjs();
        this.copyResources();
    }

    private void copyResources() {
        ITizenProject tProject = org.tizen.common.util.ProjectUtil.getTizenProject((IProject)this.getRootProject());
        TizenNativePackageInfoStore store = (TizenNativePackageInfoStore)tProject.getTizenPkgInfoStore();
        Map<String, String> originIncludeMap = store.getOriginIncludeMap();
        ArrayList<EclipseCopyHandlingCommand.CopyFile> copyFileList = new ArrayList<EclipseCopyHandlingCommand.CopyFile>();
        String projectPath = this.getRootProject().getLocation().toString();
        int segmentCount = this.getRootProject().getLocation().segmentCount();
        for (String src : originIncludeMap.keySet()) {
            IPath srcPath = new Path(src).removeFirstSegments(segmentCount);
            IResource iResource = this.getRootProject().findMember(src.substring(projectPath.length()));
            if (iResource == null || !iResource.exists() || srcPath.segmentCount() == 1 && TizenPlatformConstants.CORE_MANIFEST_XML_FILE_NAME.equals(srcPath.segment(0)) || srcPath.toString().replaceAll("\\\\", "/").equals(String.valueOf(srcPath.getDevice()) + ResConfigHandler.getResName().replaceAll("\\\\", "/"))) continue;
            this.copyResources(iResource.getProjectRelativePath().toString(), originIncludeMap.get(src), copyFileList);
        }
        ArrayList<Object> linkedResourceList = new ArrayList<IResource>();
        store.getLinkedList((IResource)this.getRootProject(), linkedResourceList);
        TPK tpk = TPK.getInstance();
        String dest = "";
        for (IResource iResource : linkedResourceList) {
            try {
                dest = tpk.getIncludePath(iResource.getProjectRelativePath().toOSString(), store.getBuildType(), store.getBinFileName());
            }
            catch (Exception e) {
                this.logger.error("Failed to get destination of linked file. " + iResource, (Throwable)e);
            }
            if (StringUtil.isEmpty((CharSequence)dest)) continue;
            this.copyResources(iResource.getFullPath().removeFirstSegments(1).toString(), dest, copyFileList);
        }
        EclipseCopyHandlingCommand eclipseCopyHandlingCommand = new EclipseCopyHandlingCommand(copyFileList);
        this.executor.execute(new Command[]{eclipseCopyHandlingCommand});
        copyFileList.clear();
        IProject[] iProjectArray = this.getRefProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject refProject = iProjectArray[n2];
            TizenProjectType refType = ProjectUtil.getTizenProjectType(refProject);
            tProject = org.tizen.common.util.ProjectUtil.getTizenProject((IProject)refProject);
            store = (TizenNativePackageInfoStore)tProject.getTizenPkgInfoStore();
            originIncludeMap = store.getOriginIncludeMap();
            segmentCount = refProject.getLocation().segmentCount();
            String refProjectPath = refProject.getLocation().toString();
            if (ProjectUtil.isLibraryProject(refProject)) {
                String string = ProjectUtil.getBinaryName(refProject);
                String configName = ProjectUtil.getDefaultConfiguration(refProject).getName();
                String libDir = CommonConfigurationManager.getReferencedProjectPath(this.getRootProject(), refProject.getName());
                String binaryPath = PathUtil.addPath((String[])new String[]{configName, string});
                String binFilePath = PathUtil.addPath((String[])new String[]{refProject.getLocation().toOSString(), binaryPath});
                String targetPath = PathUtil.addPath((String[])new String[]{libDir, string});
                originIncludeMap.remove(binFilePath);
                if (!refType.isNativeStaticLibraryProject()) {
                    originIncludeMap.put(binFilePath, targetPath);
                }
            }
            for (String string : originIncludeMap.keySet()) {
                IPath srcPath = new Path(string).removeFirstSegments(segmentCount);
                IResource res = refProject.findMember(string.substring(refProjectPath.length()));
                if (res == null || !res.exists() || srcPath.segmentCount() == 1 && TizenPlatformConstants.CORE_MANIFEST_XML_FILE_NAME.equals(srcPath.segment(0)) || srcPath.toString().replaceAll("\\\\", "/").equals(String.valueOf(srcPath.getDevice()) + ResConfigHandler.getResName().replaceAll("\\\\", "/"))) continue;
                this.copyResources(refProject, res.getProjectRelativePath().toString(), originIncludeMap.get(string), copyFileList);
            }
            linkedResourceList = new ArrayList();
            store.getLinkedList((IResource)refProject, linkedResourceList);
            for (IResource iResource : linkedResourceList) {
                if (this.isTizenManifestFile(refProject, iResource) || StringUtil.isEmpty((CharSequence)(dest = tpk.getIncludePath(iResource.getProjectRelativePath().toOSString(), store.getBuildType(), store.getBinFileName())))) continue;
                this.copyResources(refProject, iResource.getFullPath().removeFirstSegments(1).toString(), dest, copyFileList);
            }
            ++n2;
        }
        EclipseCopyHandlingCommand eclipseCopyHandlingCommand2 = new EclipseCopyHandlingCommand(copyFileList);
        this.executor.execute(new Command[]{eclipseCopyHandlingCommand2});
        copyFileList.clear();
    }

    private boolean isTizenManifestFile(IProject project, IResource res) {
        IPath relativePath = res.getLocation().makeRelativeTo(project.getLocation());
        return res.getType() == 1 && relativePath.segmentCount() == 1 && TizenPlatformConstants.CORE_MANIFEST_XML_FILE_NAME.equals(relativePath.toString());
    }

    protected EclipseCopyHandlingCommand getCommand(List<EclipseCopyHandlingCommand.CopyFile> copyFileList) {
        return new EclipseCopyHandlingCommand(copyFileList);
    }

    protected void copyResResources(String source, String target, List<EclipseCopyHandlingCommand.CopyFile> copyFileList) {
        this.copyResources(source, target, copyFileList);
    }

    protected void copyResResourcesFromRefPrj(String source, String target, List<EclipseCopyHandlingCommand.CopyFile> copyFileList) {
        this.copyResourcesFromRefPrj(source, target, copyFileList);
    }

    private void copyResources(String source, String target, List<EclipseCopyHandlingCommand.CopyFile> copyFileList) {
        String targetTempPath = FileUtil.appendPath((String)this.getOutputPath(), (String)FOLDER_MULTIAPP_TEMP);
        String targetResPath = FileUtil.appendPath((String)targetTempPath, (String)target);
        copyFileList.add(new EclipseCopyHandlingCommand.CopyFile(this.getRootProject(), source, targetResPath));
    }

    private void copyResources(IProject project, String source, String target, List<EclipseCopyHandlingCommand.CopyFile> copyFileList) {
        String targetTempPath = FileUtil.appendPath((String)this.getOutputPath(), (String)FOLDER_MULTIAPP_TEMP);
        String targetResPath = FileUtil.appendPath((String)targetTempPath, (String)target);
        copyFileList.add(new EclipseCopyHandlingCommand.CopyFile(project, source, targetResPath));
    }

    private void copyResources(IProject project, String source, String target, List<String> sourcePathList, List<String> targetPathList) {
        String projectPath = project.getFullPath().toOSString();
        String targetTempPath = FileUtil.appendPath((String)this.getOutputPath(), (String)FOLDER_MULTIAPP_TEMP);
        String sourceResPath = FileUtil.appendPath((String)projectPath, (String)source);
        String targetResPath = FileUtil.appendPath((String)targetTempPath, (String)target);
        sourcePathList.add(sourceResPath);
        targetPathList.add(targetResPath);
    }

    protected void copyResourcesFromRefPrj(String source, String target, List<EclipseCopyHandlingCommand.CopyFile> copyFileList) {
        String targetTempPath = FileUtil.appendPath((String)this.getOutputPath(), (String)FOLDER_MULTIAPP_TEMP);
        String targetResPath = FileUtil.appendPath((String)targetTempPath, (String)target);
        IProject[] iProjectArray = this.getRefProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject refProject = iProjectArray[n2];
            copyFileList.add(new EclipseCopyHandlingCommand.CopyFile(refProject, source, targetResPath));
            ++n2;
        }
    }

    protected void copyBinaries() throws IOException {
        String tempMultiPath = FileUtil.appendPath((String)this.getOutputPath(), (String)FOLDER_MULTIAPP_TEMP);
        IProject[] refPrjs = this.getRefProjects();
        if (refPrjs == null) {
            return;
        }
        File tempBinDir = new File(FileUtil.appendPath((String)tempMultiPath, (String)FOLDER_MULTIAPP_TEMP_BIN));
        tempBinDir.mkdirs();
        File tempLibDir = new File(FileUtil.appendPath((String)tempMultiPath, (String)FOLDER_MULTIAPP_TEMP_LIB));
        tempLibDir.mkdirs();
        IProject[] iProjectArray = refPrjs;
        int n = refPrjs.length;
        int n2 = 0;
        while (n2 < n) {
            File binaryFile;
            IProject project = iProjectArray[n2];
            IConfiguration config = ManagedBuildManager.getBuildInfo((IResource)project).getDefaultConfiguration();
            String binaryName = ProjectUtil.getBinaryName(project);
            String binaryPath = String.valueOf(project.getLocation().toOSString()) + File.separatorChar + config.getName() + File.separatorChar + ProjectUtil.getBinaryName(project);
            String tempDirPath = tempBinDir.getCanonicalPath();
            TizenProjectType projType = ProjectUtil.getTizenProjectType(project);
            if (projType != null && projType.isNativeSharedLibraryProject()) {
                tempDirPath = tempLibDir.getCanonicalPath();
            }
            if (!(binaryFile = new File(binaryPath)).exists()) {
                String message = String.format("binary file '%s' does not exist", binaryPath);
                this.logger.error(message);
                throw new CommandCancelException(message);
            }
            if (binaryName == null) {
                String message = String.format("binary name is null", new Object[0]);
                this.logger.error(message);
                throw new CommandCancelException(message);
            }
            FileUtil.copyTo((String)binaryFile.getAbsolutePath(), (String)FileUtil.appendPath((String)tempDirPath, (String)binaryName));
            ++n2;
        }
    }

    public String getOutputPath() {
        if (this.outputPath != null) {
            return this.outputPath;
        }
        return this.getRootPrjPath();
    }

    public void setOutputPath(String path) {
        this.outputPath = path;
    }

    protected abstract String getBinaryFolder();

    protected String getBinaryFolder(String prjPath) {
        return this.getBinaryFolder();
    }

    protected abstract void buildPrjs() throws Exception;

    protected abstract String[] getRefPrjPaths();

    protected abstract IProject[] getRefProjects();

    protected abstract IProject getRootProject();

    protected abstract String getRootPrjPath();

    protected abstract boolean validateMultiPackage();

    protected abstract IXMLStore getIXmlStore() throws Exception;
}

