/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.indexer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.cdt.core.index.IIndexLocationConverter;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.CCoreInternals;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.pdom.IPDOM;
import org.eclipse.cdt.internal.core.pdom.PDOMManager;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ITizenProject;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativecommon.indexer.ImportPdomRootstrap;
import org.tizen.nativecommon.indexer.PdomRootstrapConverter;
import org.tizen.sdblib.util.StringUtil;

public class PreBuiltPdom {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ICProject project;
    private String fileName;
    private static final String FLAG_FILE_NAME = ".isProjectCreated";
    private boolean canUsePrebuiltIndexer = false;

    public PreBuiltPdom(ICProject project) {
        this(project, null);
    }

    public PreBuiltPdom(ICProject project, String rootstrapId) {
        if (StringUtil.isEmpty((CharSequence)rootstrapId)) {
            IConfiguration config = ProjectUtil.getDefaultConfiguration(project.getProject());
            String target = CommonConfigurationManager.getBuildTargetName(config);
            SmartBuildInterface sbi = SmartBuildInterface.getInstance();
            rootstrapId = sbi.getRootstrapIDFromTargetID(target);
        }
        this.project = project;
        this.fileName = String.valueOf(rootstrapId) + ".pdom";
        this.setUsePrebuiltIndexer();
    }

    public File getLocation() {
        return new File(String.valueOf(InstallPathConfig.getIdeUserDataPath()) + File.separator + "prebuilt-index" + File.separator + this.fileName);
    }

    public void importPdom(IProgressMonitor monitor) {
        if (!this.canUsePrebuiltIndexer()) {
            return;
        }
        ImportPdomRootstrap importPdomRootstrap = new ImportPdomRootstrap(this.project, this);
        importPdomRootstrap.run(monitor);
    }

    public void generate() {
        if (!this.canUsePrebuiltIndexer()) {
            return;
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        monitor.beginTask("", 100);
        if (this.getRootstrapFileCount() < 100) {
            return;
        }
        File tmpPdom = this.getLocation();
        this.createParentDir(tmpPdom);
        PdomRootstrapConverter converter = new PdomRootstrapConverter(this.project.getProject(), false);
        try {
            PDOMManager pdomManager = CCoreInternals.getPDOMManager();
            pdomManager.exportProjectPDOM(this.project, tmpPdom, (IIndexLocationConverter)converter, (IProgressMonitor)monitor);
        }
        catch (CoreException coreException) {
            this.logger.error("Failed to export PDOM: " + this.project + ", " + tmpPdom);
        }
        monitor.done();
    }

    private void createParentDir(File tmpPdom) {
        File parent = tmpPdom.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
    }

    private String getRootstrapPath() {
        IConfiguration config = ProjectUtil.getDefaultConfiguration(this.project.getProject());
        return this.getCanonicalPath(CommonConfigurationManager.getRootstrapPath(config));
    }

    private String getCanonicalPath(String path) {
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            this.logger.error("Failed to get canonical path: " + path, (Throwable)e);
            return "";
        }
    }

    private int getRootstrapFileCount() {
        String rootstrapPath = this.getRootstrapPath();
        if (StringUtil.isEmpty((CharSequence)rootstrapPath)) {
            return 0;
        }
        int count = 0;
        try {
            IIndexFragmentFile[] ifiles;
            PDOMManager pdomManager = CCoreInternals.getPDOMManager();
            IPDOM pdom = pdomManager.getPDOM(this.project);
            new ArrayList();
            IIndexFragmentFile[] iIndexFragmentFileArray = ifiles = pdom.getAllFiles();
            int n = ifiles.length;
            int n2 = 0;
            while (n2 < n) {
                String fullPath;
                IIndexFragmentFile ifile = iIndexFragmentFileArray[n2];
                if (ifile.getLinkageID() == 2 && (fullPath = this.getCanonicalPath(ifile.getLocation().getURI().getPath())).startsWith(rootstrapPath)) {
                    ++count;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            this.logger.error("Failed to get number of rootstrap files on PDOM: " + this.project, (Throwable)e);
        }
        return count;
    }

    public boolean exists() {
        return this.getLocation().exists();
    }

    public boolean canUsePrebuiltIndexer() {
        return this.canUsePrebuiltIndexer;
    }

    private void setUsePrebuiltIndexer() {
        final ITizenProject tProject = org.tizen.common.util.ProjectUtil.getTizenProject((IProject)this.project.getProject());
        if (tProject == null) {
            return;
        }
        final TizenProjectDescription desc = tProject.getDescription();
        this.canUsePrebuiltIndexer = desc.canUsePrebuiltIndexer();
        if (!this.canUsePrebuiltIndexer) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                desc.setUsePrebuiltIndexer(Boolean.valueOf(false));
                tProject.setDescription(desc);
            }
        }.start();
    }
}

