/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.rm.model;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;
import org.tizen.nativecommon.rm.model.ITizenRMFeature;
import org.tizen.nativecommon.rm.model.TizenDPI;
import org.tizen.nativecommon.rm.model.TizenLocale;
import org.tizen.sdblib.util.StringUtil;

public class ResConfig {
    public static final ITizenRMFeature[] LOCALES = TizenLocale.values();
    public static final ITizenRMFeature[] DPIS = TizenDPI.values();
    private static final String DEFAULT_DIR = "res/contents";
    public static final String EDJE_RES_DIR = "edje_res";
    private Item image;
    private Item edje;
    private Item sound;
    private Item bin;
    private IProject project;
    private String location;
    private final String delimiter = "-";

    public ResConfig(IProject project) {
        this.project = project;
        this.updateModel();
    }

    public ResConfig(IProject project, String location) {
        this.project = project;
        this.location = location;
        this.updateModel();
    }

    public String getDir(Set<ITizenRMFeature> features) {
        String dir = "";
        HashSet<ITizenRMFeature> cloneFeatures = new HashSet<ITizenRMFeature>();
        cloneFeatures.addAll(features);
        int i = 0;
        for (ITizenRMFeature feature : cloneFeatures) {
            if (!feature.isDefault()) break;
            ++i;
        }
        if (i == features.size()) {
            return DEFAULT_DIR;
        }
        for (ITizenRMFeature feature : cloneFeatures) {
            if (feature.isDefault()) continue;
            ITizenRMFeature[] iTizenRMFeatureArray = LOCALES;
            int n = LOCALES.length;
            int n2 = 0;
            while (n2 < n) {
                ITizenRMFeature locale = iTizenRMFeatureArray[n2];
                if (feature.equals(locale)) {
                    dir = feature.toString();
                    cloneFeatures.remove(feature);
                    break;
                }
                ++n2;
            }
            if (!dir.isEmpty()) break;
        }
        for (ITizenRMFeature feature : cloneFeatures) {
            if (feature.isDefault()) continue;
            if (!dir.isEmpty()) {
                dir = String.valueOf(dir) + "-";
            }
            dir = String.valueOf(dir) + feature.toString();
        }
        if (dir.isEmpty()) {
            return "";
        }
        return "res/contents/" + dir;
    }

    private IResource getDefaultContentFolder() {
        if (StringUtil.isEmpty((CharSequence)this.location)) {
            return this.project.getFolder(DEFAULT_DIR);
        }
        return this.project.getFolder(String.valueOf(this.location) + "/" + DEFAULT_DIR);
    }

    public void updateModel() {
        final IResource defaltContentFolder = this.getDefaultContentFolder();
        final Item item = this.makeItem(defaltContentFolder, null, null);
        item.name = "ALL";
        item.dir = DEFAULT_DIR;
        this.image = item;
        this.edje = item;
        this.sound = item;
        this.bin = item;
        try {
            defaltContentFolder.refreshLocal(1, null);
        }
        catch (CoreException coreException) {}
        try {
            defaltContentFolder.accept(new IResourceVisitor(){

                public boolean visit(IResource res) throws CoreException {
                    if (defaltContentFolder.equals((Object)res)) {
                        return true;
                    }
                    if (2 == res.getType()) {
                        String name = res.getName();
                        String[] qualifiers = name.split("-");
                        ITizenRMFeature localeFeature = null;
                        ITizenRMFeature resolutionFeature = null;
                        if (qualifiers.length == 1) {
                            localeFeature = this.checkLocale(qualifiers[0]);
                            if (localeFeature == null) {
                                resolutionFeature = this.checkDpi(qualifiers[0]);
                            }
                        } else if (qualifiers.length == 2) {
                            localeFeature = this.checkLocale(qualifiers[0]);
                            if (localeFeature != null) {
                                resolutionFeature = this.checkDpi(qualifiers[1]);
                            }
                            if (localeFeature == null || resolutionFeature == null) {
                                localeFeature = null;
                                resolutionFeature = null;
                            }
                        }
                        if (localeFeature == null && resolutionFeature == null) {
                            return false;
                        }
                        Item child = ResConfig.this.makeItem(res, localeFeature, resolutionFeature);
                        item.children.add(child);
                        return false;
                    }
                    return true;
                }

                private ITizenRMFeature checkLocale(String qualifier) {
                    ITizenRMFeature[] iTizenRMFeatureArray = LOCALES;
                    int n = LOCALES.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITizenRMFeature l = iTizenRMFeatureArray[n2];
                        if (qualifier.equals(l.toString())) {
                            return l;
                        }
                        ++n2;
                    }
                    return null;
                }

                private ITizenRMFeature checkDpi(String qualifier) {
                    ITizenRMFeature[] iTizenRMFeatureArray = DPIS;
                    int n = DPIS.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITizenRMFeature dpi = iTizenRMFeatureArray[n2];
                        if (qualifier.equals(dpi.toString())) {
                            return dpi;
                        }
                        ++n2;
                    }
                    return null;
                }
            });
            this.image = item;
            this.edje = item;
            this.sound = item;
            this.bin = item;
        }
        catch (CoreException coreException) {
            return;
        }
    }

    private String getDirForResXml(IResource res) {
        String dir = "";
        int count = 2;
        if (!StringUtil.isEmpty((CharSequence)this.location)) {
            count += this.location.split("(\\\\|/)").length;
        }
        String[] stringArray = res.getFullPath().removeFirstSegments(count).segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            dir = String.valueOf(dir) + segment + "/";
            ++n2;
        }
        return dir.substring(0, dir.length() - 1);
    }

    private Item makeItem(IResource res, ITizenRMFeature locale, ITizenRMFeature resolution) {
        Item item = new Item();
        item.dir = ResConfig.getDir(res);
        item.res = res;
        item.dirForResXml = this.getDirForResXml(res);
        if (locale == null) {
            locale = TizenLocale.ALL;
        }
        if (resolution == null) {
            resolution = TizenDPI.ALL;
        }
        item.localeFeature = locale;
        item.resolutionFeature = resolution;
        item.features.add(locale);
        item.features.add(resolution);
        item.attributes.add(locale.toString());
        item.attributes.add(resolution.toString());
        item.name = String.valueOf(locale.getName()) + "," + resolution.getName();
        return item;
    }

    public static boolean isLocaleAttr(String attr) {
        ITizenRMFeature[] iTizenRMFeatureArray = LOCALES;
        int n = LOCALES.length;
        int n2 = 0;
        while (n2 < n) {
            ITizenRMFeature l = iTizenRMFeatureArray[n2];
            if (attr.equals(l.toString())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getDefaultDirForImage() {
        return this.image.getDirForResXml();
    }

    public String getDefaultDirForEdje() {
        return this.edje.getDirForResXml();
    }

    public String getDefaultDirForSound() {
        return this.sound.getDirForResXml();
    }

    public String getDefaultDirForBin() {
        return this.bin.getDirForResXml();
    }

    public Item getDefaultImage() {
        return this.image;
    }

    public Item getDefaultEdje() {
        return this.edje;
    }

    public Item getDefaultSound() {
        return this.sound;
    }

    public Item getDefaultBin() {
        return this.bin;
    }

    public Set<Item> getChildrenOfImage() {
        HashSet<Item> children = new HashSet<Item>();
        for (Item child : this.image.children) {
            children.add(child);
            for (Item grandchild : child.children) {
                children.add(grandchild);
            }
        }
        return children;
    }

    public Set<Item> getChildrenOfEdje() {
        HashSet<Item> children = new HashSet<Item>();
        for (Item child : this.edje.children) {
            children.add(child);
            for (Item grandchild : child.children) {
                children.add(grandchild);
            }
        }
        return children;
    }

    public Set<Item> getChildrenOfSound() {
        HashSet<Item> children = new HashSet<Item>();
        for (Item child : this.sound.children) {
            children.add(child);
            for (Item grandchild : child.children) {
                children.add(grandchild);
            }
        }
        return children;
    }

    public Set<Item> getChildrenOfBin() {
        HashSet<Item> children = new HashSet<Item>();
        for (Item child : this.bin.children) {
            children.add(child);
            for (Item grandchild : child.children) {
                children.add(grandchild);
            }
        }
        return children;
    }

    public IProject getProject() {
        return this.project;
    }

    public static String getDir(IResource res) {
        String name = res.getName();
        return "res/contents/" + name;
    }

    public void mergeResConfig(ResConfig resConfig) {
        Item item = resConfig.getDefaultImage();
        if (item == null) {
            return;
        }
        Set<Item> children = resConfig.getChildrenOfImage();
        boolean exist = false;
        for (Item child : children) {
            exist = false;
            for (Item thisChild : this.image.children) {
                if (!thisChild.equals(child)) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            this.image.children.add(child);
            this.edje.children.add(child);
            this.sound.children.add(child);
            this.bin.children.add(child);
        }
    }

    public static class Item
    implements Comparable<Item> {
        private String dir = "";
        private String dirForResXml;
        private IResource res;
        private Set<String> attributes = new HashSet<String>();
        private Set<Item> children = new HashSet<Item>();
        private Set<ITizenRMFeature> features = new HashSet<ITizenRMFeature>();
        private ITizenRMFeature localeFeature;
        private ITizenRMFeature resolutionFeature;
        private String name = "";

        public String getDir() {
            return this.dir;
        }

        public Set<String> getAttributes() {
            return this.attributes;
        }

        public Set<Item> getChildren() {
            return this.children;
        }

        public Set<ITizenRMFeature> getFeatures() {
            return this.features;
        }

        public String getDirForResXml() {
            return this.dirForResXml;
        }

        public String getName() {
            if (this.name.isEmpty()) {
                return this.res.getName();
            }
            return this.name;
        }

        public Image getLocaleImage() {
            return this.localeFeature.getImage();
        }

        public String getLocaleName() {
            return this.localeFeature.getName();
        }

        public String getLocaleToString() {
            return this.localeFeature.toString();
        }

        public Image getResolutionImage() {
            return this.resolutionFeature.getImage();
        }

        public String getResolutionToString() {
            return this.resolutionFeature.toString();
        }

        public IResource getResource() {
            return this.res;
        }

        public ITizenRMFeature getLocale() {
            return this.localeFeature;
        }

        public String getLocaleValue() {
            return this.localeFeature.getValue();
        }

        public String getResolutionValue() {
            return this.resolutionFeature.getValue();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Item) {
                Item item = (Item)obj;
                if (item.localeFeature.equals(this.localeFeature) && item.resolutionFeature.equals(this.resolutionFeature)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int compareTo(Item o) {
            if (this.getName().equals("ALL")) {
                return -1;
            }
            if (o.getName().equals("ALL")) {
                return 1;
            }
            if (this.getLocaleName().equals(o.getLocaleName())) {
                ITizenRMFeature[] iTizenRMFeatureArray = DPIS;
                int n = DPIS.length;
                int n2 = 0;
                while (n2 < n) {
                    ITizenRMFeature dpi = iTizenRMFeatureArray[n2];
                    if (dpi.toString().equals(this.getResolutionToString())) {
                        return -1;
                    }
                    if (dpi.toString().equals(o.getResolutionToString())) {
                        return 1;
                    }
                    ++n2;
                }
            } else {
                ITizenRMFeature[] iTizenRMFeatureArray = LOCALES;
                int n = LOCALES.length;
                int n3 = 0;
                while (n3 < n) {
                    ITizenRMFeature locale = iTizenRMFeatureArray[n3];
                    if (locale.getName().equals(this.getLocaleName())) {
                        return -1;
                    }
                    if (locale.getName().equals(o.getLocaleName())) {
                        return 1;
                    }
                    ++n3;
                }
            }
            return 0;
        }

        public Set<Key> getKey() {
            HashSet<Key> children = new HashSet<Key>();
            IResource itemRes = this.getResource();
            if (itemRes.getType() != 2) {
                return children;
            }
            IFolder folder = (IFolder)itemRes;
            try {
                IResource[] iResourceArray = folder.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource res = iResourceArray[n2];
                    boolean flag = false;
                    if (2 != res.getType() || !ResConfig.EDJE_RES_DIR.equals(res.getName())) {
                        for (Item child : this.getChildren()) {
                            IResource childResource = child.getResource();
                            if (childResource == null || !childResource.equals((Object)res)) continue;
                            flag = true;
                            break;
                        }
                        if (!flag) {
                            children.add(new Key(res, this));
                        }
                    }
                    ++n2;
                }
                return children;
            }
            catch (CoreException coreException) {
                return new HashSet<Key>();
            }
        }
    }

    public static class Key {
        private IResource res;
        private Object parent;

        public Key() {
        }

        public Key(IResource res, Object parent) {
            this.res = res;
            this.parent = parent;
        }

        public Object getParent() {
            return this.parent;
        }

        public IResource getRes() {
            return this.res;
        }

        public boolean isKey() {
            return 1 == this.res.getType();
        }

        public String getKeyString() {
            String key = "";
            if (this.parent instanceof Key) {
                key = String.valueOf(((Key)this.parent).getKeyString()) + "/" + this.res.getName();
            } else if (this.parent instanceof Item) {
                key = this.res.getName();
            }
            return key;
        }

        public Set<Key> getChildren() {
            HashSet<Key> children = new HashSet<Key>();
            if (this.res.getType() != 2) {
                return children;
            }
            IFolder folder = (IFolder)this.res;
            try {
                IResource[] iResourceArray = folder.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource res = iResourceArray[n2];
                    children.add(new Key(res, this));
                    ++n2;
                }
                return children;
            }
            catch (CoreException coreException) {
                return new HashSet<Key>();
            }
        }

        public String toString() {
            return this.res.getName();
        }
    }
}

