/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.rm.ui.view;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.actions.ActionFactory;
import org.tizen.nativecommon.rm.model.ResConfig;
import org.tizen.nativecommon.rm.ui.view.TizenRMView;

public class ContextMenuProvider {
    private final TizenRMView rmView;
    IAction deleteAction;
    IAction openAction;
    MenuManager copyManager;
    MenuManager moveManager;
    List<Object> actionList;

    public ContextMenuProvider(TizenRMView view) {
        this.rmView = view;
        this.createActions();
    }

    public List<Object> getActions(ResConfig.Item item) {
        this.updateCopyAndMoveAction(item);
        this.actionList = new ArrayList<Object>();
        this.actionList.add(this.deleteAction);
        this.actionList.add(this.openAction);
        this.actionList.add(this.copyManager);
        this.actionList.add(this.moveManager);
        return this.actionList;
    }

    private void updateCopyAndMoveAction(ResConfig.Item currentItem) {
        Set<ResConfig.Item> items = this.rmView.getItems();
        HashSet<ResConfig.Item> destItem = new HashSet<ResConfig.Item>();
        for (ResConfig.Item item : items) {
            if (item.equals(currentItem)) continue;
            destItem.add(item);
        }
        this.createCopyAction();
        this.createMoveAction();
        for (ResConfig.Item item : destItem) {
            this.copyManager.add((IAction)new Action(item.getName()){

                public void run() {
                    ContextMenuProvider.this.rmView.doCopyAction(this.getText());
                }
            });
            this.moveManager.add((IAction)new Action(item.getName()){

                public void run() {
                    ContextMenuProvider.this.rmView.doMoveAction(this.getText());
                }
            });
        }
    }

    private void createActions() {
        this.createDeleteAction();
        this.createOpenAction();
        this.createCopyAction();
        this.createMoveAction();
    }

    private void createDeleteAction() {
        this.deleteAction = new Action("&Delete"){

            public void run() {
                ContextMenuProvider.this.rmView.doDeleteAction();
            }
        };
        this.deleteAction.setActionDefinitionId(ActionFactory.DELETE.getCommandId());
        this.deleteAction.setId(ActionFactory.DELETE.getId());
        this.rmView.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.DELETE.getId(), this.deleteAction);
    }

    private void createOpenAction() {
        this.openAction = new Action("&Open"){

            public void run() {
                ContextMenuProvider.this.rmView.doOpenAction();
            }
        };
    }

    private void createCopyAction() {
        this.copyManager = new MenuManager("Copy to");
    }

    private void createMoveAction() {
        this.moveManager = new MenuManager("Move to");
    }
}

