/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeappcommon.wizards;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.nativeappcommon.wizards.Messages;
import org.tizen.nativeappcommon.wizards.TizenMainWizardPage;
import org.tizen.nativeappcommon.wizards.WizardConstants;

@Deprecated
public class NewProjectChecker {
    private TizenMainWizardPage wizardPage;
    private IProject existingProject = null;
    private IErrorMessageReporter errorReporter;
    private static final int secondRow = 3;
    private Text projNameFiled;
    private Text projLocationField;
    private Button useDefaultsButton;
    private Button browseButton;
    private String fPreviousExternalLocation = "";

    public NewProjectChecker(TizenMainWizardPage wizardPage) {
        this.wizardPage = wizardPage;
    }

    public NewProjectChecker(TizenMainWizardPage wizardPage, IErrorMessageReporter reporter) {
        this.wizardPage = wizardPage;
        this.errorReporter = reporter;
    }

    public boolean validatePage() {
        String projName = this.getProjectName();
        if (projName.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(Messages.NewProjectChecker_projectNameEmpty);
            return false;
        }
        String msg = this.validateProjectName(projName);
        if (!StringUtil.isEmpty((CharSequence)msg)) {
            this.setErrorMessage(msg);
            return false;
        }
        IProject handle = this.getProjectHandle();
        if (handle.exists()) {
            this.setErrorMessage(NLS.bind((String)Messages.NewProjectChecker_projectExistsMessage, (Object)projName));
            return false;
        }
        IProject project = this.getProjectFromPlugin(projName);
        this.setExistingProject(project);
        String validLocationMessage = this.checkValidLocation();
        if (validLocationMessage != null) {
            this.setErrorMessage(validLocationMessage);
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    protected String validateProjectName(String projName) {
        return NewProjectChecker.validateProjectName(projName, ResourcesPlugin.getWorkspace());
    }

    public IProject getProjectFromPlugin(String projName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
    }

    public IProject getProjectHandle() {
        return this.wizardPage.getProjectHandle();
    }

    public void setMessage(String message) {
        this.wizardPage.setMessage(message);
    }

    public void setErrorMessage(String message) {
        this.wizardPage.setErrorMessage(message);
    }

    public String checkValidLocation() {
        IStatus locationStatus;
        URI projectPath;
        String locationFieldContents = this.getLocationPath().toOSString();
        if (locationFieldContents.length() == 0) {
            return Messages.NewProjectChecker_projectLocationEmpty;
        }
        URI newPath = this.getLocationURI();
        if (newPath == null) {
            return Messages.NewProjectChecker_locationError;
        }
        if (this.existingProject != null && (projectPath = this.existingProject.getLocationURI()) != null && URIUtil.equals((URI)projectPath, (URI)newPath)) {
            return Messages.NewProjectChecker_locationIsSelf;
        }
        if (!this.useDefaultsButton.getSelection() && !(locationStatus = ResourcesPlugin.getWorkspace().validateProjectLocationURI(this.existingProject, newPath)).isOK()) {
            return locationStatus.getMessage();
        }
        return null;
    }

    public Text createGroup(Composite c, String name, boolean isButton, boolean isEditorble) {
        Label label = new Label(c, 0);
        label.setText(name);
        Text text = new Text(c, 2048);
        SWTUtil.setGridLayoutData((Control)text, (int)-1, (int)-1, (int)0, (int)0, (int)768);
        this.setTextEnablement((Control)text, isEditorble);
        if (!isButton) {
            Label hidden = new Label(c, 0);
            hidden.setVisible(false);
        } else {
            this.browseButton = new Button(c, 8);
            this.browseButton.setText(Messages.NewProjectChecker_browseButtonLabel);
            this.browseButton.setEnabled(false);
        }
        return text;
    }

    public void createGroup(Composite c, String key, String name, boolean isButton, boolean isEditorble) {
        if (key.equals("name")) {
            this.projNameFiled = this.createGroup(c, name, isButton, isEditorble);
        } else if (key.equals("location")) {
            this.projLocationField = this.createGroup(c, name, isButton, isEditorble);
        }
    }

    private void handleLocationBrowseButtonPressed() {
        String selectedDirectory = null;
        String dirName = this.getLocationPath().toOSString();
        if (dirName == null) {
            dirName = "";
        }
        DirectoryDialog dialog = new DirectoryDialog(this.projLocationField.getShell(), 0x10000000);
        dialog.setMessage(Messages.NewProjectChecker_fileBrowseMessage);
        dialog.setFilterPath(dirName);
        selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            this.projLocationField.setText(selectedDirectory);
        }
    }

    public void setExistingProject(IProject existingProject) {
        this.existingProject = existingProject;
    }

    public void createGroupComposite(Composite c) {
        Composite composite = new Composite(c, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        SWTUtil.setGridLayoutData((Control)composite, (int)-1, (int)-1, (int)-1, (int)-1, (int)768);
        this.createGroup(composite, "name", Messages.NewProjectChecker_projectNameLabel, false, true);
        this.createDefaultGroup(composite);
        this.createGroup(composite, "location", Messages.NewProjectChecker_projectLocationLabel, true, false);
        this.addGroupListener();
    }

    public void createDefaultGroup(Composite c) {
        this.useDefaultsButton = new Button(c, 32);
        this.useDefaultsButton.setText(Messages.NewProjectChecker_defaultButtonLabel);
        this.useDefaultsButton.setSelection(true);
        SWTUtil.setGridLayoutData((Control)this.useDefaultsButton, (int)-1, (int)-1, (int)3, (int)-1, (int)1);
    }

    protected void setTextEnablement(Control c, boolean enable) {
        if (enable) {
            if (c instanceof Text) {
                ((Text)c).setEditable(true);
            }
            c.setBackground(new Color((Device)SWTUtil.getDisplay(), 255, 255, 255));
            c.setForeground(new Color((Device)SWTUtil.getDisplay(), 0, 0, 0));
        } else {
            if (c instanceof Text) {
                ((Text)c).setEditable(false);
            }
            c.setForeground(new Color((Device)SWTUtil.getDisplay(), 165, 165, 165));
            c.setBackground(new Color((Device)SWTUtil.getDisplay(), 235, 235, 235));
        }
    }

    public void addGroupListener() {
        this.projLocationField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewProjectChecker.this.errorReporter.reportError(NewProjectChecker.this.checkValidLocation(), false);
            }
        });
        this.useDefaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isDefault = NewProjectChecker.this.useDefaultsButton.getSelection();
                NewProjectChecker.this.setTextEnablement((Control)NewProjectChecker.this.projLocationField, !isDefault);
                if (NewProjectChecker.this.useDefaultsButton.getSelection()) {
                    NewProjectChecker.this.fPreviousExternalLocation = NewProjectChecker.this.projLocationField.getText();
                }
                NewProjectChecker.this.setLocationPath();
                NewProjectChecker.this.browseButton.setEnabled(!isDefault);
                NewProjectChecker.this.wizardPage.setPageComplete(NewProjectChecker.this.wizardPage.validatePage());
            }
        });
        this.projNameFiled.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (NewProjectChecker.this.useDefaultsButton.getSelection()) {
                    NewProjectChecker.this.setLocationPath();
                }
                NewProjectChecker.this.wizardPage.setPageComplete(NewProjectChecker.this.wizardPage.validatePage());
            }
        });
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewProjectChecker.this.handleLocationBrowseButtonPressed();
                NewProjectChecker.this.fPreviousExternalLocation = NewProjectChecker.this.projLocationField.getText();
                NewProjectChecker.this.wizardPage.setPageComplete(NewProjectChecker.this.wizardPage.validatePage());
            }
        });
    }

    public void setLocationPath() {
        if (this.useDefaultsButton.getSelection()) {
            IPath projLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(this.projNameFiled.getText());
            this.projLocationField.setText(projLocation.toOSString());
        } else {
            this.projLocationField.setText(this.fPreviousExternalLocation);
        }
    }

    public String getProjectName() {
        if (this.projNameFiled == null) {
            return "";
        }
        return this.projNameFiled.getText().trim();
    }

    public URI getLocationURI() {
        File file = new File(this.projLocationField.getText());
        return file.toURI();
    }

    public IPath getLocationPath() {
        if (this.useDefaultsButton.getSelection()) {
            IPath location = Platform.getLocation();
            if (location == null) {
                throw new IllegalStateException("Cannot get the platform location");
            }
            return location;
        }
        return new Path(this.projLocationField.getText());
    }

    public boolean isDefault() {
        return this.useDefaultsButton.getSelection();
    }

    private static String validateProjectName(String projName, IWorkspace workspace) {
        IStatus nameStatus;
        if (workspace != null && !(nameStatus = workspace.validateName(projName, 4)).isOK()) {
            return nameStatus.getMessage();
        }
        if (WizardConstants.CPP_KEYWORDS.contains(projName)) {
            return NLS.bind((String)Messages.TizenMainWizardPage_isCppKeyword, (Object)projName);
        }
        if (projName.length() > 50) {
            return NLS.bind((String)Messages.WizardConstants_6, (Object)51);
        }
        if (projName.length() < 3) {
            return NLS.bind((String)Messages.WizardConstants_5, (Object)2);
        }
        if (!projName.matches(WizardConstants.CPP_NAME_PATTERN)) {
            return Messages.WizardConstants_2;
        }
        if (projName.indexOf(35) >= 0 || projName.indexOf(45) >= 0) {
            return Messages.TizenMainWizardPage_3;
        }
        return "";
    }

    public TizenMainWizardPage getWizardPage() {
        return this.wizardPage;
    }

    public Text getProjNameText() {
        return this.projNameFiled;
    }

    public static interface IErrorMessageReporter {
        public void reportError(String var1, boolean var2);
    }
}

