/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPAnnotations;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPFunctionTemplate;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPLinkage;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPMethodTemplate
extends PDOMCPPFunctionTemplate
implements ICPPMethod {
    private static final int METHOD_ANNOTATION = 74;
    protected static final int RECORD_SIZE = 75;
    private byte methodAnnotation = (byte)-1;

    public PDOMCPPMethodTemplate(PDOMCPPLinkage linkage, PDOMNode parent, ICPPMethod method, IASTNode point) throws CoreException, DOMException {
        super(linkage, parent, (ICPPFunctionTemplate)((Object)method), point);
        this.methodAnnotation = PDOMCPPAnnotations.encodeExtraMethodAnnotations(method);
        this.getDB().putByte(this.record + 74L, this.methodAnnotation);
    }

    public PDOMCPPMethodTemplate(PDOMLinkage linkage, long bindingRecord) {
        super(linkage, bindingRecord);
    }

    @Override
    protected int getRecordSize() {
        return 75;
    }

    @Override
    public int getNodeType() {
        return 22;
    }

    @Override
    public boolean isDestructor() {
        return PDOMCPPAnnotations.isDestructor(this.getMethodAnnotation());
    }

    @Override
    public boolean isImplicit() {
        return PDOMCPPAnnotations.isImplicitMethod(this.getMethodAnnotation());
    }

    @Override
    public boolean isExplicit() {
        return PDOMCPPAnnotations.isExplicitMethod(this.getMethodAnnotation());
    }

    @Override
    public boolean isVirtual() {
        return PDOMCPPAnnotations.isVirtualMethod(this.getMethodAnnotation());
    }

    private byte getMethodAnnotation() {
        if (this.methodAnnotation == -1) {
            this.methodAnnotation = this.getByte(this.record + 74L);
        }
        return this.methodAnnotation;
    }

    @Override
    public ICPPClassType getClassOwner() {
        return (ICPPClassType)((Object)this.getOwner());
    }

    @Override
    public int getVisibility() {
        return PDOMCPPAnnotations.getVisibility(this.getAnnotations());
    }

    @Override
    public boolean isExtern() {
        return false;
    }

    @Override
    public boolean isExternC() {
        return false;
    }

    @Override
    public boolean isAuto() {
        return false;
    }

    @Override
    public boolean isRegister() {
        return false;
    }

    @Override
    public boolean isPureVirtual() {
        return false;
    }

    @Override
    public boolean isOverride() {
        return false;
    }

    @Override
    public boolean isFinal() {
        return false;
    }
}

