/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor.dlg;

import java.util.ArrayList;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.tizen.nativecore.ext.manifest.Icon;
import org.tizen.nativecore.ext.manifest.Label;
import org.tizen.nativecore.ext.manifest.Shortcut;
import org.tizen.nativecore.misc.core.LocaledValue;
import org.tizen.nativecore.misc.editor.SectionHelper;
import org.tizen.nativecore.misc.editor.TizenFormPage;
import org.tizen.nativecore.misc.editor.UiAttrIcon;
import org.tizen.nativecore.misc.editor.UiAttrLocaledName;

public class UiNewShortCutDialog
extends SelectionStatusDialog {
    private Text fAppId;
    private Text fKey;
    private Text fData;
    private Text fLabel;
    private UiAttrIcon fIcon;
    private UiAttrLocaledName fLocaledName;
    private Shortcut shortcut;
    protected FormToolkit toolkit;
    protected TizenFormPage fpage;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (UiNewShortCutDialog.this.shortcut == null) {
                UiNewShortCutDialog.this.shortcut = new Shortcut();
            }
            if (e.widget == UiNewShortCutDialog.this.fAppId) {
                UiNewShortCutDialog.this.shortcut.setAppId(UiNewShortCutDialog.this.fAppId.getText());
            }
            if (e.widget == UiNewShortCutDialog.this.fKey) {
                UiNewShortCutDialog.this.shortcut.setExtraKey(UiNewShortCutDialog.this.fKey.getText());
            }
            if (e.widget == UiNewShortCutDialog.this.fData) {
                UiNewShortCutDialog.this.shortcut.setExtraData(UiNewShortCutDialog.this.fData.getText());
            }
            if (e.widget == UiNewShortCutDialog.this.fLabel) {
                Label label = UiNewShortCutDialog.this.shortcut.getDefaultLabel();
                if (label == null) {
                    label = new Label();
                }
                label.setValue(UiNewShortCutDialog.this.fLabel.getText());
                UiNewShortCutDialog.this.shortcut.setDefaultLabel(label);
            }
        }
    };

    public UiNewShortCutDialog(FormToolkit tk, TizenFormPage page) {
        super(Display.getDefault().getActiveShell());
        this.setTitle("Attributes for Shortcut");
        this.toolkit = tk;
        this.fpage = page;
    }

    public Shortcut getShortcut() {
        return this.shortcut;
    }

    public void setShortcut(Shortcut shortcut) {
        this.shortcut = shortcut;
    }

    protected Control createDialogArea(Composite parent) {
        Composite grid = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginTop = 20;
        layout.marginBottom = 9;
        layout.marginLeft = 20;
        layout.marginRight = 20;
        grid.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 510;
        grid.setLayoutData((Object)gd);
        Composite table = SectionHelper.createTableLayout(grid, this.toolkit, 2);
        this.fAppId = SectionHelper.createLabelAndText(table, this.toolkit, "App ID", "App ID of the Shortcut", "");
        this.fAppId.addModifyListener(this.modifyListener);
        this.fKey = SectionHelper.createLabelAndText(table, this.toolkit, "Key", "Extra key for the Shortcut", "");
        this.fKey.addModifyListener(this.modifyListener);
        this.fData = SectionHelper.createLabelAndText(table, this.toolkit, "Data", "Extra data for the Shortcut", "");
        this.fData.addModifyListener(this.modifyListener);
        this.fLabel = SectionHelper.createLabelAndText(table, this.toolkit, "Default label", "Default label for the Shortcut", "");
        this.fLabel.addModifyListener(this.modifyListener);
        table.setLayoutData((Object)new GridData(4, 4, true, false));
        Group group = new Group(table, 0);
        group.setText("Icons");
        group.setLayout((Layout)new GridLayout());
        TableWrapData twd = new TableWrapData(256, 16);
        twd.colspan = 2;
        group.setLayoutData((Object)twd);
        parent.setBackgroundMode(2);
        Composite icons = SectionHelper.createGridLayout((Composite)group, this.toolkit, 2);
        icons.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fIcon = new UiAttrIcon(this.fpage, true);
        this.fIcon.createUi(icons, this.toolkit, "Icon", false);
        this.fLocaledName = new UiAttrLocaledName(this.fpage, false);
        this.fLocaledName.setDefaultLocaleRequired(false);
        this.fLocaledName.createUi(grid, this.toolkit, "Name", false);
        this.initialize();
        return grid;
    }

    protected void computeResult() {
        if (this.shortcut != null) {
            this.shortcut.setDefaultIcon(this.fIcon.getIconInput());
            this.shortcut.setLabelList(this.fLocaledName.getInput());
        }
    }

    private void initialize() {
        if (this.shortcut != null) {
            if (this.shortcut.getAppId() != null && this.shortcut.getAppId().length() > 0) {
                this.fAppId.setText(this.shortcut.getAppId());
            }
            if (this.shortcut.getExtraKey() != null && this.shortcut.getExtraKey().length() > 0) {
                this.fKey.setText(this.shortcut.getExtraKey());
            }
            if (this.shortcut.getExtraData() != null && this.shortcut.getExtraData().length() > 0) {
                this.fData.setText(this.shortcut.getExtraData());
            }
            if (this.shortcut.getDefaultLabel() != null && this.shortcut.getDefaultLabel().getValue().length() > 0) {
                this.fLabel.setText(this.shortcut.getDefaultLabel().getValue());
            }
            this.fIcon.setInput(this.shortcut.getDefaultIcon());
            this.fLocaledName.setInput(this.shortcut.getLabelList());
        } else {
            this.shortcut = new Shortcut();
            this.fIcon.setInput(new Icon());
            this.fLocaledName.setInput(new ArrayList<LocaledValue>());
            String appId = this.fpage.getEditor().getCoreManifest().getDefaultApp().getAppid();
            this.fAppId.setText(appId);
        }
    }
}

