/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.build;

import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativecommon.build.exception.SBIException;
import org.tizen.sbilib.ide.PluginManager;
import org.tizen.sbilib.ide.Tool;
import org.tizen.sbilib.ide.Toolchain;

public class GCCSpecsRunSIProvider
extends org.eclipse.cdt.make.internal.core.scannerconfig2.GCCSpecsRunSIProvider {
    String targetID = "";
    boolean validSBI = false;

    public boolean invokeProvider(IProgressMonitor monitor, IResource resource, InfoContext context, String providerId, IScannerConfigBuilderInfo2 buildInfo, IScannerInfoCollector collector, Properties env) {
        IProject prj = resource.getProject();
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)prj);
        IConfiguration defaultConfig = info.getDefaultConfiguration();
        String provideRunCommand = buildInfo.getProviderRunCommand(providerId);
        if (provideRunCommand != null) {
            Path old_path = new Path(provideRunCommand);
            SmartBuildInterface sbi = SmartBuildInterface.getInstance();
            IConfiguration[] iConfigurationArray = defaultConfig.getManagedProject().getConfigurations();
            int n = iConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration config = iConfigurationArray[n2];
                if (config.getId().equals(context.getInstanceId())) {
                    if (old_path.toString().equals("sbi-c++") || old_path.toString().equals("sbi-cc")) {
                        try {
                            this.targetID = CommonConfigurationManager.getBuildTargetName(config);
                            if (this.targetID == null) {
                                this.targetID = CommonConfigurationManager.getDefaultBuildTargetName(config);
                            }
                            if (!sbi.checkTargetID(this.targetID)) {
                                sbi.writeTargetCfgFile(this.targetID);
                            }
                            this.validSBI = true;
                        }
                        catch (SBIException sBIException) {
                            this.validSBI = false;
                        }
                    }
                    break;
                }
                ++n2;
            }
        } else {
            this.validSBI = false;
        }
        return super.invokeProvider(monitor, resource, context, providerId, buildInfo, collector, env);
    }

    protected IPath getCommandToLaunch() {
        if (this.validSBI) {
            String runCommand = this.buildInfo.getProviderRunCommand(this.providerId);
            if (runCommand == null) {
                return new Path("g++");
            }
            Path old_path = new Path(runCommand);
            if (old_path.toString().equals("sbi-cc")) {
                SmartBuildInterface sbi = SmartBuildInterface.getInstance();
                String toolchainId = sbi.getToolchainIDFromTargetID(this.targetID);
                PluginManager pm = PluginManager.getInstance();
                Toolchain tc = pm.getToolchain(toolchainId);
                if (tc == null) {
                    return old_path;
                }
                Tool cCompiler = tc.getCCompiler();
                if (cCompiler != null) {
                    return new Path(cCompiler.getPath());
                }
            } else if (old_path.toString().equals("sbi-c++")) {
                SmartBuildInterface sbi = SmartBuildInterface.getInstance();
                String toolchainId = sbi.getToolchainIDFromTargetID(this.targetID);
                PluginManager pm = PluginManager.getInstance();
                Toolchain tc = pm.getToolchain(toolchainId);
                if (tc == null) {
                    return old_path;
                }
                Tool cppCompiler = tc.getCppCompiler();
                if (cppCompiler != null) {
                    return new Path(cppCompiler.getPath());
                }
            }
            return old_path;
        }
        return new Path("g++");
    }

    protected String[] getCommandLineOptions() {
        if (this.validSBI) {
            Object[] args = super.getCommandLineOptions();
            SmartBuildInterface sbi = SmartBuildInterface.getInstance();
            String toolchainId = sbi.getToolchainIDFromTargetID(this.targetID);
            PluginManager pm = PluginManager.getInstance();
            Toolchain tc = pm.getToolchain(toolchainId);
            if (tc == null) {
                return args;
            }
            String misOptions = tc.getCompilerMiscellaneousOption();
            Object[] misOptionsArray = sbi.parseCommandString(misOptions);
            String[] newArgs = (String[])ArrayUtils.addAll((Object[])args, (Object[])misOptionsArray);
            return newArgs;
        }
        return super.getCommandLineOptions();
    }
}

