/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.build;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.tizen.common.core.command.CommandCancelException;
import org.tizen.common.sign.signer.SignatureGenerator;
import org.tizen.common.sign.signer.TizenCommonSigner;
import org.tizen.common.sign.util.SignatureUtility;
import org.tizen.common.sign.util.SigningPathUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.tpklib.core.sign.ISigner;
import org.tizen.tpklib.exception.TPKException;
import org.tizen.tpklib.lib.ArgumentValidation;
import org.tizen.tpklib.lib.PathUtil;
import org.tizen.tpklib.lib.file.FileUtil;

public class NativeSigner
implements ISigner {
    private IDevice device;

    public NativeSigner() {
        this.device = null;
    }

    public NativeSigner(IDevice device) {
        this.device = device;
    }

    public void sign(String projectPath, String dirPathToSign, String outputPath, String profilePath, String profileName) throws TPKException {
        if (NativeSigner.isSlicing(projectPath)) {
            this.signBySlicing(dirPathToSign, outputPath, profilePath, profileName);
        } else {
            this.sign(dirPathToSign, outputPath, profilePath, profileName);
        }
        try {
            this.copyCacheFiles(dirPathToSign, projectPath);
        }
        catch (IOException e) {
            throw new TPKException((Throwable)e);
        }
    }

    protected void sign(String dirPathToSign, String outputPath, String profilePath, String profileName) throws TPKException {
        try {
            if (ArgumentValidation.validateStringArgument((String[])new String[]{profilePath, profileName})) {
                SignatureGenerator.generate((String)dirPathToSign, (String)outputPath, (String)profilePath, (String)profileName);
            } else {
                TizenCommonSigner signer = new TizenCommonSigner();
                signer.doSign(dirPathToSign, true, outputPath, this.device);
            }
        }
        catch (UnrecoverableKeyException e) {
            throw new TPKException((Throwable)e);
        }
        catch (KeyStoreException e) {
            throw new TPKException((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TPKException((Throwable)e);
        }
        catch (CertificateException e) {
            throw new TPKException((Throwable)e);
        }
        catch (IOException e) {
            throw new TPKException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new TPKException((Throwable)e);
        }
        catch (XMLSecurityException e) {
            throw new TPKException((Throwable)e);
        }
        catch (CommandCancelException e) {
            throw new TPKException((Throwable)e);
        }
    }

    private void signBySlicing(String dirPathToSign, String outputPath, String profilePath, String profileName) throws TPKException {
        try {
            if (ArgumentValidation.validateStringArgument((String[])new String[]{profilePath, profileName})) {
                SignatureGenerator.generateBySlicing((String)dirPathToSign, (String)outputPath, (String)profilePath, (String)profileName);
            } else {
                SignatureGenerator.generateBySlicing((String)dirPathToSign, (String)outputPath, (IDevice)this.device);
            }
        }
        catch (UnrecoverableKeyException e) {
            throw new TPKException((Throwable)e);
        }
        catch (KeyStoreException e) {
            throw new TPKException((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TPKException((Throwable)e);
        }
        catch (CertificateException e) {
            throw new TPKException((Throwable)e);
        }
        catch (IOException e) {
            throw new TPKException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new TPKException((Throwable)e);
        }
        catch (XMLSecurityException e) {
            throw new TPKException((Throwable)e);
        }
    }

    protected void copyCacheFiles(String strPackageDirectory, String projectPath) throws IOException {
        File packageDirectory = new File(strPackageDirectory);
        String[] list = packageDirectory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return SignatureUtility.isSignatureFile((String)name) || ".manifest.tmp".equals(name);
            }
        });
        if (list == null) {
            return;
        }
        String signatureDirectory = PathUtil.addPath((String[])new String[]{projectPath, SigningPathUtil.getSignatureDirectory()});
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            String srcPath = PathUtil.addPath((String[])new String[]{strPackageDirectory, file});
            String dstPath = String.valueOf(signatureDirectory) + file;
            if (FileUtil.existsPath((String)srcPath)) {
                String parentDir = FileUtil.getParentDirectory((String)dstPath);
                if (!FileUtil.existsPath((String)parentDir)) {
                    FileUtil.makeDirs((String)parentDir);
                }
                if (FileUtil.existsPath((String)dstPath)) {
                    FileUtil.removeFile((String)dstPath);
                }
                Files.copy(new File(srcPath).toPath(), new File(dstPath).toPath(), new CopyOption[0]);
            }
            ++n2;
        }
        String tmpSignFile = PathUtil.addPath((String[])new String[]{strPackageDirectory, ".manifest.tmp"});
        if (FileUtil.existsPath((String)tmpSignFile)) {
            FileUtil.removeFile((String)tmpSignFile);
        }
    }

    public static boolean isSlicing(String projectPath) {
        if (projectPath == null || projectPath.isEmpty()) {
            return false;
        }
        String rmConfigFilePath = PathUtil.addPath((String[])new String[]{projectPath, "res", "res.xml"});
        return FileUtil.existsPath((String)rmConfigFilePath);
    }
}

