/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.fastdeploy;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ITizenNativeProject;
import org.tizen.common.ITizenProject;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.fastdeploy.FastDeployer;
import org.tizen.common.launch.FastDeployListener;
import org.tizen.common.sdb.command.PackageInfoCommand;
import org.tizen.common.ui.view.console.ConsoleManager;
import org.tizen.common.ui.view.console.ITizenConsoleManager;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.fastdeploy.NativeFastDeployer;
import org.tizen.nativecommon.launch.IProjectLaunchCommand;
import org.tizen.sdblib.IDevice;

public class NativeFastDeployListener
extends FastDeployListener {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private FastDeployer fDeployer;
    ITizenConsoleManager console = null;
    private boolean useConsole = false;

    public boolean deploy() throws CoreException {
        IDevice device = this.getDevice();
        if (this.useConsole) {
            this.console = new ConsoleManager("FastDeploy", false);
        }
        this.fDeployer = new NativeFastDeployer(this.project, device, this.console, "TPK".toLowerCase(), null);
        if (!this.fDeployer.hasLatestDelta()) {
            return false;
        }
        if (this.fDeployer.deploy()) {
            this.fDeployer.pushResInfoFile();
            return true;
        }
        return false;
    }

    public boolean isSupportType() {
        ITizenProject tizenProject = org.tizen.common.util.ProjectUtil.getTizenProject((IProject)this.project);
        return tizenProject instanceof ITizenNativeProject;
    }

    public boolean isAcceptableEvent(IResourceChangeEvent e) {
        int buildKind = e.getBuildKind();
        switch (buildKind) {
            case 6: {
                this.logger.debug("[FastDeploy] build kind: FULL_BUILD");
            }
            case 10: {
                this.logger.debug("[FastDeploy] build kind: INCREMENTAL_BUILD");
            }
            case 9: {
                this.logger.debug("[FastDeploy] build kind: AUTO_BUILD");
                return true;
            }
            case 15: {
                this.logger.debug("[FastDeploy] build kind: CLEAN_BUILD");
            }
        }
        this.logger.debug("[FastDeploy] build kind: UNKNOWN_BUILD_KIND");
        return false;
    }

    public IDevice getDevice() {
        return ConnectionPlugin.getDefault().getCurrentDevice();
    }

    public boolean isInstalled() {
        PackageInfoCommand pkgcmd = new PackageInfoCommand(this.getDevice(), null);
        IProjectLaunchCommand manifest = ProjectUtil.getProjectManifest(this.project);
        try {
            return pkgcmd.isInstalled(manifest.getPackageName(), "TPK".toLowerCase());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean verifyProjectError() {
        int severity = org.tizen.common.util.ProjectUtil.getMaxProblemSeverity((IResource)this.project, (boolean)false);
        return severity >= 2;
    }
}

