/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.launch;

import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativecommon.fastdeploy.NativeFastDeployListener;

public class DebugLaunchListener
implements ILaunchesListener2 {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ILaunch debugLaunch;
    private IProject project;

    public DebugLaunchListener(ILaunch launch, IProject project) {
        this.debugLaunch = launch;
        this.project = project;
    }

    public void launchesRemoved(ILaunch[] launches) {
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesTerminated(ILaunch[] launches) {
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            if (launch.equals(this.debugLaunch)) {
                NativeFastDeployListener.enableFastDeployListener((IProject)this.project);
                ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
                launchManager.removeLaunchListener((ILaunchesListener)this);
                this.logger.debug("[DebugLaunchListener] FastDeployListener enabled, listener removed: " + this.project.getLocation().toString());
                break;
            }
            ++i;
        }
    }
}

