/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.po.editor;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.tizen.nativecommon.po.editor.CellEditorKeyListener;
import org.tizen.nativecommon.po.editor.CellEditorTraverseListener;
import org.tizen.nativecommon.po.editor.TableKeyListener;
import org.tizen.nativecommon.po.editor.TableTraverseListener;
import org.tizen.nativecommon.po.editor.TableViewerFocusHandler;

public class TableViewerKeyBoardSupporter {
    protected Composite fComp = null;
    protected TableViewer fTableViewer = null;
    protected TableViewerFocusHandler fSizeController = null;

    public TableViewerKeyBoardSupporter(Composite comp, TableViewer tableViewer, TableViewerFocusHandler sizeController) {
        this.fComp = comp;
        this.fTableViewer = tableViewer;
        this.fSizeController = sizeController;
    }

    public void startSupport() {
        this.getTable().addKeyListener((KeyListener)new TableKeyListener(this));
        this.getTable().addTraverseListener((TraverseListener)new TableTraverseListener(this));
        CellEditor[] cellEditors = this.fTableViewer.getCellEditors();
        if (cellEditors != null) {
            int colIndex = 0;
            while (colIndex < cellEditors.length) {
                CellEditor cellEditor = cellEditors[colIndex];
                if (cellEditor != null) {
                    cellEditor.getControl().addKeyListener((KeyListener)new CellEditorKeyListener(this, cellEditor, colIndex));
                    cellEditor.getControl().addTraverseListener((TraverseListener)new CellEditorTraverseListener(this, cellEditor, colIndex));
                }
                ++colIndex;
            }
        }
    }

    protected Composite getComposite() {
        return this.fComp;
    }

    protected TableViewerFocusHandler getSizeController() {
        return this.fSizeController;
    }

    protected TableViewer getTableViewer() {
        return this.fTableViewer;
    }

    protected Table getTable() {
        return this.fTableViewer.getTable();
    }

    protected int nextColumn(int column) {
        return column >= this.getTable().getColumnCount() - 1 ? 0 : column + 1;
    }

    protected int prevColumn(int column) {
        return column <= 0 ? this.getTable().getColumnCount() - 1 : column - 1;
    }

    protected void editColumnOrNextPossible(int column) {
        Object selectedElem = this.getSelectedElement();
        if (selectedElem == null) {
            return;
        }
        int nextColumn = column;
        do {
            this.fTableViewer.editElement(selectedElem, nextColumn);
            if (!this.fTableViewer.isCellEditorActive()) continue;
            return;
        } while ((nextColumn = this.nextColumn(nextColumn)) != column);
    }

    protected void editColumnOrPrevPossible(int column) {
        Object selectedElem = this.getSelectedElement();
        if (selectedElem == null) {
            return;
        }
        int prevColumn = column;
        do {
            this.fTableViewer.editElement(selectedElem, prevColumn);
            if (!this.fTableViewer.isCellEditorActive()) continue;
            return;
        } while ((prevColumn = this.prevColumn(prevColumn)) != column);
    }

    private Object getSelectedElement() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        return selection.getFirstElement();
    }
}

