/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.build.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.internal.core.MultiConfiguration;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractCBuildPropertyTab;
import org.eclipse.cdt.ui.newui.ICPropertyProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.tizen.nativeappcommon.build.DevPackageManager;
import org.tizen.nativeappcommon.build.model.DevPackage;
import org.tizen.nativeappcommon.build.model.DevPackageTreeItem;
import org.tizen.nativecore.build.NativeCoreConfigurationManager;
import org.tizen.nativecore.build.ui.PKGConfigContentProvider;
import org.tizen.nativecore.build.ui.PKGConfigLabelProvider;

public class FrameworkPropertyTab
extends AbstractCBuildPropertyTab {
    private CheckboxTreeViewer mFrameworkTree;
    private CheckboxTableViewer mSelectedItemTable;
    private Text mPkgDescriptionText;
    private Text mFilterText;
    private String mFilterTextString;
    private ViewerFilter mViewerFilter;
    private ArrayList<DevPackageTreeItem> mAllFrameworkList;
    private ArrayList<DevPackageTreeItem> mRootFrameworkList;
    private ArrayList<String> mPKGConfigList;
    static HashMap<String, ArrayList<DevPackage>> devListMap = new HashMap();

    public void createControls(Composite _parent, ICPropertyProvider _provider) {
        this.page = _provider;
        if (this.canBeVisible()) {
            this.createControls(_parent);
        }
    }

    protected void createControls(Composite parent) {
        super.createControls(parent);
        this.usercomp.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite(this.usercomp, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Composite frameworkComposite = this.createFrameworkComposite(composite);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.verticalSpan = 2;
        gridData.heightHint = 400;
        gridData.widthHint = 400;
        frameworkComposite.setLayoutData((Object)gridData);
        Group selectFrameworkComposite = this.createSelectedFrameworkComposite(composite);
        gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 250;
        gridData.widthHint = 300;
        selectFrameworkComposite.setLayoutData((Object)gridData);
        Group descriptionComposite = this.createDescriptionComposite(composite);
        gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 150;
        gridData.widthHint = 300;
        descriptionComposite.setLayoutData((Object)gridData);
    }

    private Composite createFrameworkComposite(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText("Framework");
        GridData gridData = new GridData(4, 4, true, true);
        group.setLayoutData((Object)gridData);
        this.mFilterText = new Text((Composite)group, 2048);
        this.mFilterTextString = new String();
        gridData = new GridData(4, 4, true, false);
        this.mFilterText.setLayoutData((Object)gridData);
        this.mFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FrameworkPropertyTab.this.mFilterTextString = ((Text)e.getSource()).getText();
                if (FrameworkPropertyTab.this.mFilterTextString.isEmpty()) {
                    if (FrameworkPropertyTab.this.mFrameworkTree.getFilters().length != 0) {
                        FrameworkPropertyTab.this.mFrameworkTree.removeFilter(FrameworkPropertyTab.this.mViewerFilter);
                        FrameworkPropertyTab.this.mFrameworkTree.setInput((Object)FrameworkPropertyTab.this.getAllFrameworkList());
                    }
                } else {
                    FrameworkPropertyTab.this.mFrameworkTree.addFilter(FrameworkPropertyTab.this.mViewerFilter);
                    FrameworkPropertyTab.this.mFrameworkTree.setInput((Object)FrameworkPropertyTab.this.getAllFrameworkList());
                    FrameworkPropertyTab.this.mFrameworkTree.expandAll();
                }
            }
        });
        Composite composite = new Composite((Composite)group, 0);
        composite.setLayout((Layout)new FillLayout());
        gridData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gridData);
        this.mFrameworkTree = new CheckboxTreeViewer(composite, 2560);
        this.mFrameworkTree.setLabelProvider((IBaseLabelProvider)new PKGConfigLabelProvider());
        this.mFrameworkTree.setContentProvider((IContentProvider)new PKGConfigContentProvider());
        this.mFrameworkTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSource() instanceof CheckboxTreeViewer) {
                    if (!event.getSelection().isEmpty()) {
                        TreeSelection selectTree = (TreeSelection)event.getSelection();
                        DevPackageTreeItem selectItem = (DevPackageTreeItem)selectTree.getFirstElement();
                        FrameworkPropertyTab.this.mPkgDescriptionText.setText(selectItem.getDescription());
                    } else {
                        FrameworkPropertyTab.this.mPkgDescriptionText.setText("");
                    }
                }
            }
        });
        this.mFrameworkTree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getElement() instanceof DevPackageTreeItem) {
                    DevPackageTreeItem changedItem = (DevPackageTreeItem)event.getElement();
                    if (event.getChecked()) {
                        FrameworkPropertyTab.this.addPackageConfig(changedItem.getName());
                    } else if (changedItem.isGrayed()) {
                        FrameworkPropertyTab.this.addPackageConfig(changedItem.getName());
                    } else {
                        FrameworkPropertyTab.this.removePackageConfig(changedItem.getName());
                    }
                }
            }
        });
        this.mFrameworkTree.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                if (element instanceof DevPackageTreeItem) {
                    DevPackageTreeItem item = (DevPackageTreeItem)element;
                    return item.isChecked();
                }
                return false;
            }

            public boolean isGrayed(Object element) {
                if (element instanceof DevPackageTreeItem) {
                    DevPackageTreeItem item = (DevPackageTreeItem)element;
                    return item.isGrayed();
                }
                return false;
            }
        });
        this.mViewerFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof DevPackageTreeItem) {
                    return this.check_filter((DevPackageTreeItem)element);
                }
                return false;
            }

            private boolean check_filter(DevPackageTreeItem item) {
                if (item.hasChildren()) {
                    for (DevPackageTreeItem sub_item : item.getChildren()) {
                        if (!this.check_filter(sub_item)) continue;
                        return true;
                    }
                } else {
                    return item.getName().contains(FrameworkPropertyTab.this.mFilterTextString);
                }
                return false;
            }
        };
        return group;
    }

    private Group createSelectedFrameworkComposite(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new FillLayout());
        group.setText("Selected Framework");
        this.mSelectedItemTable = CheckboxTableViewer.newCheckList((Composite)group, (int)2048);
        this.mSelectedItemTable.getTable().setLinesVisible(true);
        TableColumn tableColumn = new TableColumn(this.mSelectedItemTable.getTable(), 16384);
        tableColumn.setText("Selected Framework");
        tableColumn.setWidth(100);
        this.mSelectedItemTable.setLabelProvider((IBaseLabelProvider)new SelectedPackageTableProvider());
        this.mSelectedItemTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.mSelectedItemTable.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                return true;
            }

            public boolean isGrayed(Object element) {
                return false;
            }
        });
        this.mSelectedItemTable.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getElement() instanceof String) {
                    String changedItem = (String)event.getElement();
                    if (!event.getChecked()) {
                        FrameworkPropertyTab.this.removePackageConfig(changedItem);
                    }
                }
            }
        });
        this.mSelectedItemTable.addSelectionChangedListener(new ISelectionChangedListener(){
            String targetID;
            {
                this.targetID = NativeCoreConfigurationManager.getBuildTargetName((IConfiguration)FrameworkPropertyTab.this.getCfg());
            }

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSource() instanceof CheckboxTableViewer) {
                    if (!event.getSelection().isEmpty()) {
                        StructuredSelection selectTableItem = (StructuredSelection)event.getSelection();
                        String pkgName = (String)selectTableItem.getFirstElement();
                        List packageList = DevPackageManager.getAllDevPkgs((String)this.targetID);
                        for (DevPackage pkg : packageList) {
                            if (!pkg.getName().equals(pkgName)) continue;
                            FrameworkPropertyTab.this.mPkgDescriptionText.setText(pkg.getDescription());
                            break;
                        }
                    } else {
                        FrameworkPropertyTab.this.mPkgDescriptionText.setText("");
                    }
                }
            }
        });
        return group;
    }

    private Group createDescriptionComposite(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new FillLayout());
        group.setText("Description");
        this.mPkgDescriptionText = new Text((Composite)group, 74);
        return group;
    }

    private void CreateCompositeData() {
        this.mFilterTextString = "";
        this.mFilterText.setText(this.mFilterTextString);
        this.mFrameworkTree.setInput(this.getAllFrameworkList());
        Collections.sort(this.mPKGConfigList);
        this.mSelectedItemTable.setInput(this.mPKGConfigList);
        this.mPkgDescriptionText.setText("");
    }

    private void UpdateCompositeData() {
        this.mFilterTextString = "";
        this.mFilterText.setText(this.mFilterTextString);
        this.updatePkgConfigStatus();
        this.mFrameworkTree.refresh();
        Collections.sort(this.mPKGConfigList);
        this.mSelectedItemTable.setInput(this.mPKGConfigList);
        this.mPkgDescriptionText.setText("");
    }

    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
    }

    protected void performDefaults() {
    }

    protected void performOK() {
        IConfiguration conf = this.getCfg();
        if (conf instanceof MultiConfiguration) {
            if (this.mPKGConfigList == null) {
                this.updateSelectedPackages();
            }
            Object[] o = ((MultiConfiguration)conf).getItems();
            IConfiguration[] iConfigurationArray = (IConfiguration[])o;
            int n = iConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration c = iConfigurationArray[n2];
                List packageList = null;
                String targetID = NativeCoreConfigurationManager.getBuildTargetName((IConfiguration)c);
                packageList = DevPackageManager.getAllDevPkgs((String)targetID);
                ArrayList tmpList = (ArrayList)this.mPKGConfigList.clone();
                String unsupportedPkgList = "";
                int i = 0;
                while (i < tmpList.size()) {
                    String name = (String)tmpList.get(i);
                    boolean existed = false;
                    for (DevPackage pkg : packageList) {
                        if (!pkg.getName().equals(name)) continue;
                        existed = true;
                        break;
                    }
                    if (!existed) {
                        tmpList.remove(i);
                        --i;
                        unsupportedPkgList = String.valueOf(unsupportedPkgList) + "\n" + name;
                    }
                    ++i;
                }
                if (!unsupportedPkgList.equals("")) {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    String message = "The [" + c.getName() + "] is not supported on the following packages :\n" + unsupportedPkgList;
                    MessageDialog.openInformation((Shell)shell, (String)"Infomation", (String)message);
                }
                NativeCoreConfigurationManager.setDevPackageList(c, tmpList);
                ++n2;
            }
        }
        super.performOK();
    }

    protected void updateData(ICResourceDescription cfgd) {
        this.update();
    }

    private void update() {
        this.updateDevPackages();
        this.updateSelectedPackages();
        this.CreateCompositeData();
    }

    public void updateButtons() {
    }

    private void updateDevPackages() {
        this.mAllFrameworkList = new ArrayList();
        this.mRootFrameworkList = new ArrayList();
        List packageList = null;
        String targetID = NativeCoreConfigurationManager.getBuildTargetName((IConfiguration)this.getCfg());
        packageList = DevPackageManager.getAllDevPkgs((String)targetID);
        for (DevPackage pkg : packageList) {
            this.mAllFrameworkList.add(new DevPackageTreeItem(pkg));
        }
        for (DevPackage pkg : packageList) {
            String pkgName = pkg.getName();
            DevPackageTreeItem item = this.findPkgConfig(pkgName);
            if (item == null) continue;
            ArrayList includeNames = pkg.getIncludePackageList();
            for (String includeName : includeNames) {
                DevPackageTreeItem subItem = this.findPkgConfig(includeName);
                if (subItem == null) continue;
                item.addChild(subItem);
                subItem.setParent(item);
            }
            if (pkg.isVirtulalPackage() && item.getChildren().isEmpty()) {
                this.mAllFrameworkList.remove(item);
                if (item.getParent() == null) continue;
                item.getParent().removeChild(item);
                continue;
            }
            if (!pkg.isFrameworkPackage()) continue;
            this.mRootFrameworkList.add(item);
        }
    }

    private void updateSelectedPackages() {
        this.mPKGConfigList = NativeCoreConfigurationManager.getDevPackageList(this.getCfg());
    }

    private ArrayList<DevPackageTreeItem> getAllFrameworkList() {
        this.updatePkgConfigStatus();
        return this.mRootFrameworkList;
    }

    private void updatePkgConfigStatus() {
        for (DevPackageTreeItem item : this.mAllFrameworkList) {
            item.setChecked(false);
            item.setGrayed(false);
        }
        for (DevPackageTreeItem item : this.mRootFrameworkList) {
            this.updatePkgConfigStatus2(item);
        }
    }

    private boolean updatePkgConfigStatus2(DevPackageTreeItem pkg) {
        boolean checked = false;
        boolean grayed = false;
        if (this.mPKGConfigList.contains(pkg.getName())) {
            this.setPkgConfigChecked(pkg);
            checked = true;
        } else {
            boolean allChecked = true;
            if (pkg.hasChildren()) {
                for (DevPackageTreeItem child : pkg.getChildren()) {
                    if (this.updatePkgConfigStatus2(child)) {
                        grayed = true;
                        checked = true;
                    }
                    if (child.isChecked() && !child.isGrayed()) continue;
                    allChecked = false;
                }
            }
            if (allChecked) {
                grayed = false;
            }
        }
        pkg.setChecked(checked);
        pkg.setGrayed(grayed);
        return checked || grayed;
    }

    private void setPkgConfigChecked(DevPackageTreeItem pkg) {
        pkg.setChecked(true);
        if (pkg.hasChildren()) {
            ArrayList children = pkg.getChildren();
            for (DevPackageTreeItem child : children) {
                this.setPkgConfigChecked(child);
            }
        }
    }

    private void addPKGConfigList(String entry) {
        block4: {
            DevPackageTreeItem treeItem;
            block3: {
                treeItem = this.findPkgConfig(entry);
                if (treeItem == null) {
                    return;
                }
                if (!treeItem.isVirtual()) break block3;
                for (DevPackageTreeItem childItem : treeItem.getChildren()) {
                    this.addPKGConfigList(childItem.getName());
                }
                break block4;
            }
            if (this.mPKGConfigList.contains(entry)) break block4;
            this.mPKGConfigList.add(entry);
            ArrayList depPackages = treeItem.getDependency();
            for (String depPkg : depPackages) {
                this.addPKGConfigList(depPkg);
            }
        }
    }

    public void addPackageConfig(String entry) {
        this.addPKGConfigList(entry);
        Collections.sort(this.mPKGConfigList);
        this.notifyBuildPropertyChanged();
    }

    private void removePKGConfigList(String entry) {
        DevPackageTreeItem treeItem = this.findPkgConfig(entry);
        if (treeItem == null) {
            return;
        }
        if (treeItem.isVirtual()) {
            for (DevPackageTreeItem childItem : treeItem.getChildren()) {
                this.removePKGConfigList(childItem.getName());
            }
        } else if (this.mPKGConfigList.contains(entry)) {
            this.mPKGConfigList.remove(entry);
        }
    }

    public void removePackageConfig(String entry) {
        this.removePKGConfigList(entry);
        Collections.sort(this.mPKGConfigList);
        this.notifyBuildPropertyChanged();
    }

    private void notifyBuildPropertyChanged() {
        NativeCoreConfigurationManager.setDevPackageList(this.getCfg(), this.mPKGConfigList);
        this.UpdateCompositeData();
    }

    private DevPackageTreeItem findPkgConfig(String name) {
        for (DevPackageTreeItem item : this.mAllFrameworkList) {
            if (!item.getName().equals(name)) continue;
            return item;
        }
        return null;
    }

    public boolean canBeVisible() {
        String projectArtifactType = this.getProjectArtifactType();
        return projectArtifactType != null && (projectArtifactType.equals("org.tizen.nativecore.buildArtefactType.app") || projectArtifactType.equals("org.tizen.nativecore.buildArtefactType.sharedLib") || projectArtifactType.equals("org.tizen.nativecore.buildArtefactType.staticLib"));
    }

    private String getProjectArtifactType() {
        IManagedProject managedProject = this.getCfg().getManagedProject();
        String projectArtifactType = managedProject.getProjectType() != null ? managedProject.getProjectType().getBuildArtefactType().getId() : null;
        return projectArtifactType;
    }

    private static class SelectedPackageTableProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private SelectedPackageTableProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof String) {
                return (String)element;
            }
            return null;
        }
    }
}

