/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeappcommon.wizards;

import java.util.List;
import org.eclipse.cdt.core.templateengine.TemplateDescriptor;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.SWTUtil;
import org.tizen.nativeappcommon.templateengine.TizenTemplateProcessParser;
import org.tizen.nativeappcommon.wizards.model.TizenNativeTemplateExtensionPoint;
import org.w3c.dom.Element;

public class TizenNativeWizardPerspectiveThread {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void updatePerspective(final IConfigurationElement fConfigElement, final IPath samplePath) {
        SWTUtil.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                TizenNativeWizardPerspectiveThread.this.updateNativePerspective(fConfigElement, samplePath);
            }
        });
    }

    private void updateNativePerspective(IConfigurationElement fConfigElement, IPath samplePath) {
        TemplateDescriptor desc;
        if (samplePath != null && (desc = TizenTemplateProcessParser.createTemplateDesc(samplePath.toFile())) != null) {
            Element root = desc.getRootElement();
            Element slpPropertyElement = TizenTemplateProcessParser.getElementFromTag(root, "slp-property");
            Element propertyGroupElement = TizenTemplateProcessParser.getElementFromTag(slpPropertyElement, "property-group");
            List<Element> extraTypeElements = TizenTemplateProcessParser.getElementsFromTag(propertyGroupElement, "extra-type");
            String customPerspective = null;
            TizenNativeTemplateExtensionPoint extensionPoint = new TizenNativeTemplateExtensionPoint();
            for (Element element : extraTypeElements) {
                String extraType = element.getTextContent();
                IConfigurationElement matchedExtraElement = extensionPoint.getFirstMatchedExtraElementByType(extraType);
                customPerspective = extensionPoint.getFinalPerspectiveFromExtraElement(matchedExtraElement);
                if (customPerspective == null) continue;
                this.logger.debug("Selected {} extra-type from extension-point: {}", (Object)extraType, (Object)matchedExtraElement.getContributor());
                break;
            }
            if (customPerspective != null) {
                try {
                    this.logger.debug("Change perspective to {}", customPerspective);
                    PlatformUI.getWorkbench().showPerspective(customPerspective, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                    return;
                }
                catch (WorkbenchException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)fConfigElement);
    }
}

