/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.ui.CElementSorter;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class LexicalSortingAction
extends Action {
    private static final String ACTION_NAME = "LexicalSortingAction";
    private final ViewerComparator fSorter;
    private final TreeViewer fTreeViewer;
    private final String fStoreKey;

    public LexicalSortingAction(TreeViewer treeViewer) {
        this(treeViewer, ".sort");
    }

    public LexicalSortingAction(TreeViewer treeViewer, String storeKeySuffix) {
        super(CUIPlugin.getResourceString("LexicalSortingAction.label"));
        this.setDescription(CUIPlugin.getResourceString("LexicalSortingAction.description"));
        this.setToolTipText(CUIPlugin.getResourceString("LexicalSortingAction.tooltip"));
        CPluginImages.setImageDescriptors((IAction)this, "lcl18/", "org.eclipse.cdt.ui.alphab_sort_co.png");
        this.fTreeViewer = treeViewer;
        this.fSorter = new CElementSorter();
        this.fStoreKey = ACTION_NAME + storeKeySuffix;
        boolean checked = CUIPlugin.getDefault().getDialogSettings().getBoolean(this.fStoreKey);
        this.valueChanged(checked, false);
    }

    public void run() {
        this.valueChanged(this.isChecked(), true);
    }

    private void valueChanged(boolean on, boolean store) {
        this.setChecked(on);
        this.fTreeViewer.setComparator(on ? this.fSorter : null);
        String key = "LexicalSortingAction.tooltip" + (on ? ".on" : ".off");
        this.setToolTipText(CUIPlugin.getResourceString(key));
        if (store) {
            CUIPlugin.getDefault().getDialogSettings().put(this.fStoreKey, on);
        }
    }
}

