/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.build.ui;

import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.internal.core.MultiConfiguration;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.tizen.nativecommon.build.CommonBuildMessages;
import org.tizen.nativecommon.build.ui.AbstractDynamicAnalysisPropertyTab;
import org.tizen.nativecore.build.NativeCoreConfigurationManager;

public class DynamicAnalysisPropertyTab
extends AbstractDynamicAnalysisPropertyTab {
    protected boolean checked;

    protected void createDynamicAnalysisComposite(Composite parent) {
        GridLayout gridLayout = new GridLayout(1, false);
        parent.setLayout((Layout)gridLayout);
        this.checkDynamicAnalysis = new Button(parent, 32);
        this.checkDynamicAnalysis.setText(CommonBuildMessages.CODE_COVERAGE_LABEL_CHECKBOX);
        this.checkDynamicAnalysis.setSelection(this.checkSetDynamicAnalysisOption());
        this.checkDynamicAnalysis.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                if (button.getSelection()) {
                    NativeCoreConfigurationManager.setDynamicAnalysisOption(DynamicAnalysisPropertyTab.this.getCfg(), "-fprofile-arcs -ftest-coverage");
                    DynamicAnalysisPropertyTab.this.checked = true;
                } else {
                    NativeCoreConfigurationManager.setDynamicAnalysisOption(DynamicAnalysisPropertyTab.this.getCfg(), "");
                    DynamicAnalysisPropertyTab.this.checked = false;
                }
            }
        });
    }

    protected boolean checkSetDynamicAnalysisOption() {
        String option = NativeCoreConfigurationManager.getDynamicAnalysisOption(this.getCfg());
        return option.equals("-fprofile-arcs -ftest-coverage");
    }

    protected void performOK() {
        IConfiguration conf = this.getCfg();
        if (conf instanceof MultiConfiguration) {
            Object[] o = ((MultiConfiguration)conf).getItems();
            IConfiguration[] iConfigurationArray = (IConfiguration[])o;
            int n = iConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration c = iConfigurationArray[n2];
                if (this.checked) {
                    NativeCoreConfigurationManager.setDynamicAnalysisOption(c, "-fprofile-arcs -ftest-coverage");
                } else {
                    NativeCoreConfigurationManager.setDynamicAnalysisOption(c, "");
                }
                ++n2;
            }
        }
    }

    public boolean canBeVisible() {
        String projectArtifactType;
        IManagedProject managedProject = this.getCfg().getManagedProject();
        String string = projectArtifactType = managedProject.getProjectType() != null ? managedProject.getProjectType().getBuildArtefactType().getId() : null;
        return projectArtifactType != null && projectArtifactType.equals("org.tizen.nativecore.buildArtefactType.app");
    }
}

