/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.manifest.parser;

import java.io.File;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativecore.manifest.parser.Manifest;
import org.tizen.nativecore.manifest.parser.ObjectFactory;

public class CoreManifestHandler {
    private static final Logger logger = LoggerFactory.getLogger(CoreManifestHandler.class);
    static ObjectFactory objFactory = new ObjectFactory();
    static JAXBContext jaxbContext = null;

    static {
        try {
            jaxbContext = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
        }
        catch (JAXBException e) {
            String message = "Failed to create JAXBContext instance (" + CoreManifestHandler.class.getName() + ")";
            logger.error(message, (Throwable)e);
        }
    }

    public boolean marshal(Manifest manifest, OutputStream os) throws JAXBException {
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)manifest, os);
        return true;
    }

    public Manifest unmarshal(File file) {
        block4: {
            if (file.exists()) break block4;
            logger.warn("File doesn't exist: " + file);
            return null;
        }
        try {
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            Object obj = unmarshaller.unmarshal(file);
            if (obj instanceof Manifest) {
                return (Manifest)obj;
            }
        }
        catch (JAXBException e) {
            logger.error("Failed to unmarshal file: ", (Object)file.getAbsolutePath(), (Object)e);
        }
        return null;
    }
}

