/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.c;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.c.ICCompositeTypeScope;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.index.IIndexType;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.PDOMNodeLinkedList;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMMemberOwner;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMASTAdapter;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;

public class PDOMCStructure
extends PDOMBinding
implements ICompositeType,
ICCompositeTypeScope,
IPDOMMemberOwner,
IIndexType,
IIndexScope {
    private static final int MEMBERLIST = 32;
    private static final int KEY = 36;
    private static final int ANONYMOUS = 37;
    protected static final int RECORD_SIZE = 38;

    public PDOMCStructure(PDOMLinkage linkage, PDOMNode parent, ICompositeType compType) throws CoreException {
        super(linkage, parent, compType.getNameCharArray());
        this.setKind(compType);
        this.setAnonymous(compType);
    }

    public PDOMCStructure(PDOMLinkage linkage, long record) {
        super(linkage, record);
    }

    @Override
    public EScopeKind getKind() {
        return EScopeKind.eClassType;
    }

    @Override
    public void update(PDOMLinkage linkage, IBinding newBinding, IASTNode point) throws CoreException {
        if (newBinding instanceof ICompositeType) {
            ICompositeType ct = (ICompositeType)newBinding;
            this.setKind(ct);
            this.setAnonymous(ct);
            super.update(linkage, newBinding, point);
        }
    }

    private void setKind(ICompositeType ct) throws CoreException {
        this.getDB().putByte(this.record + 36L, (byte)ct.getKey());
    }

    private void setAnonymous(ICompositeType ct) throws CoreException {
        this.getDB().putByte(this.record + 37L, (byte)(ct.isAnonymous() ? 1 : 0));
    }

    @Override
    public void accept(IPDOMVisitor visitor) throws CoreException {
        super.accept(visitor);
        new PDOMNodeLinkedList((PDOMLinkage)this.getLinkage(), this.record + 32L).accept(visitor);
    }

    @Override
    public int getNodeType() {
        return 8;
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getKey() {
        try {
            return this.getDB().getByte(this.record + 36L);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 1;
        }
    }

    @Override
    public boolean isAnonymous() {
        try {
            return this.getDB().getByte(this.record + 37L) != 0;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    @Override
    public IField[] getFields() {
        try {
            GetFields fields = new GetFields();
            this.accept(fields);
            return fields.getFields();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return IField.EMPTY_FIELD_ARRAY;
        }
    }

    @Override
    public IField findField(String name) {
        String key;
        PDOM pdom = this.getPDOM();
        IField result = (IField)pdom.getCachedResult(key = pdom.createKeyForCache(this.record, name.toCharArray()));
        if (result != null) {
            return result;
        }
        FindField visitor = new FindField(name);
        try {
            this.accept(visitor);
            return null;
        }
        catch (CoreException e) {
            if (!e.getStatus().equals(Status.OK_STATUS)) {
                CCorePlugin.log(e);
                return null;
            }
            result = visitor.getField();
            if (result != null) {
                pdom.putCachedResult(key, result);
            }
            return result;
        }
    }

    @Override
    public IScope getCompositeScope() {
        return this;
    }

    @Override
    public boolean isSameType(IType type) {
        PDOMNode node;
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (type instanceof PDOMNode && (node = (PDOMNode)((Object)type)).getPDOM() == this.getPDOM()) {
            return node.getRecord() == this.getRecord();
        }
        if (type instanceof ICompositeType) {
            ICompositeType etype = (ICompositeType)type;
            etype = (ICompositeType)PDOMASTAdapter.getAdapterForAnonymousASTBinding(etype);
            try {
                return this.getDBName().equals(etype.getNameCharArray());
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        return false;
    }

    @Override
    protected int getRecordSize() {
        return 38;
    }

    @Override
    public void addChild(PDOMNode member) throws CoreException {
        new PDOMNodeLinkedList((PDOMLinkage)this.getLinkage(), this.record + 32L).addMember(member);
    }

    @Override
    public boolean mayHaveChildren() {
        return true;
    }

    @Override
    public ICompositeType getCompositeType() {
        return this;
    }

    @Override
    public IBinding getBinding(char[] name) {
        return this.findField(new String(name));
    }

    @Override
    public IBinding getBinding(IASTName name, boolean resolve, IIndexFileSet fileSet) {
        return this.getBinding(name.toCharArray());
    }

    @Override
    @Deprecated
    public IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup, IIndexFileSet fileSet) {
        return this.getBindings(new IScope.ScopeLookupData(name, resolve, prefixLookup));
    }

    @Override
    public IBinding[] getBindings(IScope.ScopeLookupData lookup) {
        return this.getBindings(lookup.getLookupKey());
    }

    @Override
    public IBinding[] find(String name, IASTTranslationUnit tu) {
        return this.getBindings(name.toCharArray());
    }

    @Override
    @Deprecated
    public IBinding[] find(String name) {
        return this.getBindings(name.toCharArray());
    }

    private IBinding[] getBindings(char[] name) {
        IBinding b = this.getBinding(name);
        if (b == null) {
            return IBinding.EMPTY_BINDING_ARRAY;
        }
        return new IBinding[]{b};
    }

    @Override
    public IIndexBinding getScopeBinding() {
        return this;
    }

    public static class FindField
    implements IPDOMVisitor {
        private IField field;
        private final String name;

        public FindField(String name) {
            this.name = name;
        }

        @Override
        public boolean visit(IPDOMNode node) throws CoreException {
            if (node instanceof IField) {
                IField tField = (IField)((Object)node);
                if (IndexFilter.ALL_DECLARED_OR_IMPLICIT.acceptBinding(tField) && this.name.equals(tField.getName())) {
                    this.field = tField;
                    throw new CoreException(Status.OK_STATUS);
                }
            } else if (node instanceof ICompositeType && ((ICompositeType)((Object)node)).isAnonymous()) {
                return true;
            }
            return false;
        }

        @Override
        public void leave(IPDOMNode node) throws CoreException {
        }

        public IField getField() {
            return this.field;
        }
    }

    private static class GetFields
    implements IPDOMVisitor {
        private final List<IPDOMNode> fields = new ArrayList<IPDOMNode>();

        private GetFields() {
        }

        @Override
        public boolean visit(IPDOMNode node) throws CoreException {
            if (node instanceof IField) {
                IField field = (IField)((Object)node);
                if (IndexFilter.ALL_DECLARED_OR_IMPLICIT.acceptBinding(field)) {
                    this.fields.add(node);
                }
            } else if (node instanceof ICompositeType && ((ICompositeType)((Object)node)).isAnonymous()) {
                return true;
            }
            return false;
        }

        @Override
        public void leave(IPDOMNode node) throws CoreException {
        }

        public IField[] getFields() {
            return this.fields.toArray(new IField[this.fields.size()]);
        }
    }
}

