/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.ext.xmlstore;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ITizenNativeXMLStore;
import org.tizen.common.TizenProjectType;
import org.tizen.nativecommon.IXMLStore;
import org.tizen.nativecore.ext.manifest.Category;
import org.tizen.nativecore.ext.manifest.ComponentBasedApplication;
import org.tizen.nativecore.ext.manifest.Feature;
import org.tizen.nativecore.ext.manifest.IApplication;
import org.tizen.nativecore.ext.manifest.Icon;
import org.tizen.nativecore.ext.manifest.Manifest;
import org.tizen.nativecore.ext.manifest.ManifestHandler;
import org.tizen.nativecore.ext.manifest.Privilege;
import org.tizen.nativecore.ext.manifest.ServiceApplication;
import org.tizen.nativecore.ext.manifest.UiApplication;
import org.tizen.nativecore.ext.manifest.WatchApplication;
import org.tizen.nativecore.ext.manifest.WidgetApplication;

public class CoreXMLStore
implements IXMLStore {
    public static final Logger logger = LoggerFactory.getLogger(CoreXMLStore.class);
    public static final String TRUST_ANCHOR_VALUE_TRUE = "true";
    public static final String TRUST_ANCHOR_VALUE_FALSE = "false";
    public static final String TRUST_ANCHOR_VALUE_NONE = "none";
    protected File manifestFile = null;
    protected Manifest coreManifest = null;
    protected ManifestHandler mfHandler = new ManifestHandler();

    public CoreXMLStore(IProject project) {
        this.manifestFile = new File(project.getLocation().toOSString(), "tizen-manifest.xml");
    }

    public CoreXMLStore() {
    }

    public Manifest getCoreManifest() {
        return this.coreManifest;
    }

    public void setCoreManifest(Manifest coreManifest) {
        this.coreManifest = coreManifest;
    }

    public ManifestHandler getManifestHandler() {
        return this.mfHandler;
    }

    public void setManifestHandler(ManifestHandler mfHandler) {
        this.mfHandler = mfHandler;
    }

    public boolean loadXml() {
        if (this.manifestFile == null) {
            return false;
        }
        if (!this.manifestFile.exists()) {
            return false;
        }
        return this.loadXml(this.manifestFile);
    }

    public void mergeAppData(ITizenNativeXMLStore arg0) {
    }

    public void mergePrivData(ITizenNativeXMLStore arg0) {
    }

    public void setProject(IProject project) {
        this.setProject(project.getLocation().toFile().getAbsolutePath());
    }

    public void setProject(String projectPath) {
        this.manifestFile = new File(projectPath, "tizen-manifest.xml");
    }

    public void storeXml() {
        if (this.manifestFile == null) {
            return;
        }
        this.storeXml(this.manifestFile);
    }

    public boolean storeXml(File file) {
        if (this.coreManifest == null) {
            return false;
        }
        this.mfHandler.save(file, this.coreManifest);
        return true;
    }

    public void addAppIdList(List<String> arg0) {
    }

    public String generateAppId() {
        return null;
    }

    public TizenProjectType getApplicationType() {
        if (this.coreManifest == null) {
            return null;
        }
        List<IApplication> appList = this.coreManifest.getApplication_list();
        if (appList.isEmpty()) {
            return null;
        }
        for (IApplication obj : appList) {
            String type;
            if (obj instanceof UiApplication) {
                type = ((UiApplication)obj).getType();
                if (type.equals("capp")) {
                    return TizenProjectType.TIZEN_C_UI_APPLICATION;
                }
                if (type.equals("c++app")) {
                    return TizenProjectType.TIZEN_CPP_UI_APPLICATION;
                }
                if (!type.equals("webapp")) continue;
                return TizenProjectType.TIZEN_WEB_APPLICATION;
            }
            if (obj instanceof ServiceApplication) {
                type = ((ServiceApplication)obj).getType();
                if (type.equals("capp")) {
                    return TizenProjectType.TIZEN_C_SERVICE_APPLICATION;
                }
                if (type.equals("c++app")) {
                    return TizenProjectType.TIZEN_CPP_SERVICE_APPLICATION;
                }
                if (!type.equals("webapp")) continue;
                return TizenProjectType.TIZEN_WEB_APPLICATION;
            }
            if (obj instanceof WatchApplication) {
                return TizenProjectType.TIZEN_C_WATCH_APPLICATION;
            }
            if (obj instanceof WidgetApplication) {
                return TizenProjectType.TIZEN_C_WIDGET_APPLICATION;
            }
            if (!(obj instanceof ComponentBasedApplication)) continue;
            type = ((ComponentBasedApplication)obj).getType();
            if (type.equals("capp")) {
                return TizenProjectType.TIZEN_C_COMPONENT_APPLICATION;
            }
            if (!type.equals("c++app")) continue;
            return TizenProjectType.TIZEN_CPP_COMPONENT_APPLICATION;
        }
        return null;
    }

    public List<String> getExecutableNames() {
        ArrayList<String> executableNameList = new ArrayList<String>();
        if (this.coreManifest == null) {
            return executableNameList;
        }
        List<IApplication> appList = this.coreManifest.getApplication_list();
        if (appList.isEmpty()) {
            return executableNameList;
        }
        for (IApplication obj : appList) {
            executableNameList.add(obj.getExec());
        }
        return executableNameList;
    }

    public List<String> getIconFileList() {
        ArrayList<String> IconFileList = new ArrayList<String>();
        if (this.coreManifest == null) {
            return IconFileList;
        }
        Icon icon = this.coreManifest.getIcon();
        if (icon != null) {
            IconFileList.add(icon.getValue());
        }
        return IconFileList;
    }

    public String getPkgId() {
        if (this.coreManifest == null) {
            return "";
        }
        return this.coreManifest.getPackageId();
    }

    public String getVersion() {
        if (this.coreManifest == null) {
            return "";
        }
        return this.coreManifest.getVersion();
    }

    public String getXMLDataId() {
        if (this.coreManifest == null) {
            return "";
        }
        List<IApplication> appList = this.coreManifest.getApplication_list();
        if (appList.isEmpty()) {
            return null;
        }
        IApplication obj = appList.get(0);
        return obj.getAppid();
    }

    public boolean isImeCategory() {
        String[] CATEGORY_PRESETS = new String[]{"http://tizen.org/category/ime", "http://tizen.org/category/homeapp", "http://tizen.org/category/lockapp"};
        Map<String, Category> category_map = null;
        if (this.coreManifest == null) {
            return false;
        }
        List<IApplication> appList = this.coreManifest.getApplication_list();
        if (appList.isEmpty()) {
            return false;
        }
        IApplication obj = appList.get(0);
        if (obj instanceof UiApplication) {
            category_map = ((UiApplication)obj).getCategory_map();
        } else if (obj instanceof ServiceApplication) {
            category_map = ((ServiceApplication)obj).getCategory_map();
        }
        if (category_map != null) {
            Collection<Category> values = category_map.values();
            Iterator<Category> Ir_values = values.iterator();
            while (Ir_values.hasNext()) {
                String f_val = Ir_values.next().getName();
                if (f_val.equalsIgnoreCase(CATEGORY_PRESETS[0])) {
                    return true;
                }
                if (f_val.equalsIgnoreCase(CATEGORY_PRESETS[1])) {
                    return false;
                }
                if (!f_val.equalsIgnoreCase(CATEGORY_PRESETS[2])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isLaunchOnBoot() {
        List<IApplication> appList = this.coreManifest.getApplication_list();
        if (appList.isEmpty()) {
            return false;
        }
        IApplication obj = appList.get(0);
        String strOnBoot = "FALSE";
        if (obj instanceof UiApplication) {
            strOnBoot = ((UiApplication)obj).getOn_boot();
        } else if (obj instanceof ServiceApplication) {
            strOnBoot = ((ServiceApplication)obj).getOn_boot();
        }
        return strOnBoot.equalsIgnoreCase("TRUE");
    }

    public boolean isOspCompat() {
        return false;
    }

    public boolean isSubMode() {
        List<IApplication> appList = this.coreManifest.getApplication_list();
        if (appList.isEmpty()) {
            return false;
        }
        String multi = null;
        IApplication obj = appList.get(0);
        return obj instanceof UiApplication && (multi = ((UiApplication)obj).getMulti_instance()) != null && multi.equalsIgnoreCase(TRUST_ANCHOR_VALUE_TRUE);
    }

    public boolean resetAppId() {
        return false;
    }

    public boolean storeXml(IFile arg0) {
        return false;
    }

    public boolean loadXml(File file) {
        this.coreManifest = new Manifest();
        this.mfHandler.parse(file, this.coreManifest);
        return true;
    }

    public void mergeManifest(ITizenNativeXMLStore refManifest) {
        if (!(refManifest instanceof CoreXMLStore)) {
            return;
        }
        this.mfHandler.merge(this.coreManifest, ((CoreXMLStore)refManifest).coreManifest);
    }

    public Collection<String> getFeatures() {
        if (this.coreManifest == null) {
            return null;
        }
        if (this.coreManifest.getFeature_map().isEmpty()) {
            return null;
        }
        Collection<Feature> values = this.coreManifest.getFeature_map().values();
        Iterator<Feature> Ir_values = values.iterator();
        HashSet<String> f_set = new HashSet<String>();
        while (Ir_values.hasNext()) {
            String f_val = Ir_values.next().getKey();
            f_set.add(f_val);
        }
        return f_set;
    }

    public Collection<String> getPrivileges() {
        if (this.coreManifest == null) {
            return null;
        }
        if (this.coreManifest.getPrivilege_map().isEmpty()) {
            return null;
        }
        Collection<Privilege> values = this.coreManifest.getPrivilege_map().values();
        Iterator<Privilege> Ir_values = values.iterator();
        HashSet<String> p_set = new HashSet<String>();
        while (Ir_values.hasNext()) {
            String p_val = Ir_values.next().getValue();
            p_set.add(p_val);
        }
        return p_set;
    }

    public String getUseSystemCertsOfTrustAnchor() {
        if (this.coreManifest == null) {
            return null;
        }
        if (this.coreManifest.getTrustAnchor() == null) {
            return null;
        }
        if (this.coreManifest.getTrustAnchor().getUse_system_certs().equalsIgnoreCase(TRUST_ANCHOR_VALUE_NONE)) {
            return TRUST_ANCHOR_VALUE_NONE;
        }
        if (this.coreManifest.getTrustAnchor().getUse_system_certs().equalsIgnoreCase(TRUST_ANCHOR_VALUE_TRUE)) {
            return TRUST_ANCHOR_VALUE_TRUE;
        }
        if (this.coreManifest.getTrustAnchor().getUse_system_certs().equalsIgnoreCase(TRUST_ANCHOR_VALUE_FALSE)) {
            return TRUST_ANCHOR_VALUE_FALSE;
        }
        return null;
    }

    public void setId(String appId) {
        if (this.coreManifest == null) {
            return;
        }
        List<IApplication> appList = this.coreManifest.getApplication_list();
        if (appList.isEmpty()) {
            return;
        }
        IApplication obj = appList.get(0);
        obj.setAppid(appId);
    }

    public void setPackage(String packageId) {
        if (this.coreManifest == null) {
            return;
        }
        this.coreManifest.setPackageId(packageId);
    }

    public void setVersion(String version) {
        if (this.coreManifest == null) {
            return;
        }
        this.coreManifest.setVersion(version);
    }

    public String getApiVersion() {
        if (this.coreManifest == null) {
            return "";
        }
        return this.coreManifest.getApiVersion();
    }

    public void setApiVersion(String api_version) {
        if (this.coreManifest == null) {
            return;
        }
        this.coreManifest.setApiVersion(api_version);
    }

    public String getProfileName() {
        String profileName = null;
        if (this.coreManifest.getProfile() != null) {
            profileName = this.coreManifest.getProfile().getName();
        }
        return profileName;
    }

    public void setProfileName(String profileName) {
        this.coreManifest.setProfileName(profileName);
    }
}

