/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.tizen.nativecore.ext.manifest.AppControl;
import org.tizen.nativecore.misc.editor.AppControlPage;
import org.tizen.nativecore.misc.editor.dlg.UiNewAppControlItemDlg;

public class AppControlDetail
implements IDetailsPage {
    protected IManagedForm fMForm;
    private TableViewer fViewer;
    private AppControl appService;
    private AppControlPage fPage;

    public AppControlDetail(AppControlPage page) {
        this.fPage = page;
    }

    public void initialize(IManagedForm form) {
        this.fMForm = form;
    }

    public void dispose() {
    }

    public boolean isDirty() {
        return false;
    }

    public void commit(boolean onSave) {
    }

    public boolean setFormInput(Object input) {
        return false;
    }

    public void setFocus() {
    }

    public boolean isStale() {
        return false;
    }

    public void refresh() {
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection sel = (IStructuredSelection)selection;
        this.appService = sel.size() == 1 ? (AppControl)sel.getFirstElement() : null;
        this.fViewer.setInput((Object)this.appService);
    }

    public void createContents(Composite parent) {
        GridLayout layoutParent = new GridLayout();
        layoutParent.marginTop = 0;
        parent.setLayout((Layout)layoutParent);
        FormToolkit toolkit = this.fMForm.getToolkit();
        Section section = toolkit.createSection(parent, 256);
        section.setText("Attributes for Application Control");
        section.setLayoutData((Object)new GridData(1808));
        toolkit.createCompositeSeparator((Composite)section);
        Composite composite = toolkit.createComposite((Composite)section);
        section.setClient((Control)composite);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        Table table = new Table(composite, 67584);
        GridData gd = new GridData(1808);
        gd.heightHint = 50;
        gd.widthHint = 50;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 2;
        table.setLayoutData((Object)gd);
        this.fViewer = new TableViewer(table);
        this.fViewer.setLabelProvider((IBaseLabelProvider)new MyLabelProvider());
        this.fViewer.setContentProvider((IContentProvider)new MyContentProvider());
        Button btnAdd = toolkit.createButton(composite, "Add...", 8);
        btnAdd.setLayoutData((Object)new GridData(4, 2, false, false));
        btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UiNewAppControlItemDlg dlg = new UiNewAppControlItemDlg(Display.getDefault().getActiveShell(), AppControlDetail.this.appService);
                if (dlg.open() == 0) {
                    AppControl.AppControlItem newItem = dlg.getAppControlItem();
                    AppControlDetail.this.appService.addAppServiceItems(newItem);
                    AppControlDetail.this.fViewer.add((Object)newItem);
                    AppControlDetail.this.fPage.setDirty(true);
                }
            }
        });
        final Button btnRemove = toolkit.createButton(composite, "Remove", 8);
        btnRemove.setLayoutData((Object)new GridData(4, 1, false, false));
        btnRemove.setEnabled(false);
        btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)AppControlDetail.this.fViewer.getSelection();
                AppControl.AppControlItem item = (AppControl.AppControlItem)sel.getFirstElement();
                if (item != null) {
                    AppControlDetail.this.appService.getAppServiceItems().remove(item);
                    AppControlDetail.this.fViewer.remove((Object)item);
                    AppControlDetail.this.fPage.setDirty(true);
                }
            }
        });
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel != null) {
                    btnRemove.setEnabled(true);
                } else {
                    btnRemove.setEnabled(false);
                }
            }
        });
    }

    static class MyContentProvider
    implements IStructuredContentProvider {
        MyContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof AppControl) {
                AppControl as = (AppControl)inputElement;
                return as.getAppServiceItems().toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    static class MyLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        MyLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof AppControl.AppControlItem) {
                AppControl.AppControlItem item = (AppControl.AppControlItem)obj;
                return String.valueOf(item.getValue()) + " - " + item.getCategory().toString();
            }
            return obj.toString();
        }

        public Image getColumnImage(Object obj, int index) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        }
    }
}

