/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.utils;

import java.io.File;

public class Constants {
    public static int MAX_PKGID_LENGTH = 50;
    public static int MIN_PKGID_LENGTH = 3;
    public static String pkgIDErrorMsg = "The Package ID length must be " + MIN_PKGID_LENGTH + "-" + MAX_PKGID_LENGTH + " characters";
    public static int MAX_APPID_LENGTH = 50;
    public static int MIN_APPID_LENGTH = 3;
    public static String appIDErrorMsg = "The Application ID length must be " + MIN_APPID_LENGTH + "-" + MAX_APPID_LENGTH + " characters";
    public static final String[] IMAGE_EXTS = new String[]{"*.gif;*.ico;*.jpeg;*.png;*.jpg;*.bmp"};
    public static final String[] IMAGE_SUPPORTED = new String[]{"gif", "ico", "jpeg", "png", "jpg", "bmp"};
    public static final String NATURE_ID = "org.tizen.nativecore.apichecker.core.tizenCppNature";
    public static final String BUILDER_ID = "org.tizen.nativecore.apichecker.core.builder";
    public static final String PROJECT_FILE = ".project";
    public static final int BASE_VERSION = 2003;
    public static final int VERSION_TWO_DOT_FOUR = 2004;
    public static final String NOT_USED = "NOT_USED";
    public static final String USED = "USED";
    public static final String ADD_PACKAGES = "Add Packages";
    public static final String PREFIX_CHECKER_ID = "org.tizen.nativecore.apichecker.internal.checkers.";
    public static final String CHECKER_ID_PARTNER_API = "org.tizen.nativecore.apichecker.internal.checkers.PartnerApiProblem";
    public static final String CHECKER_ID_API_VERSION = "org.tizen.nativecore.apichecker.internal.checkers.ApiVersionProblem";
    public static final String CHECKER_ID_DEPRECATED_API = "org.tizen.nativecore.apichecker.internal.checkers.DeprecatedApiProblem";
    public static final String CHECKER_ID_DEPRECATED_CLASS = "org.tizen.nativecore.apichecker.internal.checkers.DeprecatedClassProblem";
    public static final String CHECKER_ID_INCOMPATIBLE_API = "org.tizen.nativecore.apichecker.internal.checkers.IncompatibleApiProblem";
    public static final String CHECKER_ID_UNDEFINED_PRIVILEGE = "org.tizen.nativecore.apichecker.internal.checkers.UndefinedPrivilegeProblem";
    public static final String CHECKER_ID_UNUSED_PRIVILEGE = "org.tizen.nativecore.apichecker.internal.checkers.UnusedPrivilegeProblem";
    public static final String PREFIX_MARKER_TYPE = "org.tizen.nativecore.apichecker.core.";
    public static final String MARKER_TYPE_PARTNER_API = "org.tizen.nativecore.apichecker.core.PartnerApiProblem";
    public static final String MARKER_TYPE_API_VERSION = "org.tizen.nativecore.apichecker.core.ApiVersionViolationProblem";
    public static final String MARKER_TYPE_DEPRECATED_API = "org.tizen.nativecore.apichecker.core.DeprecatedApiProblem";
    public static final String MARKER_TYPE_INCOMPATIBLE_API = "org.tizen.nativecore.apichecker.core.IncompatibleApiProblem";
    public static final String MARKER_TYPE_FINAL_API = "org.tizen.nativecore.apichecker.core.FinalApiProblem";
    public static final String MARKER_TYPE_UNDEFINED_PRIVILEGE = "org.tizen.nativecore.apichecker.core.UndefinedPrivilegeProblem";
    public static final String MARKER_TYPE_UNUSED_PRIVILEGE = "org.tizen.nativecore.apichecker.core.UnusedPrivilegeProblem";
    public static final String MARKER_ATTRIBUTE_PRIVILEGE = "privilege";
    public static final String MARKER_ATTRIBUTE_PROJECT_NAME = "projectname";
    public static final String[] WEB_CONTROL_PRIVILEGES = new String[]{"http://tizen.org/privilege/web.privacy", "http://tizen.org/privilege/web.service"};
    public static final String[] WEB_CONTROL_KEYWORD = new String[]{"Web"};
    public static final String DTD_FILE = "UIForm.dtd";
    public static final String SCOPE_OPERATOR = "::";
    public static final String DESTRUCTOR_TILDE = "~";
    public static final String DELIMITERS_FOR_MULTIPLE_PRIVILEGES = " ,";
    public static final String AND_FOR_MULTIPLE_PRIVILEGES = " and ";
    public static final String DELIMITERS_FOR_ORING_PRIVILEGES = " | ";
    public static final String VERSION_INTERVAL_DELIMITER = ":";
    public static final String VOID_TYPE = "void";
    public static final String PUBLIC_API = "public-api";
    public static final String DEPRECATED_API = "deprecated-api";
    public static final String FINAL_API = "final-api";
    public static final String INCOMPATIBLE_API = "incompatible-api";
    public static final String PRIVILEGED_API = "privileged-api";
    public static final String DEPRECATED_PRIVILEGED_API = "deprecated-privileged-api";
    public static final String KEYWORD_COMPAT_PREFIX = "compat-";
    public static final String KEYWORD_OPEN_API = "open-api";
    public static final String KEYWORD_PARTNER_API = "partner-api";
    public static final String FILE_SEP_STR = File.separator;
    public static final String PATH_TOOLS = String.valueOf(FILE_SEP_STR) + "tools";
    public static final String PATH_XMLS = String.valueOf(PATH_TOOLS) + FILE_SEP_STR + "checker";
    public static final String PATH_PUBLIC_XMLS = String.valueOf(FILE_SEP_STR) + "checker" + FILE_SEP_STR + "public-api";
    public static final String PATH_PREVILEGED_XMLS = String.valueOf(FILE_SEP_STR) + "checker" + FILE_SEP_STR + "privileged-api";
    public static final String EXTENSION_XML = ".xml";
    public static final String MOBILE_PROFILE = "mobile";
    public static final String WEARABLE_PROFILE = "wearable";
    public static final String PATH_PLATFORMS = String.valueOf(FILE_SEP_STR) + "platforms";
    public static final String XML_2_3 = String.valueOf(PATH_PLATFORMS) + FILE_SEP_STR + "tizen-2.3" + FILE_SEP_STR;
    public static final String XML_2_3_1 = String.valueOf(PATH_PLATFORMS) + FILE_SEP_STR + "tizen-2.3.1" + FILE_SEP_STR;
    public static final String XML_2_4 = String.valueOf(PATH_PLATFORMS) + FILE_SEP_STR + "tizen-2.4" + FILE_SEP_STR;
    public static final String PATH_2_4_MOBILE_XMLS = String.valueOf(XML_2_4) + "mobile" + PATH_PUBLIC_XMLS;
    public static final String PATH_2_4_WEARABLE_XMLS = String.valueOf(XML_2_4) + "wearable" + PATH_PUBLIC_XMLS;
    public static final String PATH_2_3_1_MOBILE_XMLS = String.valueOf(XML_2_3_1) + "mobile" + PATH_PUBLIC_XMLS;
    public static final String PATH_2_3_1_WEARABLE_XMLS = String.valueOf(XML_2_3_1) + "wearable" + PATH_PUBLIC_XMLS;
    public static final String PATH_2_3_XMLS = String.valueOf(XML_2_3) + "mobile" + PATH_PUBLIC_XMLS;
    public static final String PROJECT_VERSION_2_3 = "2.3";
    public static final String PROJECT_VERSION_2_3_1 = "2.3.1";
    public static final String PROJECT_VERSION_2_4 = "2.4";
    public static final String[] BOOLEAN_WITH_EMPTY = new String[]{"(None)", "true", "false"};
    public static final String[] BOOLEAN_VALUES = new String[]{"true", "false"};
    public static final String[] HW_ACCELERATION_VALUES = new String[]{"(None)", "on", "off"};
    public static final String[] LAUNCH_MODE_VALUES = new String[]{"(None)", "caller", "single", "group"};
    public static final String[] RESOLUTION_VALUES = new String[]{"ldpi", "mdpi", "hdpi", "xhdpi", "xxhdpi"};
    public static final String[] ORIENTTION_VALUES = new String[]{"landscape", "portrait"};

    private Constants() {
    }

    public static String limitVersion(String ver) {
        int indexOfPoint = 0;
        if (ver == null || ver.length() == 0) {
            return "";
        }
        indexOfPoint = ver.indexOf(46);
        if (indexOfPoint == -1) {
            return ver;
        }
        if ((indexOfPoint = ver.indexOf(46, indexOfPoint + 1)) == -1) {
            return ver;
        }
        return ver.substring(0, indexOfPoint);
    }

    public static int generateVersionInt(String ver) {
        int version = 0;
        String REGEX_VERSION = "^\\d+(\\.\\d+){0,3}$";
        if (ver.matches(REGEX_VERSION)) {
            String[] splitString = ver.split("\\.");
            if (splitString[0] != null) {
                version = Integer.parseInt(splitString[0]) * 1000;
            }
            if (splitString[1] != null) {
                version += Integer.parseInt(splitString[1]) * 100;
            }
            if (splitString.length > 2 && splitString[2] != null) {
                version += Integer.parseInt(splitString[2]) * 10;
            }
            if (splitString.length > 3 && splitString[3] != null) {
                version += Integer.parseInt(splitString[3]);
            }
        }
        return version;
    }

    public static String generateVersionString(int version) {
        int major = version / 1000;
        String ver = String.valueOf(Integer.toString(major)) + "." + Integer.toString(version - major * 1000);
        return ver;
    }

    public static String generateQualifiedName(String cname, String mname) {
        if (cname == null || cname.equals("") || cname.contains(".h")) {
            return mname;
        }
        return String.valueOf(cname) + SCOPE_OPERATOR + mname;
    }

    public static String generateQualifiedName(String[] names) {
        String qualifiedName = names[0];
        int i = 1;
        while (i < names.length) {
            qualifiedName = String.valueOf(qualifiedName) + SCOPE_OPERATOR + names[i];
            ++i;
        }
        return qualifiedName;
    }

    public static String generateQualifiedName(String[] cnames, String mname) {
        String qualifiedName = "";
        int i = 0;
        while (i < cnames.length) {
            qualifiedName = String.valueOf(qualifiedName) + cnames[i] + SCOPE_OPERATOR;
            ++i;
        }
        return String.valueOf(qualifiedName) + mname;
    }

    public static String getLastName(String qualifiedName) {
        if (qualifiedName == null) {
            return null;
        }
        int index = qualifiedName.lastIndexOf(SCOPE_OPERATOR);
        if (index >= 0) {
            return qualifiedName.substring(index + 2);
        }
        return qualifiedName;
    }

    public static String removeTemplateOperators(String name) {
        if (name.contains("<")) {
            int index = name.indexOf("<");
            String str = name.substring(0, index);
            return str;
        }
        return name;
    }
}

