/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.indexer;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.CCoreInternals;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.nativecommon.indexer.PreBuiltPdom;
import org.tizen.sdblib.util.IOUtil;

public class ImportPdomRootstrap {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ICProject project;
    private PreBuiltPdom preBuiltPdom;

    public ImportPdomRootstrap(ICProject project, PreBuiltPdom preBuiltPdom) {
        this.project = project;
        this.preBuiltPdom = preBuiltPdom;
    }

    public void run(IProgressMonitor monitor) {
        block6: {
            if (!this.preBuiltPdom.exists()) {
                return;
            }
            File pdomFile = this.preBuiltPdom.getLocation();
            FileInputStream stream = null;
            try {
                try {
                    stream = new FileInputStream(pdomFile);
                    CCoreInternals.getPDOMManager().importProjectPDOM(this.project, (InputStream)stream, monitor);
                }
                catch (Exception e) {
                    this.logger.error("Failed to import rootstrap PDOM: " + pdomFile + ", " + this.project, (Throwable)e);
                    IOUtil.tryClose((Closeable)stream);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtil.tryClose(stream);
                throw throwable;
            }
            IOUtil.tryClose((Closeable)stream);
        }
    }
}

