/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.ext.manifest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.tizen.nativecore.ext.manifest.AppControl;
import org.tizen.nativecore.ext.manifest.BackgroundCategory;
import org.tizen.nativecore.ext.manifest.Category;
import org.tizen.nativecore.ext.manifest.CustomAttribute;
import org.tizen.nativecore.ext.manifest.CustomElement;
import org.tizen.nativecore.ext.manifest.IApplication;
import org.tizen.nativecore.ext.manifest.Icon;
import org.tizen.nativecore.ext.manifest.Label;
import org.tizen.nativecore.ext.manifest.Metadata;
import org.tizen.nativecore.ext.manifest.SupportSize;
import org.tizen.nativecore.ext.manifest.WidgetClass;
import org.tizen.nativecore.misc.core.LocaledValue;
import org.tizen.nativecore.misc.utils.CheckerUtil;
import org.tizen.nativecore.misc.utils.Constants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class WidgetApplication
implements IApplication {
    public static final String ELEMENT = "widget-application";
    public static final String ATTR_APPID = "appid";
    public static final String ATTR_EXEC = "exec";
    public static final String ATTR_MAIN = "main";
    public static final String ATTR_UPDATE_PERIOD = "update-period";
    public static final String ATTR_MAX_INSTANCE = "max-instance";
    public static final String ATTR_HW_ACCELERATION = "hw-acceleration";
    public static final String ATTR_NO_DISPLAY = "nodisplay";
    public static final String ATTR_SETUP_APPID = "setup-appid";
    private String appid;
    private String exec;
    private String main;
    private String update_period;
    private String max_instance;
    private String hw_acceleration;
    private String nodisplay;
    private String setup_appid;
    private String apiVersion;
    private Label defaultLabel;
    private Icon defaultIcon;
    private List<LocaledValue> label_list = new ArrayList<LocaledValue>();
    private List<LocaledValue> icon_list = new ArrayList<LocaledValue>();
    private Map<String, SupportSize> supportSizes = new HashMap<String, SupportSize>();
    private List<Metadata> metadataList;
    private List<WidgetClass> widgetClassList;
    public static final String STRING_TRUE = "true";
    public static final String STRING_FALSE = "false";
    private List<CustomAttribute> customAttrList = new ArrayList<CustomAttribute>();
    private List<CustomElement> customElementList = new ArrayList<CustomElement>();

    @Override
    public void loadElement(Element element) {
        if (!element.getNodeName().equals(ELEMENT)) {
            return;
        }
        this.setApiVersion(element.getAttribute("api-version"));
        this.setAppid(element.getAttribute(ATTR_APPID));
        this.setExec(element.getAttribute(ATTR_EXEC));
        this.setMain(element.getAttribute(ATTR_MAIN));
        this.setUpdate_period(element.getAttribute(ATTR_UPDATE_PERIOD));
        String max_instance = element.getAttribute(ATTR_MAX_INSTANCE);
        this.setSetup_appid(element.getAttribute(ATTR_SETUP_APPID));
        if (max_instance == null || max_instance.isEmpty() || max_instance.equals("0") || !max_instance.matches("^[0-9]*$")) {
            element.removeAttribute(ATTR_MAX_INSTANCE);
        } else {
            this.setMax_Instance(element.getAttribute(ATTR_MAX_INSTANCE));
        }
        if (element.getAttribute(ATTR_HW_ACCELERATION).equals(Constants.HW_ACCELERATION_VALUES[1]) || element.getAttribute(ATTR_HW_ACCELERATION).equals(Constants.HW_ACCELERATION_VALUES[2])) {
            this.setHw_acceleration(element.getAttribute(ATTR_HW_ACCELERATION));
        } else {
            this.setHw_acceleration(Constants.HW_ACCELERATION_VALUES[0]);
        }
        if (element.getAttribute(ATTR_NO_DISPLAY).equals(Constants.BOOLEAN_WITH_EMPTY[1]) || element.getAttribute(ATTR_NO_DISPLAY).equals(Constants.BOOLEAN_WITH_EMPTY[2])) {
            this.setNodisplay(element.getAttribute(ATTR_NO_DISPLAY));
        } else {
            this.setNodisplay(Constants.BOOLEAN_WITH_EMPTY[0]);
        }
        NamedNodeMap attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Node node = attrs.item(i);
            String attr = node.getNodeName();
            if (this.isCustomAttribute(attr)) {
                CustomAttribute custom = new CustomAttribute();
                custom.loadAttribute(attr, node.getNodeValue());
                this.getCustomAttrList().add(custom);
            }
            ++i;
        }
        Node node = element.getFirstChild();
        while (node != null) {
            String nodeName = node.getNodeName();
            if (nodeName.equals("label")) {
                Label label = new Label();
                label.loadElement((Element)node);
                if (label.getLang() != null && label.getLang().length() > 0) {
                    this.label_list.add(new LocaledValue(label.getLang(), label.getValue()));
                } else {
                    this.defaultLabel = label;
                }
            } else if (nodeName.equals("icon")) {
                Icon icon = new Icon();
                icon.loadElement((Element)node);
                if (icon.getLang() != null && icon.getLang().length() > 0) {
                    this.icon_list.add(new LocaledValue(icon.getLang(), icon.getValue()));
                } else {
                    this.defaultIcon = icon;
                }
            } else if (nodeName.equals("support-size")) {
                SupportSize supportSize = new SupportSize();
                supportSize.loadElement((Element)node);
                if (supportSize.getValue() != null) {
                    this.supportSizes.put(supportSize.getValue(), supportSize);
                }
            } else if (nodeName.equals("metadata")) {
                Metadata metadata = new Metadata();
                metadata.loadElement((Element)node);
                this.getMetadataList().add(metadata);
            } else if (nodeName.equals("widget-class")) {
                WidgetClass widgetClass = new WidgetClass();
                widgetClass.loadElement((Element)node);
                this.getWidgetClassList().add(widgetClass);
            } else if (node.getNodeType() == 1) {
                CustomElement custom = new CustomElement();
                custom.loadElement((Element)node);
                this.getCustomElementList().add(custom);
            }
            node = node.getNextSibling();
        }
    }

    @Override
    public void generateElement(Document dom, Element parent) {
        Element element = dom.createElement(ELEMENT);
        parent.appendChild(element);
        if (this.apiVersion != null && CheckerUtil.isApplicationAPIVersionSupported(this.apiVersion)) {
            element.setAttribute("api-version", this.apiVersion);
        }
        if (this.getAppid() != null && this.getAppid().length() > 0) {
            element.setAttribute(ATTR_APPID, this.getAppid());
        } else {
            element.setAttribute(ATTR_APPID, "");
        }
        if (this.exec != null && this.exec.length() > 0) {
            element.setAttribute(ATTR_EXEC, this.exec);
        } else {
            element.setAttribute(ATTR_EXEC, "");
        }
        if (this.main != null && this.main.length() > 0) {
            element.setAttribute(ATTR_MAIN, this.main);
        } else {
            element.setAttribute(ATTR_MAIN, STRING_FALSE);
        }
        if (this.update_period != null && this.update_period.length() > 0) {
            element.setAttribute(ATTR_UPDATE_PERIOD, this.update_period);
        } else {
            element.setAttribute(ATTR_UPDATE_PERIOD, "0");
        }
        if (this.max_instance != null && this.max_instance.length() > 0) {
            if (this.max_instance.equals("0")) {
                element.removeAttribute(ATTR_MAX_INSTANCE);
            } else {
                element.setAttribute(ATTR_MAX_INSTANCE, this.max_instance);
            }
        }
        if (this.setup_appid != null && !this.setup_appid.isEmpty()) {
            element.setAttribute(ATTR_SETUP_APPID, this.setup_appid);
        }
        if (this.hw_acceleration != null && this.hw_acceleration.length() > 0 && !this.hw_acceleration.equals(Constants.HW_ACCELERATION_VALUES[0])) {
            element.setAttribute(ATTR_HW_ACCELERATION, this.hw_acceleration);
        }
        if (this.nodisplay != null && this.nodisplay.length() > 0 && !this.nodisplay.equals(Constants.BOOLEAN_WITH_EMPTY[0])) {
            element.setAttribute(ATTR_NO_DISPLAY, this.nodisplay);
        }
        for (CustomAttribute customAttribute : this.getCustomAttrList()) {
            customAttribute.generateAttribute(element);
        }
        this.generateLabels(dom, element);
        this.generateIcons(dom, element);
        if (this.getSupportSizesMap().size() > 0) {
            Collection<SupportSize> collection = this.getSupportSizesMap().values();
            Iterator<SupportSize> Ir_values = collection.iterator();
            while (Ir_values.hasNext()) {
                Ir_values.next().generateElement(dom, element);
            }
        }
        for (Metadata metadata : this.getMetadataList()) {
            if (metadata == null) continue;
            metadata.generateElement(dom, element);
        }
        for (WidgetClass widgetClass : this.getWidgetClassList()) {
            if (widgetClass == null) continue;
            widgetClass.generateElement(dom, element);
        }
        for (CustomElement customElement : this.getCustomElementList()) {
            customElement.generateElement(dom, element);
        }
    }

    public String getMain() {
        return this.main;
    }

    public void setMain(String main) {
        this.main = main;
    }

    public String getUpdate_period() {
        return this.update_period;
    }

    public void setUpdate_period(String update_period) {
        this.update_period = update_period;
    }

    public void setMax_Instance(String max_instance) {
        this.max_instance = max_instance;
    }

    public String getMax_Instance() {
        return this.max_instance;
    }

    @Override
    public String getExec() {
        return this.exec;
    }

    @Override
    public void setExec(String exec) {
        this.exec = exec;
    }

    @Override
    public String getAppid() {
        return this.appid;
    }

    @Override
    public void setAppid(String appid) {
        this.appid = appid;
    }

    @Override
    public List<Metadata> getMetadataList() {
        if (this.metadataList == null) {
            this.metadataList = new ArrayList<Metadata>();
        }
        return this.metadataList;
    }

    @Override
    public Icon getDefaultIcon() {
        return this.defaultIcon;
    }

    @Override
    public void setDefaultIcon(Icon defaultIcon) {
        this.defaultIcon = defaultIcon;
    }

    @Override
    public Label getDefaultLabel() {
        return this.defaultLabel;
    }

    @Override
    public void setDefaultLabel(Label defaultLabel) {
        this.defaultLabel = defaultLabel;
    }

    @Override
    public List<LocaledValue> getLabels() {
        return this.label_list;
    }

    private void generateLabels(Document dom, Element parent) {
        List<LocaledValue> labels = this.getLabels();
        if (labels.isEmpty() && this.defaultLabel == null) {
            return;
        }
        if (this.defaultLabel != null) {
            Element eLabel = dom.createElement("label");
            eLabel.setTextContent(this.defaultLabel.getValue());
            parent.appendChild(eLabel);
        }
        for (LocaledValue lv : labels) {
            Element eLabel = dom.createElement("label");
            if (lv.getLocale() != null && lv.getLocale().length() > 0) {
                eLabel.setAttribute("xml:lang", lv.getLocale());
            }
            eLabel.setTextContent(lv.getValue());
            parent.appendChild(eLabel);
        }
    }

    @Override
    public List<LocaledValue> getIcons() {
        return this.icon_list;
    }

    private void generateIcons(Document dom, Element parent) {
        List<LocaledValue> icons = this.getIcons();
        if (icons.isEmpty() && this.defaultIcon == null) {
            return;
        }
        if (this.defaultIcon != null) {
            Element eIcon = dom.createElement("icon");
            eIcon.setTextContent(this.defaultIcon.getValue());
            parent.appendChild(eIcon);
        }
        for (LocaledValue lv : icons) {
            Element eIcon = dom.createElement("icon");
            if (lv.getLocale() != null && lv.getLocale().length() > 0) {
                eIcon.setAttribute("xml:lang", lv.getLocale());
            }
            eIcon.setTextContent(lv.getValue());
            parent.appendChild(eIcon);
        }
    }

    @Override
    public List<AppControl> getAppServiceList() {
        return null;
    }

    @Override
    public void setAppServiceList(List<AppControl> application_service) {
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    public Map<String, Category> getCategory_map() {
        return null;
    }

    public Map<String, SupportSize> getSupportSizesMap() {
        return this.supportSizes;
    }

    public String getHw_acceleration() {
        return this.hw_acceleration;
    }

    public void setHw_acceleration(String hw_acceleration) {
        this.hw_acceleration = hw_acceleration;
    }

    @Override
    public List<BackgroundCategory> getBgCategoryList() {
        return null;
    }

    public List<CustomElement> getCustomElementList() {
        return this.customElementList;
    }

    public List<CustomAttribute> getCustomAttrList() {
        return this.customAttrList;
    }

    private boolean isCustomAttribute(String attr) {
        if (attr.equals(ATTR_APPID)) {
            return false;
        }
        if (attr.equals(ATTR_EXEC)) {
            return false;
        }
        if (attr.equals(ATTR_HW_ACCELERATION)) {
            return false;
        }
        if (attr.equals(ATTR_MAIN)) {
            return false;
        }
        if (attr.equals(ATTR_UPDATE_PERIOD)) {
            return false;
        }
        if (attr.equals(ATTR_MAX_INSTANCE)) {
            return false;
        }
        if (attr.equals(ATTR_NO_DISPLAY)) {
            return false;
        }
        if (attr.equals(ATTR_SETUP_APPID)) {
            return false;
        }
        return !attr.equals("api-version");
    }

    public String getNodisplay() {
        return this.nodisplay;
    }

    public void setNodisplay(String nodisplay) {
        this.nodisplay = nodisplay;
    }

    public String getSetup_appid() {
        return this.setup_appid;
    }

    public void setSetup_appid(String setup_appid) {
        this.setup_appid = setup_appid;
    }

    public List<WidgetClass> getWidgetClassList() {
        if (this.widgetClassList == null) {
            this.widgetClassList = new ArrayList<WidgetClass>();
        }
        return this.widgetClassList;
    }

    public void setWidgetClassList(List<WidgetClass> widgetClassList) {
        this.widgetClassList = widgetClassList;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }
}

