/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.core;

import java.util.HashMap;
import java.util.Map;
import org.tizen.nativecore.misc.core.ScreenDensity;

public enum IconType {
    MAINMENU("Main menu", "MainMenu", 117, 78),
    ACCOUNT("Account", 72, 48),
    ACCOUNTSMALL("Account small", 45, 30),
    ETC("Etc", 120, 80);

    private final String fDisplayName;
    private String fSectionName;
    private final Map<ScreenDensity, Integer> fSize = new HashMap<ScreenDensity, Integer>(2);

    private IconType(String name, int xhigh_size, int high_size) {
        this.fDisplayName = name;
        this.fSize.put(ScreenDensity.XHIGH, xhigh_size);
        this.fSize.put(ScreenDensity.HIGH, high_size);
    }

    private IconType(String name, String sName, int xhigh_size, int high_size) {
        this(name, xhigh_size, high_size);
        this.fSectionName = sName;
    }

    public int getIconSize(ScreenDensity density) {
        if (this.fSize.containsKey((Object)density)) {
            return this.fSize.get((Object)density);
        }
        return 108;
    }

    public String getDisplayName() {
        return this.fDisplayName;
    }

    public String getSectionName() {
        return this.fSectionName;
    }

    public boolean isCircleIcon() {
        return this != ETC;
    }

    public static IconType getEnumBySectionName(String section) {
        IconType[] iconTypeArray = IconType.values();
        int n = iconTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IconType it = iconTypeArray[n2];
            String sname = it.getSectionName();
            if (sname != null && sname.equals(section)) {
                return it;
            }
            ++n2;
        }
        return null;
    }
}

