/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.utils;

import java.io.IOException;
import java.io.StringReader;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PositionalXmlParser
extends DefaultHandler {
    private Document mDoc;
    final Stack<Element> mStack = new Stack();
    final StringBuilder mTextBuffer = new StringBuilder();
    private Locator mLocator;
    private String mRawString;
    private int mCurrentLine;
    private int mCurrentOffset;
    private int mCurrentColumn;
    private static final String POS_KEY = "start";

    public Document parse(String rawString, InputSource is) throws ParserConfigurationException, SAXException, IOException {
        this.mRawString = rawString;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        this.mDoc = docBuilder.newDocument();
        parser.parse(is, (DefaultHandler)this);
        return this.mDoc;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.mLocator = locator;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.mTextBuffer.setLength(0);
        Element el = this.mDoc.createElement(qName);
        int i = 0;
        while (i < attributes.getLength()) {
            Attr attr = this.mDoc.createAttribute(attributes.getQName(i));
            attr.setValue(attributes.getValue(i));
            el.setAttributeNode(attr);
            ++i;
        }
        NodePosition pos = new NodePosition(this.getCurrentOffset(), 0);
        int line = this.mCurrentLine;
        int i2 = pos.getStart() - 1;
        while (i2 >= 0) {
            char c = this.mRawString.charAt(i2);
            if (c == '<') {
                pos.setStart(i2);
                break;
            }
            if (c == '\n') {
                --line;
            }
            --i2;
        }
        pos.setStartLine(line);
        el.setUserData(POS_KEY, pos, null);
        this.mStack.addElement(el);
    }

    private int getCurrentOffset() {
        int line = this.mLocator.getLineNumber() - 1;
        int column = this.mLocator.getColumnNumber() - 1;
        int length = this.mRawString.length();
        while (this.mCurrentLine < line && this.mCurrentOffset < length) {
            char c = this.mRawString.charAt(this.mCurrentOffset);
            if (c == '\n') {
                ++this.mCurrentLine;
                this.mCurrentColumn = 0;
            } else {
                ++this.mCurrentColumn;
            }
            ++this.mCurrentOffset;
        }
        this.mCurrentOffset += column - this.mCurrentColumn;
        this.mCurrentOffset = Math.min(this.mCurrentOffset, length);
        this.mCurrentColumn = column;
        return this.mCurrentOffset;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.mTextBuffer.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.addTextIfNeeded();
        Element element = this.mStack.pop();
        int offset = this.getCurrentOffset();
        NodePosition pos = (NodePosition)element.getUserData(POS_KEY);
        pos.setEnd(offset);
        if (this.mStack.isEmpty()) {
            this.mDoc.appendChild(element);
        } else {
            Element parent = this.mStack.peek();
            parent.appendChild(element);
        }
    }

    private void addTextIfNeeded() {
        if (this.mTextBuffer.length() > 0 && !this.mStack.isEmpty()) {
            Element el = this.mStack.peek();
            Text textNode = this.mDoc.createTextNode(this.mTextBuffer.toString().trim());
            el.appendChild(textNode);
            this.mTextBuffer.setLength(0);
        }
    }

    public Document parse(String string) throws ParserConfigurationException, SAXException, IOException {
        return this.parse(string, new InputSource(new StringReader(string)));
    }

    public NodePosition getPosition(Element e) {
        return (NodePosition)e.getUserData(POS_KEY);
    }

    public NodePosition getAttributePosition(Element e, String attrName) {
        NodePosition pos = (NodePosition)e.getUserData(POS_KEY);
        Pattern pattern = Pattern.compile(String.format("%s\\s*=\\s*[\"']\\s*\\w*\\s*[\"']", attrName));
        Matcher matcher = pattern.matcher(this.mRawString);
        if (matcher.find(pos.getStart()) && matcher.start() <= pos.getEnd()) {
            NodePosition npos = new NodePosition(matcher.start(), matcher.end());
            int line = pos.getStartLine();
            int current = pos.getStart();
            while (current < npos.getEnd()) {
                char c = this.mRawString.charAt(current);
                if (c == '\n') {
                    ++line;
                }
                ++current;
            }
            npos.setStartLine(line);
            return npos;
        }
        return pos;
    }

    public static class NodePosition {
        int mStart;
        int mEnd;
        int mLineStart;

        public NodePosition(int start, int end) {
            this.mStart = start;
            this.mEnd = end;
        }

        public int getStartLine() {
            return this.mLineStart;
        }

        public void setStartLine(int line) {
            this.mLineStart = line;
        }

        public int getEnd() {
            return this.mEnd;
        }

        public int getStart() {
            return this.mStart;
        }

        public void setEnd(int mEnd) {
            this.mEnd = mEnd;
        }

        public void setStart(int mStart) {
            this.mStart = mStart;
        }

        public String toString() {
            return "(" + this.mStart + "," + this.mEnd + ")";
        }
    }
}

