/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.ext.manifest;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.tizen.nativecore.ext.manifest.AppControl;
import org.tizen.nativecore.ext.manifest.BackgroundCategory;
import org.tizen.nativecore.ext.manifest.Category;
import org.tizen.nativecore.ext.manifest.IApplication;
import org.tizen.nativecore.ext.manifest.Icon;
import org.tizen.nativecore.ext.manifest.Label;
import org.tizen.nativecore.ext.manifest.Metadata;
import org.tizen.nativecore.misc.core.LocaledValue;
import org.tizen.nativecore.misc.utils.CheckerUtil;
import org.tizen.nativecore.misc.utils.Constants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ImeApplication
implements IApplication {
    public static final String ELEMENT = "ime-application";
    public static final String ATTR_APPID = "appid";
    public static final String ATTR_EXEC = "exec";
    public static final String ATTR_MULTIPLE = "multiple";
    public static final String ATTR_NODISPLAY = "nodisplay";
    public static final String ATTR_TYPE = "type";
    public static final String STRING_TRUE = "true";
    public static final String STRING_FALSE = "false";
    private String appid;
    private String exec;
    private String multiple;
    private String nodisplay;
    private String type;
    private String apiVersion;
    private Label defaultLabel;
    private List<LocaledValue> label_list = new ArrayList<LocaledValue>();
    private Icon icon = new Icon();

    @Override
    public void loadElement(Element element) {
        if (!element.getNodeName().equals(ELEMENT)) {
            return;
        }
        this.setApiVersion(element.getAttribute("api-version"));
        this.setAppid(element.getAttribute(ATTR_APPID));
        this.setExec(element.getAttribute(ATTR_EXEC));
        if (element.getAttribute(ATTR_MULTIPLE).equals(STRING_TRUE) || element.getAttribute(ATTR_MULTIPLE).equals(STRING_FALSE)) {
            this.setMultiple(element.getAttribute(ATTR_MULTIPLE));
        } else {
            this.setMultiple(Constants.BOOLEAN_WITH_EMPTY[0]);
        }
        if (element.getAttribute(ATTR_NODISPLAY).equals(STRING_TRUE) || element.getAttribute(ATTR_NODISPLAY).equals(STRING_FALSE)) {
            this.setNodisplay(element.getAttribute(ATTR_NODISPLAY));
        } else {
            this.setNodisplay(Constants.BOOLEAN_WITH_EMPTY[0]);
        }
        this.setType(element.getAttribute(ATTR_TYPE));
        Node node = element.getFirstChild();
        while (node != null) {
            String nodeName = node.getNodeName();
            if (nodeName.equals("label")) {
                Label label = new Label();
                label.loadElement((Element)node);
                if (label.getLang() != null && label.getLang().length() > 0) {
                    this.label_list.add(new LocaledValue(label.getLang(), label.getValue()));
                } else {
                    this.defaultLabel = label;
                }
            } else if (nodeName.equals("icon")) {
                this.icon.loadElement((Element)node);
            }
            node = node.getNextSibling();
        }
    }

    @Override
    public void generateElement(Document dom, Element parent) {
        Element element = dom.createElement(ELEMENT);
        parent.appendChild(element);
        if (this.apiVersion != null && CheckerUtil.isApplicationAPIVersionSupported(this.apiVersion)) {
            element.setAttribute("api-version", this.apiVersion);
        }
        if (this.getAppid() != null && this.getAppid().length() > 0) {
            element.setAttribute(ATTR_APPID, this.getAppid());
        } else {
            element.setAttribute(ATTR_APPID, "");
        }
        if (this.getExec() != null && this.getExec().length() > 0) {
            element.setAttribute(ATTR_EXEC, this.getExec());
        } else {
            element.setAttribute(ATTR_EXEC, "");
        }
        if (this.getMultiple() != null && this.getMultiple().length() > 0 && !this.getMultiple().equals(Constants.BOOLEAN_WITH_EMPTY[0])) {
            element.setAttribute(ATTR_MULTIPLE, this.getMultiple());
        }
        if (this.getNodisplay() != null && this.getNodisplay().length() > 0 && !this.getNodisplay().equals(Constants.BOOLEAN_WITH_EMPTY[0])) {
            element.setAttribute(ATTR_NODISPLAY, this.getNodisplay());
        }
        if (this.getType() != null && this.getType().length() > 0) {
            element.setAttribute(ATTR_TYPE, this.getType());
        } else {
            element.setAttribute(ATTR_TYPE, "");
        }
        this.generateLabels(dom, element);
        if (this.icon != null) {
            this.icon.generateElement(dom, element);
        }
    }

    public String getMultiple() {
        return this.multiple;
    }

    public String getNodisplay() {
        return this.nodisplay;
    }

    public void setMultiple(String multiple) {
        this.multiple = multiple;
    }

    public void setNodisplay(String nodisplay) {
        this.nodisplay = nodisplay;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public List<Metadata> getMetadataList() {
        return null;
    }

    @Override
    public String getExec() {
        return this.exec;
    }

    @Override
    public List<AppControl> getAppServiceList() {
        return null;
    }

    @Override
    public void setAppServiceList(List<AppControl> application_service) {
    }

    @Override
    public Map<String, Category> getCategory_map() {
        return null;
    }

    @Override
    public void setExec(String exec) {
        this.exec = exec;
    }

    @Override
    public Label getDefaultLabel() {
        return this.defaultLabel;
    }

    @Override
    public void setDefaultLabel(Label defaultLabel) {
        this.defaultLabel = defaultLabel;
    }

    @Override
    public List<LocaledValue> getLabels() {
        return this.label_list;
    }

    @Override
    public String getAppid() {
        return this.appid;
    }

    @Override
    public void setAppid(String appId) {
        this.appid = appId;
    }

    private void generateLabels(Document dom, Element parent) {
        List<LocaledValue> labels = this.getLabels();
        if (labels.isEmpty() && this.defaultLabel == null) {
            return;
        }
        if (this.defaultLabel != null) {
            Element eLabel = dom.createElement("label");
            eLabel.setTextContent(this.defaultLabel.getValue());
            parent.appendChild(eLabel);
        }
        for (LocaledValue lv : labels) {
            Element eLabel = dom.createElement("label");
            if (lv.getLocale() != null && lv.getLocale().length() > 0) {
                eLabel.setAttribute("xml:lang", lv.getLocale());
            }
            eLabel.setTextContent(lv.getValue());
            parent.appendChild(eLabel);
        }
    }

    @Override
    public List<LocaledValue> getIcons() {
        return null;
    }

    @Override
    public Icon getDefaultIcon() {
        return null;
    }

    @Override
    public void setDefaultIcon(Icon icon) {
    }

    @Override
    public List<BackgroundCategory> getBgCategoryList() {
        return null;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }
}

