/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor.dlg;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.tizen.nativecore.ext.manifest.WidgetClass;
import org.tizen.nativecore.misc.IdePlugin;
import org.tizen.nativecore.misc.editor.TizenFormPage;
import org.tizen.nativecore.misc.editor.UiWidgetClassAttrIconWithCheck;
import org.tizen.nativecore.misc.editor.dlg.Messages;

public class UiNewWidgetClassDialog
extends SelectionStatusDialog {
    private static final int UPDATE_PERIOD_MIN_VALUE = 0;
    private static final int UPDATE_PERIOD_MAX_VALUE = 864000;
    private static final int SELECTABLE_INTERVAL = 1800;
    private static final int LENGTH_UPDATE_PERIOD_MAX_VALUE = 6;
    private FormToolkit toolkit;
    private TizenFormPage fpage;
    private Text fUpdatePeriod;
    private Text fClassIdText;
    private Text fSetupAppIdText;
    private Button plus;
    private Button minus;
    private Label updatePeriodLabel;
    private String classid;
    private String update_period;
    private String setup_appid;
    private boolean updatePeriodChangeFlag;
    private UiWidgetClassAttrIconWithCheck fSize11;
    private UiWidgetClassAttrIconWithCheck fSize21;
    private UiWidgetClassAttrIconWithCheck fSize22;
    private UiWidgetClassAttrIconWithCheck fSize41;
    private UiWidgetClassAttrIconWithCheck fSize42;
    private UiWidgetClassAttrIconWithCheck fSize43;
    private UiWidgetClassAttrIconWithCheck fSize44;
    private WidgetClass fWidgetClass;
    private List<WidgetClass> fExistingWidgetClasses;
    public static final String[] SUPPORT_SIZES = new String[]{"1x1", "2x1", "2x2", "4x1", "4x2", "4x3", "4x4"};
    public static final String EMPTY_STRING = "";
    public String dayHourMinFormat = "( {0}:{1}:{2} dd:hh:mm )";
    private VerifyListener verifyListener = new VerifyListener(){

        public void verifyText(VerifyEvent event) {
            if (UiNewWidgetClassDialog.this.updatePeriodChangeFlag) {
                return;
            }
            String text = event.text;
            char[] chars = new char[text.length()];
            text.getChars(0, chars.length, chars, 0);
            int i = 0;
            while (i < chars.length) {
                if ('0' > chars[i] || chars[i] > '9') {
                    event.doit = false;
                    return;
                }
                ++i;
            }
        }
    };
    private ModifyListener updatePeriodModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            if (UiNewWidgetClassDialog.this.updatePeriodChangeFlag) {
                return;
            }
        }
    };
    private FocusListener updatePeriodFocusListener = new FocusListener(){

        public void focusLost(FocusEvent event) {
            if (event.widget == UiNewWidgetClassDialog.this.fUpdatePeriod) {
                UiNewWidgetClassDialog.this.updatePeriodText();
            }
        }

        public void focusGained(FocusEvent event) {
        }
    };

    public UiNewWidgetClassDialog(FormToolkit tk, TizenFormPage page, List<WidgetClass> widgetClasses, WidgetClass editTarget, boolean editMode) {
        super(Display.getDefault().getActiveShell());
        this.toolkit = tk;
        this.fpage = page;
        this.setStatusLineAboveButtons(true);
        this.setHelpAvailable(false);
        this.fWidgetClass = editTarget;
        if (!editMode) {
            this.setTitle(Messages.UiNewWidgetClassDialog_widget_class_add_title);
            this.fExistingWidgetClasses = widgetClasses;
        } else {
            this.setTitle(Messages.UiNewWidgetClassDialog_widget_class_edit_title);
            this.fExistingWidgetClasses = new ArrayList<WidgetClass>(widgetClasses.size());
            for (WidgetClass w : widgetClasses) {
                if (editTarget.equals(w)) continue;
                this.fExistingWidgetClasses.add(w);
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(new Color(null, 255, 255, 255));
        GridLayout layout = new GridLayout(2, false);
        layout.marginTop = 20;
        layout.marginBottom = 9;
        layout.marginLeft = 20;
        layout.marginRight = 20;
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 510;
        composite.setLayoutData((Object)gridData);
        Label classIdLabel = new Label(composite, 0);
        classIdLabel.setBackground(new Color(null, 255, 255, 255));
        classIdLabel.setText(Messages.UiNewWidgetClassDialog_widget_class_ID);
        this.fClassIdText = new Text(composite, 2048);
        this.fClassIdText.setBackground(new Color(null, 255, 255, 255));
        gridData = new GridData(4, 2, true, false);
        this.fClassIdText.setLayoutData((Object)gridData);
        Label setupAppIdLabel = new Label(composite, 0);
        setupAppIdLabel.setBackground(new Color(null, 255, 255, 255));
        setupAppIdLabel.setText(Messages.UiNewWidgetClassDialog_widget_class_setup_app_ID);
        this.fSetupAppIdText = new Text(composite, 2048);
        this.fSetupAppIdText.setBackground(new Color(null, 255, 255, 255));
        gridData = new GridData(4, 2, true, false);
        this.fSetupAppIdText.setLayoutData((Object)gridData);
        Label label = new Label(composite, 0);
        label.setText(Messages.UiNewWidgetClassDialog_update_period_label);
        label.setBackground(new Color(null, 255, 255, 255));
        label.setToolTipText(Messages.UiNewWidgetClassDialog_update_period_tooltip);
        Composite updatePeriodComposite = new Composite(composite, 0);
        updatePeriodComposite.setBackground(new Color(null, 255, 255, 255));
        gridData = new GridData(4, 4, true, true);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginLeft = -5;
        updatePeriodComposite.setLayout((Layout)gridLayout);
        updatePeriodComposite.setLayoutData((Object)gridData);
        this.fUpdatePeriod = new Text(updatePeriodComposite, 2048);
        this.fUpdatePeriod.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fUpdatePeriod.addVerifyListener(this.verifyListener);
        this.fUpdatePeriod.addModifyListener(this.updatePeriodModifyListener);
        this.fUpdatePeriod.addFocusListener(this.updatePeriodFocusListener);
        this.fUpdatePeriod.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 262144 && event.widget == UiNewWidgetClassDialog.this.fUpdatePeriod) {
                    UiNewWidgetClassDialog.this.updatePeriodText();
                }
            }
        });
        ImageData imageData = null;
        this.plus = new Button(updatePeriodComposite, 8);
        imageData = new ImageData(IdePlugin.getDefault().getResourceLocationURL("icons/editor/plus.png").getFile());
        this.plus.setImage(new Image(null, imageData));
        this.plus.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent arg0) {
            }

            public void mouseDown(MouseEvent event) {
                UiNewWidgetClassDialog.this.incrementUpdatePeriod();
            }

            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
        this.minus = new Button(updatePeriodComposite, 8);
        imageData = new ImageData(IdePlugin.getDefault().getResourceLocationURL("icons/editor/minus.png").getFile());
        this.minus.setImage(new Image(null, imageData));
        this.minus.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent arg0) {
            }

            public void mouseDown(MouseEvent event) {
                UiNewWidgetClassDialog.this.decrementUpdatePeriod();
            }

            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
        new Label(composite, 0);
        this.updatePeriodLabel = new Label(composite, 0);
        this.updatePeriodLabel.setBackground(new Color(null, 255, 255, 255));
        GridData labelGridData = new GridData(16384, 0x1000000, true, false);
        this.updatePeriodLabel.setLayoutData((Object)labelGridData);
        if (this.fWidgetClass != null && this.fUpdatePeriod != null) {
            String value = this.fWidgetClass.getUpdate_period();
            this.updatePeriodChangeFlag = true;
            int intValue = 0;
            if (value != null) {
                if (value.isEmpty() || !value.matches("^[0-9]*$")) {
                    intValue = 0;
                } else if (value.length() > 6) {
                    intValue = 864000;
                } else {
                    intValue = Integer.parseInt(value);
                    if (intValue > 864000) {
                        intValue = 864000;
                    } else if (intValue % 1800 != 0) {
                        intValue = intValue / 1800 * 1800;
                    }
                }
            }
            this.fUpdatePeriod.setText(String.valueOf(intValue));
            this.fWidgetClass.setUpdate_period(String.valueOf(intValue));
            this.updatePeriodLabel.setText(this.computeInDayHourMinFormat(intValue));
            this.updatePeriodChangeFlag = false;
        } else {
            int intValue = 0;
            this.updatePeriodLabel.setText(this.computeInDayHourMinFormat(intValue));
            this.updatePeriodChangeFlag = false;
        }
        Composite table = new Composite(composite, 0);
        table.setLayout((Layout)new GridLayout());
        gridData = new GridData(4, 0, true, false);
        gridData.horizontalSpan = 2;
        table.setLayoutData((Object)gridData);
        table.setBackground(new Color(null, 255, 255, 255));
        label = new Label(table, 0);
        label.setText(Messages.UiNewWidgetClassDialog_support_sizes_text);
        label.setBackground(new Color(null, 255, 255, 255));
        Group group = new Group(table, 0);
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        group.setBackground(new Color(null, 255, 255, 255));
        layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        if (this.fpage.getEditor().getCoreManifest().getProfile().getName().equals("wearable")) {
            this.fSize22 = new UiWidgetClassAttrIconWithCheck(this.fpage, this.fWidgetClass, this);
            this.fSize22.createUi((Composite)group, this.toolkit, SUPPORT_SIZES[2], false);
        } else {
            this.fSize21 = new UiWidgetClassAttrIconWithCheck(this.fpage, this.fWidgetClass, this);
            this.fSize21.createUi((Composite)group, this.toolkit, SUPPORT_SIZES[1], false);
            this.fSize22 = new UiWidgetClassAttrIconWithCheck(this.fpage, this.fWidgetClass, this);
            this.fSize22.createUi((Composite)group, this.toolkit, SUPPORT_SIZES[2], false);
            this.fSize41 = new UiWidgetClassAttrIconWithCheck(this.fpage, this.fWidgetClass, this);
            this.fSize41.createUi((Composite)group, this.toolkit, SUPPORT_SIZES[3], false);
            this.fSize42 = new UiWidgetClassAttrIconWithCheck(this.fpage, this.fWidgetClass, this);
            this.fSize42.createUi((Composite)group, this.toolkit, SUPPORT_SIZES[4], false);
            this.fSize43 = new UiWidgetClassAttrIconWithCheck(this.fpage, this.fWidgetClass, this);
            this.fSize43.createUi((Composite)group, this.toolkit, SUPPORT_SIZES[5], false);
            this.fSize44 = new UiWidgetClassAttrIconWithCheck(this.fpage, this.fWidgetClass, this);
            this.fSize44.createUi((Composite)group, this.toolkit, SUPPORT_SIZES[6], false);
        }
        if (this.fWidgetClass != null && this.fWidgetClass.getClassid() != null) {
            this.fClassIdText.setText(this.fWidgetClass.getClassid());
        }
        if (this.fWidgetClass != null && this.fWidgetClass.getUpdate_period() != null) {
            this.fUpdatePeriod.setText(this.fWidgetClass.getUpdate_period());
        }
        if (this.fWidgetClass != null && this.fWidgetClass.getSetup_appid() != null) {
            this.fSetupAppIdText.setText(this.fWidgetClass.getSetup_appid());
        }
        this.fClassIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UiNewWidgetClassDialog.this.validate();
            }
        });
        this.updateSupportSizesUi();
        this.validate();
        return composite;
    }

    protected void computeResult() {
        this.fWidgetClass.setClassid(this.fClassIdText.getText().trim());
        this.fWidgetClass.setUpdate_period(this.fUpdatePeriod.getText().trim());
        this.fWidgetClass.setSetup_appid(this.fSetupAppIdText.getText().trim());
        this.updateSupportSizes();
    }

    private void updateSupportSizesUi() {
        if (this.fWidgetClass == null) {
            return;
        }
        if (this.fWidgetClass.getWidgetClassSupportSizes().size() > 0) {
            if (this.fSize11 != null) {
                this.fSize11.updateUI(this.fWidgetClass.getWidgetClassSupportSizes().get(SUPPORT_SIZES[0]));
            }
            if (this.fSize21 != null) {
                this.fSize21.updateUI(this.fWidgetClass.getWidgetClassSupportSizes().get(SUPPORT_SIZES[1]));
            }
            if (this.fSize22 != null) {
                this.fSize22.updateUI(this.fWidgetClass.getWidgetClassSupportSizes().get(SUPPORT_SIZES[2]));
            }
            if (this.fSize41 != null) {
                this.fSize41.updateUI(this.fWidgetClass.getWidgetClassSupportSizes().get(SUPPORT_SIZES[3]));
            }
            if (this.fSize42 != null) {
                this.fSize42.updateUI(this.fWidgetClass.getWidgetClassSupportSizes().get(SUPPORT_SIZES[4]));
            }
            if (this.fSize43 != null) {
                this.fSize43.updateUI(this.fWidgetClass.getWidgetClassSupportSizes().get(SUPPORT_SIZES[5]));
            }
            if (this.fSize44 != null) {
                this.fSize44.updateUI(this.fWidgetClass.getWidgetClassSupportSizes().get(SUPPORT_SIZES[6]));
            }
        }
    }

    public void validate() {
        this.computeResult();
        Status status = null;
        if (this.fWidgetClass.getClassid().isEmpty()) {
            status = new Status(4, "org.tizen.nativecore.misc", Messages.UiNewWidgetClassDialog_classID_error);
            this.updateStatus((IStatus)status);
            return;
        }
        if (this.fWidgetClass.getWidgetClassSupportSizes().isEmpty()) {
            status = new Status(4, "org.tizen.nativecore.misc", Messages.UiNewWidgetClassDialog_support_size_error);
            this.updateStatus((IStatus)status);
            return;
        }
        for (WidgetClass w : this.fExistingWidgetClasses) {
            if (!w.getClassid().equals(this.fWidgetClass.getClassid())) continue;
            status = new Status(4, "org.tizen.nativecore.misc", Messages.UiNewWidgetClassDialog_existing_classID_error);
            this.updateStatus((IStatus)status);
            return;
        }
        status = new Status(0, "org.tizen.nativecore.misc", null);
        this.updateStatus((IStatus)status);
    }

    private void updateSupportSizes() {
        if (this.fSize21 != null && this.fSize21.getSupportSize() != null) {
            this.fWidgetClass.getWidgetClassSupportSizes().put(this.fSize21.getLabelText(), this.fSize21.getSupportSize());
        }
        if (this.fSize22 != null && this.fSize22.getSupportSize() != null) {
            this.fWidgetClass.getWidgetClassSupportSizes().put(this.fSize22.getLabelText(), this.fSize22.getSupportSize());
        }
        if (this.fSize41 != null && this.fSize41.getSupportSize() != null) {
            this.fWidgetClass.getWidgetClassSupportSizes().put(this.fSize41.getLabelText(), this.fSize41.getSupportSize());
        }
        if (this.fSize42 != null && this.fSize42.getSupportSize() != null) {
            this.fWidgetClass.getWidgetClassSupportSizes().put(this.fSize42.getLabelText(), this.fSize42.getSupportSize());
        }
        if (this.fSize43 != null && this.fSize43.getSupportSize() != null) {
            this.fWidgetClass.getWidgetClassSupportSizes().put(this.fSize43.getLabelText(), this.fSize43.getSupportSize());
        }
        if (this.fSize44 != null && this.fSize44.getSupportSize() != null) {
            this.fWidgetClass.getWidgetClassSupportSizes().put(this.fSize44.getLabelText(), this.fSize44.getSupportSize());
        }
    }

    private void updatePeriodText() {
        String value = this.fUpdatePeriod.getText();
        this.updatePeriodChangeFlag = true;
        int intValue = 0;
        if (value != null && !value.isEmpty()) {
            if (value.length() > 6) {
                intValue = 864000;
            } else {
                intValue = Integer.parseInt(value);
                if (intValue > 864000) {
                    intValue = 864000;
                } else if (intValue % 1800 != 0) {
                    intValue = intValue / 1800 * 1800;
                }
            }
        } else {
            intValue = 0;
        }
        this.fUpdatePeriod.setText(String.valueOf(intValue));
        String dayHourMinFormatValue = this.computeInDayHourMinFormat(intValue);
        this.updatePeriodLabel.setText(dayHourMinFormatValue);
        this.updatePeriodChangeFlag = false;
    }

    private void incrementUpdatePeriod() {
        String value = this.fUpdatePeriod.getText();
        int intValue = 0;
        if (!value.isEmpty()) {
            intValue = Integer.parseInt(value);
            if ((intValue += 1800) > 864000) {
                intValue = 864000;
            }
        } else {
            intValue = 0;
        }
        this.fUpdatePeriod.setText(String.valueOf(intValue));
        this.updatePeriodLabel.setText(this.computeInDayHourMinFormat(intValue));
    }

    private void decrementUpdatePeriod() {
        String value = this.fUpdatePeriod.getText();
        int intValue = 0;
        if (!value.isEmpty()) {
            intValue = Integer.parseInt(value);
            if ((intValue -= 1800) < 0) {
                intValue = 0;
            }
        } else {
            intValue = 0;
        }
        this.fUpdatePeriod.setText(String.valueOf(intValue));
        this.updatePeriodLabel.setText(this.computeInDayHourMinFormat(intValue));
    }

    private String computeInDayHourMinFormat(int seconds) {
        int mins = 0;
        int hours = 0;
        int days = 0;
        mins = seconds / 60;
        seconds %= 60;
        hours = mins / 60;
        mins %= 60;
        days = hours / 24;
        String daysString = EMPTY_STRING;
        String hoursString = EMPTY_STRING;
        String minsString = EMPTY_STRING;
        daysString = days < 10 ? "0" + days : String.valueOf(days);
        hoursString = hours < 10 ? "0" + hours : String.valueOf(hours %= 24);
        minsString = mins < 10 ? "0" + mins : String.valueOf(mins);
        return MessageFormat.format(this.dayHourMinFormat, daysString, hoursString, minsString);
    }

    public WidgetClass getWidgetClass() {
        return this.fWidgetClass;
    }

    public void setWidgetClass(WidgetClass widgetClass) {
        this.fWidgetClass = widgetClass;
    }

    public String getClassid() {
        return this.classid;
    }

    public String getUpdate_period() {
        return this.update_period;
    }

    public String getSetup_appid() {
        return this.setup_appid;
    }

    public void setClassid(String classid) {
        this.classid = classid;
    }

    public void setUpdate_period(String update_period) {
        this.update_period = update_period;
    }

    public void setSetup_appid(String setup_appid) {
        this.setup_appid = setup_appid;
    }
}

