/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.cdt.internal.ui.refactoring.ChangeExceptionHandler;
import org.eclipse.cdt.internal.ui.refactoring.IScheduledRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.Messages;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringSaveHelper;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringUI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class RefactoringExecutionHelper {
    private final Refactoring fRefactoring;
    private final Shell fParent;
    private final IRunnableContext fExecContext;
    private final int fStopSeverity;
    private final int fSaveMode;

    public RefactoringExecutionHelper(Refactoring refactoring, int stopSeverity, int saveMode, Shell parent, IRunnableContext context) {
        Assert.isNotNull((Object)refactoring);
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)context);
        this.fRefactoring = refactoring;
        this.fStopSeverity = stopSeverity;
        this.fParent = parent;
        this.fExecContext = context;
        this.fSaveMode = saveMode;
    }

    public void perform(boolean fork, boolean cancelable) throws InterruptedException, InvocationTargetException {
        this.perform(fork, false, cancelable);
    }

    public void perform(boolean fork, boolean forkChangeExecution, boolean cancelable) throws InterruptedException, InvocationTargetException {
        Operation operation = new Operation(fork, forkChangeExecution, cancelable);
        this.performOperation(operation, null, fork);
    }

    public void performChange(Change change, boolean fork) throws InterruptedException, InvocationTargetException {
        PerformChangeOperation operation = this.createPerformChangeOperation(change);
        this.performOperation(null, operation, fork);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void performOperation(Operation operation, PerformChangeOperation changeOperation, boolean fork) throws InterruptedException, InvocationTargetException {
        Assert.isTrue((boolean)(operation == null ^ changeOperation == null));
        Assert.isTrue((Display.getCurrent() != null ? 1 : 0) != 0);
        final IJobManager manager = Job.getJobManager();
        final ISchedulingRule rule = this.getSchedulingRule();
        try {
            try {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        manager.beginRule(rule, null);
                    }
                };
                BusyIndicator.showWhile((Display)this.fParent.getDisplay(), (Runnable)r);
            }
            catch (OperationCanceledException e) {
                throw new InterruptedException(e.getMessage());
            }
            RefactoringSaveHelper saveHelper = new RefactoringSaveHelper(this.fSaveMode);
            if (operation != null && !saveHelper.saveEditors(this.fParent)) {
                throw new InterruptedException();
            }
            this.fRefactoring.setValidationContext((Object)this.fParent);
            try {
                try {
                    RefactoringStatus validationStatus;
                    if (operation != null) {
                        this.fExecContext.run(fork, operation.fCancelable, (IRunnableWithProgress)new WorkbenchRunnableAdapter(operation, rule, true));
                        changeOperation = operation.fPerformChangeOperation;
                        boolean bl = fork = fork && !operation.fForkChangeExecution;
                    }
                    if (changeOperation == null) return;
                    if (fork) {
                        this.fExecContext.run(false, false, (IRunnableWithProgress)new WorkbenchRunnableAdapter((IWorkspaceRunnable)changeOperation, rule, true));
                    }
                    if ((validationStatus = changeOperation.getValidationStatus()) == null || !validationStatus.hasFatalError()) return;
                    MessageDialog.openError((Shell)this.fParent, (String)this.fRefactoring.getName(), (String)NLS.bind((String)Messages.RefactoringExecutionHelper_cannot_execute, (Object)validationStatus.getMessageMatchingSeverity(4)));
                    throw new InterruptedException();
                }
                catch (InvocationTargetException e) {
                    if (changeOperation == null || !changeOperation.changeExecutionFailed()) throw e;
                    ChangeExceptionHandler handler = new ChangeExceptionHandler(this.fParent, this.fRefactoring);
                    Throwable inner = e.getTargetException();
                    if (inner instanceof RuntimeException) {
                        handler.handle(changeOperation.getChange(), (RuntimeException)inner);
                    } else {
                        if (!(inner instanceof CoreException)) throw e;
                        handler.handle(changeOperation.getChange(), (CoreException)inner);
                    }
                    saveHelper.triggerIncrementalBuild();
                    return;
                }
                catch (OperationCanceledException e) {
                    throw new InterruptedException(e.getMessage());
                }
            }
            finally {
                saveHelper.triggerIncrementalBuild();
            }
        }
        finally {
            manager.endRule(rule);
            this.fRefactoring.setValidationContext(null);
        }
    }

    private ISchedulingRule getSchedulingRule() {
        if (this.fRefactoring instanceof IScheduledRefactoring) {
            return ((IScheduledRefactoring)this.fRefactoring).getSchedulingRule();
        }
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private PerformChangeOperation createPerformChangeOperation(Change change) {
        PerformChangeOperation operation = new PerformChangeOperation(change);
        operation.setUndoManager(RefactoringCore.getUndoManager(), this.fRefactoring.getName());
        if (this.fRefactoring instanceof IScheduledRefactoring) {
            operation.setSchedulingRule(((IScheduledRefactoring)this.fRefactoring).getSchedulingRule());
        }
        return operation;
    }

    private class Operation
    implements IWorkspaceRunnable {
        Change fChange;
        PerformChangeOperation fPerformChangeOperation;
        final boolean fForked;
        final boolean fForkChangeExecution;
        final boolean fCancelable;

        public Operation(boolean forked, boolean forkChangeExecution, boolean cancelable) {
            this.fForked = forked;
            this.fForkChangeExecution = forkChangeExecution;
            this.fCancelable = cancelable;
        }

        public void run(IProgressMonitor pm) throws CoreException {
            try {
                pm.beginTask("", this.fForked && !this.fForkChangeExecution ? 7 : 11);
                pm.subTask("");
                final RefactoringStatus status = RefactoringExecutionHelper.this.fRefactoring.checkAllConditions((IProgressMonitor)new SubProgressMonitor(pm, 4, 4));
                if (status.getSeverity() >= RefactoringExecutionHelper.this.fStopSeverity) {
                    final boolean[] canceled = new boolean[1];
                    if (this.fForked) {
                        RefactoringExecutionHelper.this.fParent.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                canceled[0] = Operation.this.showStatusDialog(status);
                            }
                        });
                    } else {
                        canceled[0] = this.showStatusDialog(status);
                    }
                    if (canceled[0]) {
                        throw new OperationCanceledException();
                    }
                }
                this.fChange = RefactoringExecutionHelper.this.fRefactoring.createChange((IProgressMonitor)new SubProgressMonitor(pm, 2, 4));
                this.fChange.initializeValidationData((IProgressMonitor)new SubProgressMonitor(pm, 1, 4));
                this.fPerformChangeOperation = RefactoringExecutionHelper.this.createPerformChangeOperation(this.fChange);
                if (!this.fForked || this.fForkChangeExecution) {
                    this.fPerformChangeOperation.run((IProgressMonitor)new SubProgressMonitor(pm, 4, 4));
                }
            }
            finally {
                pm.done();
            }
        }

        private boolean showStatusDialog(RefactoringStatus status) {
            Dialog dialog = RefactoringUI.createRefactoringStatusDialog((RefactoringStatus)status, (Shell)RefactoringExecutionHelper.this.fParent, (String)RefactoringExecutionHelper.this.fRefactoring.getName(), (boolean)false);
            return dialog.open() == 1;
        }
    }
}

