/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.ext.manifest;

import java.util.ArrayList;
import java.util.List;
import org.tizen.nativecore.ext.manifest.Dependency;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Dependencies {
    private List<Dependency> dependenciesList = new ArrayList<Dependency>();

    public void loadElement(Element element) {
        Node node = element.getFirstChild();
        while (node != null) {
            String nodeName = node.getNodeName();
            if (nodeName.equals("dependency")) {
                Dependency dependency = new Dependency();
                dependency.loadElement((Element)node);
                this.dependenciesList.add(dependency);
            }
            node = node.getNextSibling();
        }
    }

    public void generateElement(Document dom, Element parent) {
        if (this.dependenciesList.size() > 0) {
            Element element = dom.createElement("dependencies");
            for (Dependency dependency : this.dependenciesList) {
                dependency.generateElement(dom, element);
            }
            parent.appendChild(element);
        }
    }

    public List<Dependency> getDependenciesList() {
        return this.dependenciesList;
    }

    public void clear() {
        this.dependenciesList.clear();
    }
}

