/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.PackageResourceInfo;
import org.tizen.common.core.application.TizenPackageInfoStore;
import org.tizen.common.rds.DeltaResourceInfo;
import org.tizen.sdblib.util.StringUtil;
import org.tizen.tpklib.TPK;

public class TizenNativePackageInfoStore
extends TizenPackageInfoStore {
    private static Logger logger = LoggerFactory.getLogger(TizenNativePackageInfoStore.class);
    private String buildType;
    private String binFileName;
    private Map<String, String> includeMap;

    public TizenNativePackageInfoStore(IProject project) {
        super(project);
    }

    public TizenNativePackageInfoStore(IProject project, List<PackageResourceInfo> resInfoList, List<PackageResourceInfo> invisibleResInfoList) {
        super(project, resInfoList, invisibleResInfoList);
    }

    public TizenNativePackageInfoStore(IProject project, List<PackageResourceInfo> resInfoList, List<PackageResourceInfo> invisibleResInfoList, Map<String, String> includeMap, String buildType, String binFileName) {
        this(project, resInfoList, invisibleResInfoList);
        this.buildType = buildType;
        this.binFileName = binFileName;
        this.includeMap = includeMap;
    }

    public void getLinkedList(IResource res, List<IResource> linkedResourceList) {
        IResource[] members = null;
        if (res instanceof IProject) {
            try {
                members = ((IProject)res).members();
            }
            catch (CoreException e) {
                logger.error("Failed to find members in " + res, (Throwable)e);
            }
        } else if (res instanceof IFolder) {
            try {
                members = ((IFolder)res).members();
            }
            catch (CoreException e) {
                logger.error("Failed to find members in " + res, (Throwable)e);
            }
        }
        if (members != null) {
            IResource[] iResourceArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                ResourceAttributes attr = member.getResourceAttributes();
                if (member.isLinked() || attr != null && attr.isSymbolicLink()) {
                    if (member.getType() == 2) {
                        this.getLinkedFilteredList(member, linkedResourceList);
                    } else if (member.getType() == 1) {
                        linkedResourceList.add(member);
                    }
                } else if (member.getType() == 2) {
                    this.getLinkedList(member, linkedResourceList);
                }
                ++n2;
            }
        }
    }

    private void getLinkedFilteredList(IResource res, List<IResource> filteredResourceList) {
        IResource[] members = null;
        if (res instanceof IProject) {
            try {
                members = ((IProject)res).members();
            }
            catch (CoreException e) {
                logger.error("Failed to find members in " + res, (Throwable)e);
            }
        } else if (res instanceof IFolder) {
            try {
                members = ((IFolder)res).members();
            }
            catch (CoreException e) {
                logger.error("Failed to find members in " + res, (Throwable)e);
            }
        }
        if (members != null) {
            IResource[] iResourceArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource member = iResourceArray[n2];
                if (member.getType() == 2) {
                    this.getLinkedFilteredList(member, filteredResourceList);
                } else if (member.getType() == 1) {
                    filteredResourceList.add(member);
                }
                ++n2;
            }
        }
    }

    public Map<String, String> getIncludeMap() {
        HashMap<String, String> includeMap = new HashMap<String, String>();
        ArrayList<IResource> filteredResourceList = new ArrayList<IResource>();
        this.getLinkedList((IResource)this.getProject(), filteredResourceList);
        TPK tpk = TPK.getInstance();
        String dest = "";
        for (IResource res : filteredResourceList) {
            dest = res.getType() == 1 ? tpk.getIncludePath(res.getProjectRelativePath().toOSString(), this.buildType, this.binFileName) : tpk.getIncludePath(res.getProjectRelativePath().toOSString(), this.buildType, this.binFileName);
            if (StringUtil.isEmpty((CharSequence)dest)) continue;
            includeMap.put(res.getLocation().toString(), dest);
        }
        return includeMap;
    }

    public List<DeltaResourceInfo> getInterestList() {
        ArrayList<DeltaResourceInfo> interestList = new ArrayList<DeltaResourceInfo>();
        for (PackageResourceInfo resInfo : this.getResInfoList()) {
            if (resInfo.getElementType() == 1) {
                interestList.add(new DeltaResourceInfo(resInfo.getName(), resInfo.getRemotePath()));
                continue;
            }
            if (resInfo.getElementType() == 0) continue;
            resInfo.getElementType();
        }
        for (PackageResourceInfo resInfo : this.getInvisiblePkgRes()) {
            if (resInfo.getElementType() == 1) {
                interestList.add(new DeltaResourceInfo(resInfo.getName(), resInfo.getRemotePath()));
                continue;
            }
            if (resInfo.getElementType() == 0) continue;
            resInfo.getElementType();
        }
        ArrayList<IResource> filteredResourceList = new ArrayList<IResource>();
        this.getLinkedList((IResource)this.getProject(), filteredResourceList);
        TPK tpk = TPK.getInstance();
        String dest = "";
        for (IResource res : filteredResourceList) {
            dest = tpk.getIncludePath(res.getProjectRelativePath().toOSString(), this.buildType, this.binFileName);
            if (StringUtil.isEmpty((CharSequence)dest)) continue;
            interestList.add(new DeltaResourceInfo("/" + res.getProjectRelativePath().toString(), "/" + dest));
        }
        return interestList;
    }

    public Map<String, String> getOriginIncludeMap() {
        return this.includeMap;
    }

    public String getBuildType() {
        return this.buildType;
    }

    public String getBinFileName() {
        return this.binFileName;
    }
}

