/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.page;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Section;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.ui.dialog.NewIconDialog;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.ImageUtil;
import org.tizen.common.util.ProjectUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.common.util.ValidationUtil;
import org.tizen.web.common.WebConstant;
import org.tizen.web.common.core.WebProjectUtil;
import org.tizen.web.editor.configuration.Activator;
import org.tizen.web.editor.configuration.ConfigurationEditor;
import org.tizen.web.editor.configuration.IMobileConfigurator;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.editor.configuration.Messages;
import org.tizen.web.editor.configuration.page.AbstractFormPage;

public class OverviewPage
extends AbstractFormPage {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String OverviewPage_ID = "Overview";
    public static final String MESSAGEKEY_ID = "identifier";
    public static final String MESSAGEKEY_VERSION = "version";
    public static final String MESSAGEKEY_CONTENT = "content";
    public static final String MESSAGEKEY_ICON = "icon";
    public static final String MESSAGEKEY_AUTHOREMAIL = "authorEmail";
    public static final String MESSAGEKEY_AUTHORHREF = "authorHref";
    public static final String MESSAGEKEY_LICENSEHREF = "licenseHref";
    public static final String EMPTY_ICON = "icons/ConfigurationEditor/64_empty_icon.png";
    public static final int ICON_PREVIEW_SIZE = 90;
    private Text identifierText;
    private Text versionText;
    private Text nameText;
    private Text contentText;
    private Text iconSrcText;
    private Label iconPreview;
    private Image currentIcon;
    private Image emptyIcon;
    private Text authorText;
    private Text authorEmailText;
    private Text authorHrefText;
    private Text licenseText;
    private Text licenseHrefText;
    private Text descriptionText;
    private Spinner widthSpinner;
    private Spinner heightSpinner;
    private Combo viewmodeCombo;
    private ModifyListener idModifyListener;
    private ModifyListener versionModifyListener;
    private ModifyListener nameModifyListener;
    private ModifyListener contentModifyListener;
    private ModifyListener iconModifyListener;
    private ModifyListener authorEmailModifyListener;
    private ModifyListener authorHrefModifyListener;
    private ModifyListener licenseHrefModifyListener;
    private ModifyListener modifyListener;
    private SelectionListener selectionListener;

    public OverviewPage(ConfigurationEditor editor) {
        super(editor, OverviewPage_ID, Messages.OverviewPage_ID);
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.createForm(Messages.OverviewPage_ID, "icons/ConfigurationEditor/40_title_overview.png");
        Composite page = this.createPage(this.body);
        Composite generalSection = this.editorToolkit.createSection(page, Messages.OverviewPage_GeneralSectionLabel, Messages.OverviewPage_GeneralSectionDescription);
        this.createGeneralControl(generalSection);
        this.createIconControl(generalSection);
        ((Section)generalSection.getParent()).setExpanded(true);
        Composite appSection = this.editorToolkit.createSection(page, Messages.OverviewPage_SectionLabel, Messages.OverviewPage_SectionDescription);
        this.createAuthorControl(appSection);
        this.createLicenseControl(appSection);
        this.createDescControl(appSection);
        ((Section)appSection.getParent()).setExpanded(true);
        Composite appUiSection = this.editorToolkit.createSection(page, Messages.OverviewPage_UISectionLabel, Messages.OverviewPage_UISectionDescription);
        this.createAppUiControl(appUiSection);
        ((Section)appUiSection.getParent()).setExpanded(true);
        this.addListener();
    }

    protected void createGeneralControl(Composite parent) {
        Composite base = this.editorToolkit.createComposite(parent, 64);
        GridLayout grid = new GridLayout(2, false);
        grid.horizontalSpacing = 30;
        grid.verticalSpacing = 16;
        base.setLayout((Layout)grid);
        base.setLayoutData((Object)new GridData(768));
        Label identifierLabel = this.editorToolkit.createBoldLabel(base, Messages.OverviewPage_IdTextLabel, 64);
        identifierLabel.setToolTipText(Messages.OverviewPage_IdTextTooltip);
        GridData data = new GridData(1, 2, false, false);
        data.widthHint = 110;
        identifierLabel.setLayoutData((Object)data);
        this.identifierText = this.editorToolkit.createText(base, "", 2048);
        this.identifierText.setLayoutData((Object)new GridData(4, 2, true, false));
        Label nameLabel = this.editorToolkit.createBoldLabel(base, Messages.OverviewPage_NameTextLabel, 64);
        nameLabel.setToolTipText(Messages.OverviewPage_NameTextTooltip);
        data = new GridData(1, 2, false, false);
        data.widthHint = 110;
        nameLabel.setLayoutData((Object)data);
        Composite nameComposite = this.editorToolkit.createComposite(base, 0);
        grid = new GridLayout(4, false);
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        grid.verticalSpacing = 0;
        grid.horizontalSpacing = 10;
        nameComposite.setLayout((Layout)grid);
        nameComposite.setLayoutData((Object)new GridData(768));
        this.nameText = this.editorToolkit.createText(nameComposite, "", 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 2, true, false));
        Label dummy = new Label(nameComposite, 0);
        data = new GridData(1, 2, false, false);
        data.widthHint = 32;
        dummy.setLayoutData((Object)data);
        dummy.setVisible(false);
        Label versionLabel = this.editorToolkit.createBoldLabel(nameComposite, Messages.OverviewPage_VersionTextLabel, 64);
        versionLabel.setToolTipText(Messages.OverviewPage_VersionTextTooltip);
        data = new GridData(1, 2, false, false);
        data.widthHint = 70;
        versionLabel.setLayoutData((Object)data);
        this.versionText = this.editorToolkit.createText(nameComposite, "", 2048);
        this.versionText.setLayoutData((Object)new GridData(4, 2, true, false));
        Label contentLabel = this.editorToolkit.createBoldLabel(base, Messages.OverviewPage_ContentTextLabel, 64);
        contentLabel.setToolTipText(Messages.OverviewPage_ContentTextTooltip);
        data = new GridData(1, 2, false, false);
        data.widthHint = 110;
        contentLabel.setLayoutData((Object)data);
        Composite contentComposite = this.editorToolkit.createComposite(base, 0);
        grid = new GridLayout(2, false);
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        grid.verticalSpacing = 0;
        grid.horizontalSpacing = 10;
        contentComposite.setLayout((Layout)grid);
        contentComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.contentText = this.editorToolkit.createText(contentComposite, "", 2048);
        this.contentText.setLayoutData((Object)new GridData(4, 2, true, false));
        this.createContentBrowserBtn(contentComposite, this.contentText, WebConstant.HTML_FILTER_EXTENSIONS);
    }

    private Button createContentBrowserBtn(Composite parent, final Text parentText, final String[] extensions) {
        Button button = this.createButton(parent, "", 8);
        button.setText(org.tizen.common.Messages.BrowserButtonLabel);
        button.setLayoutData((Object)new GridData(3, 2, false, false));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(parentText.getShell());
                dialog.setFilterExtensions(extensions);
                String projectPath = SWTUtil.getProjectPath();
                dialog.setFilterPath(projectPath);
                dialog.setText(org.tizen.common.Messages.DialogOpenLabel);
                if (dialog.open() != null) {
                    String selectedFile = dialog.getFileName();
                    StringBuilder from = new StringBuilder(dialog.getFilterPath()).append("/").append(selectedFile);
                    StringBuilder des = null;
                    if (projectPath != null) {
                        des = new StringBuilder(projectPath).append("/").append(selectedFile);
                        try {
                            FileUtil.copyTo((String)from.toString(), (String)des.toString());
                            SWTUtil.refreshLocal();
                        }
                        catch (IOException iOException) {
                            OverviewPage.this.logger.error("Error occured", (Object)e);
                        }
                        catch (Exception e2) {
                            OverviewPage.this.logger.error("Error occured", (Throwable)e2);
                        }
                    }
                    parentText.setText(selectedFile);
                }
            }
        });
        return button;
    }

    private void createIconControl(Composite parent) {
        Composite base = this.editorToolkit.createComposite(parent, 64);
        GridLayout grid = new GridLayout(1, false);
        grid.marginTop = 10;
        grid.verticalSpacing = 7;
        base.setLayout((Layout)grid);
        base.setLayoutData((Object)new GridData(768));
        Label iconLabel = this.editorToolkit.createBoldLabel(base, Messages.OverviewPage_IconTextLabel, 64);
        iconLabel.setToolTipText(Messages.OverviewPage_IconTextTooltip);
        GridData data = new GridData(1, 2, false, false);
        iconLabel.setLayoutData((Object)data);
        Composite iconComposite = this.editorToolkit.createComposite(base, 2048);
        grid = new GridLayout(2, false);
        grid.marginHeight = 20;
        grid.marginWidth = 20;
        grid.horizontalSpacing = 29;
        grid.verticalSpacing = 10;
        iconComposite.setLayout((Layout)grid);
        iconComposite.setLayoutData((Object)new GridData(768));
        Label sourceLabel = this.editorToolkit.createLabel(iconComposite, Messages.OverviewPage_IconSourceTextLabel, 64);
        sourceLabel.setToolTipText(Messages.OverviewPage_IconSourceTooltip);
        data = new GridData(1, 2, false, false);
        data.widthHint = 90;
        sourceLabel.setLayoutData((Object)data);
        Composite sourceComposite = this.editorToolkit.createComposite(iconComposite, 0);
        grid = new GridLayout(2, false);
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        grid.verticalSpacing = 0;
        grid.horizontalSpacing = 10;
        sourceComposite.setLayout((Layout)grid);
        sourceComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.iconSrcText = this.editorToolkit.createText(sourceComposite, "", 2048);
        this.iconSrcText.setLayoutData((Object)new GridData(4, 2, true, false));
        this.createIconFileBrowserBtn(sourceComposite, this.iconSrcText);
        Label previewLabel = this.editorToolkit.createLabel(iconComposite, Messages.OverviewPage_IconPreviewLabel, 64);
        data = new GridData(1, 2, false, false);
        data.widthHint = 90;
        previewLabel.setLayoutData((Object)data);
        this.iconPreview = this.editorToolkit.createLabel(iconComposite, "", 0);
        GridData iconPreviewData = new GridData(1, 2, false, false);
        iconPreviewData.heightHint = 90;
        iconPreviewData.widthHint = 90;
        this.iconPreview.setLayoutData((Object)iconPreviewData);
        this.emptyIcon = new Image((Device)SWTUtil.getDisplay(), ImageUtil.getImageData((Plugin)Activator.getDefault(), (String)EMPTY_ICON).scaledTo(90, 90));
        this.iconPreview.setImage(this.emptyIcon);
    }

    private Button createIconFileBrowserBtn(Composite parent, final Text parentText) {
        Button button = this.createButton(parent, org.tizen.common.Messages.BrowserButtonLabel, 8);
        button.setLayoutData((Object)new GridData(3, 2, false, false));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String src = null;
                String fullSrc = null;
                NewIconDialog dialog = new NewIconDialog(parentText.getShell(), OverviewPage.this.tizenConfig.getProject());
                if (dialog.open() != 0) {
                    return;
                }
                fullSrc = dialog.getIconPath();
                src = dialog.getIconFileName();
                if (!StringUtil.isEmpty((CharSequence)fullSrc) && !StringUtil.isEmpty((CharSequence)src)) {
                    parentText.setText(src);
                }
                OverviewPage.this.setIconPreview(src);
            }
        });
        return button;
    }

    protected void createAuthorControl(Composite parent) {
        Composite base = this.editorToolkit.createComposite(parent, 64);
        GridLayout grid = new GridLayout(1, false);
        grid.verticalSpacing = 7;
        base.setLayout((Layout)grid);
        base.setLayoutData((Object)new GridData(768));
        Label label = this.editorToolkit.createBoldLabel(base, Messages.WidgetPage_AuthorGroupLabel, 64);
        label.setToolTipText(Messages.WidgetPage_AuthorGroupLabel);
        GridData data = new GridData(1, 2, false, false);
        label.setLayoutData((Object)data);
        Composite authorComposite = this.editorToolkit.createComposite(base, 2048);
        grid = new GridLayout(2, false);
        grid.marginHeight = 20;
        grid.marginWidth = 20;
        grid.horizontalSpacing = 29;
        grid.verticalSpacing = 16;
        authorComposite.setLayout((Layout)grid);
        authorComposite.setLayoutData((Object)new GridData(768));
        Label authorLabel = this.editorToolkit.createLabel(authorComposite, Messages.WidgetPage_AuthorTextLabel, 64);
        authorLabel.setToolTipText(Messages.WidgetPage_AuthorTextTooltip);
        data = new GridData(1, 2, false, false);
        data.widthHint = 90;
        authorLabel.setLayoutData((Object)data);
        this.authorText = this.editorToolkit.createText(authorComposite, "", 2048);
        this.authorText.setLayoutData((Object)new GridData(4, 2, true, false));
        Label mailLabel = this.editorToolkit.createLabel(authorComposite, Messages.WidgetPage_AuthorEmailTextLabel, 64);
        mailLabel.setToolTipText(Messages.WidgetPage_AuthorEmailTextTooltip);
        data = new GridData(1, 2, false, false);
        data.widthHint = 90;
        mailLabel.setLayoutData((Object)data);
        this.authorEmailText = this.editorToolkit.createText(authorComposite, "", 2048);
        this.authorEmailText.setLayoutData((Object)new GridData(4, 2, true, false));
        Label hrefLabel = this.editorToolkit.createLabel(authorComposite, Messages.WidgetPage_AuthorHrefTextLabel, 0);
        hrefLabel.setToolTipText(Messages.WidgetPage_AuthorHrefTextTooltip);
        data = new GridData(1, 2, false, false);
        data.widthHint = 90;
        hrefLabel.setLayoutData((Object)data);
        this.authorHrefText = this.editorToolkit.createText(authorComposite, "", 2048);
        this.authorHrefText.setLayoutData((Object)new GridData(4, 2, true, false));
    }

    protected void createLicenseControl(Composite parent) {
        Composite base = this.editorToolkit.createComposite(parent, 64);
        GridLayout grid = new GridLayout(1, false);
        grid.marginTop = 20;
        grid.verticalSpacing = 7;
        base.setLayout((Layout)grid);
        base.setLayoutData((Object)new GridData(768));
        Label label = this.editorToolkit.createBoldLabel(base, Messages.WidgetPage_LicenseGroupLabel, 64);
        label.setToolTipText(Messages.WidgetPage_LicenseGroupLabel);
        GridData data = new GridData(1, 2, false, false);
        label.setLayoutData((Object)data);
        Composite licenseComposite = this.editorToolkit.createComposite(base, 2048);
        grid = new GridLayout(2, false);
        grid.marginHeight = 20;
        grid.marginWidth = 20;
        grid.horizontalSpacing = 29;
        grid.verticalSpacing = 16;
        licenseComposite.setLayout((Layout)grid);
        licenseComposite.setLayoutData((Object)new GridData(768));
        Label licenseLabel = this.editorToolkit.createLabel(licenseComposite, Messages.WidgetPage_LicenseTextLabel, 64);
        licenseLabel.setToolTipText(Messages.WidgetPage_LicenseTextTooltip);
        data = new GridData(1, 2, false, false);
        data.widthHint = 90;
        licenseLabel.setLayoutData((Object)data);
        this.licenseText = this.editorToolkit.createText(licenseComposite, "", 2048);
        this.licenseText.setLayoutData((Object)new GridData(4, 2, true, false));
        Label hrefLabel = this.editorToolkit.createLabel(licenseComposite, Messages.WidgetPage_LicenseHrefTextLabel, 64);
        hrefLabel.setToolTipText(Messages.WidgetPage_LicenseHrefTextTooltip);
        data = new GridData(1, 2, false, false);
        data.widthHint = 90;
        hrefLabel.setLayoutData((Object)data);
        this.licenseHrefText = this.editorToolkit.createText(licenseComposite, "", 2048);
        this.licenseHrefText.setLayoutData((Object)new GridData(4, 2, true, false));
    }

    protected void createDescControl(Composite parent) {
        Composite base = this.editorToolkit.createComposite(parent, 64);
        GridLayout grid = new GridLayout(1, false);
        grid.marginTop = 20;
        grid.verticalSpacing = 7;
        base.setLayout((Layout)grid);
        base.setLayoutData((Object)new GridData(768));
        Label descLabel = this.editorToolkit.createBoldLabel(base, Messages.WidgetPage_DescriptionTextLabel, 64);
        descLabel.setToolTipText(Messages.WidgetPage_DescriptionTextTooltip);
        GridData data = new GridData(1, 2, false, false);
        descLabel.setLayoutData((Object)data);
        this.descriptionText = this.editorToolkit.createText(base, "", 2562);
        data = new GridData(4, 4, true, false);
        data.heightHint = 90;
        this.descriptionText.setLayoutData((Object)data);
    }

    private void createAppUiControl(Composite parent) {
        Composite base = this.editorToolkit.createComposite(parent, 64);
        GridLayout grid = new GridLayout(1, false);
        grid.verticalSpacing = 7;
        base.setLayout((Layout)grid);
        base.setLayoutData((Object)new GridData(768));
        Label uiLabel = this.editorToolkit.createBoldLabel(base, Messages.WidgetPage_UITextLabel, 64);
        uiLabel.setToolTipText(Messages.WidgetPage_UITextTooltip);
        GridData data = new GridData(1, 2, false, false);
        uiLabel.setLayoutData((Object)data);
        Composite uiComposite = this.editorToolkit.createComposite(base, 2048);
        grid = new GridLayout(2, false);
        grid.marginHeight = 20;
        grid.marginWidth = 20;
        grid.horizontalSpacing = 29;
        grid.verticalSpacing = 20;
        uiComposite.setLayout((Layout)grid);
        uiComposite.setLayoutData((Object)new GridData(768));
        Label widthLabel = this.editorToolkit.createLabel(uiComposite, Messages.WidgetPage_WidthTextLabel, 64);
        widthLabel.setToolTipText(Messages.WidgetPage_WidthTextTooltip);
        data = new GridData(1, 2, false, false);
        data.widthHint = 90;
        widthLabel.setLayoutData((Object)data);
        Composite widthComposite = this.editorToolkit.createComposite(uiComposite, 0);
        grid = new GridLayout(4, false);
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        grid.verticalSpacing = 0;
        grid.horizontalSpacing = 0;
        widthComposite.setLayout((Layout)grid);
        widthComposite.setLayoutData((Object)new GridData(768));
        this.widthSpinner = new Spinner(widthComposite, 2048);
        this.widthSpinner.setMinimum(0);
        this.widthSpinner.setMaximum(2000);
        this.widthSpinner.setDigits(0);
        data = new GridData(1, 2, false, false);
        data.widthHint = 80;
        this.widthSpinner.setLayoutData((Object)data);
        Label dummy = new Label(widthComposite, 0);
        data = new GridData(1, 2, false, false);
        data.widthHint = 60;
        dummy.setLayoutData((Object)data);
        dummy.setVisible(false);
        Label heightLabel = this.editorToolkit.createLabel(widthComposite, Messages.WidgetPage_HeightTextLabel, 0);
        heightLabel.setToolTipText(Messages.WidgetPage_HeightTextTooltip);
        data = new GridData(1, 2, false, false);
        data.widthHint = 75;
        heightLabel.setLayoutData((Object)data);
        this.heightSpinner = new Spinner(widthComposite, 2048);
        this.heightSpinner.setMinimum(0);
        this.heightSpinner.setMaximum(2000);
        this.heightSpinner.setDigits(0);
        data = new GridData(1, 2, false, false);
        data.widthHint = 80;
        this.heightSpinner.setLayoutData((Object)data);
        Label viewModeLabel = this.editorToolkit.createLabel(uiComposite, Messages.WidgetPage_ViewmodeComboLabel, 64);
        viewModeLabel.setToolTipText(Messages.WidgetPage_ViewmodeComboTooltip);
        data = new GridData(1, 2, false, false);
        data.widthHint = 90;
        viewModeLabel.setLayoutData((Object)data);
        this.viewmodeCombo = new Combo(uiComposite, 8);
        int i = 0;
        while (i < WebConstant.VIEWMODES.length) {
            this.viewmodeCombo.add(WebConstant.VIEWMODES[i]);
            ++i;
        }
        this.viewmodeCombo.select(0);
        data = new GridData(768);
        this.viewmodeCombo.setLayoutData((Object)data);
    }

    @Override
    public void setFocus() {
        super.setFocus();
        if (this.tizenConfig != null) {
            String conent = this.contentText.getText();
            this.msgManager.removeMessage(MESSAGEKEY_CONTENT, (Control)this.contentText);
            if (!(StringUtil.isEmpty((CharSequence)conent) || ValidationUtil.checkForWidgetContentFileExtension((String)conent) && WebProjectUtil.isFileInTheProject((IProject)this.tizenConfig.getProject(), (String)conent))) {
                this.msgManager.addMessage(Messages.OverviewPage_ContentTextLabel, (Object)MESSAGEKEY_CONTENT, Messages.OverviewPage_ContentTextValidEmpty, null, 3, (Control)this.contentText);
            }
            String largetIconSrc = this.iconSrcText.getText();
            this.msgManager.removeMessage(MESSAGEKEY_ICON, (Control)this.iconSrcText);
            if (!StringUtil.isEmpty((CharSequence)largetIconSrc)) {
                if (!ValidationUtil.checkForWidgetIconFileExtension((String)largetIconSrc) || !WebProjectUtil.isFileInTheProject((IProject)this.tizenConfig.getProject(), (String)largetIconSrc)) {
                    this.msgManager.addMessage(Messages.OverviewPage_IconTextLabel, (Object)MESSAGEKEY_ICON, MessageFormat.format(Messages.IconErrorMessage, MESSAGEKEY_ICON), null, 3, (Control)this.iconSrcText);
                    this.setIconPreview(null);
                } else {
                    this.setIconPreview(largetIconSrc);
                }
            } else {
                this.setIconPreview(null);
            }
        }
    }

    @Override
    public void saveStatus(ITizenConfigurator config) {
        config.setId(this.identifierText.getText());
        config.setVersion(this.versionText.getText());
        config.setName(this.nameText.getText(), null);
        config.setContent(this.contentText.getText());
        config.setIcon(this.iconSrcText.getText());
        this.setIconPreview(this.iconSrcText.getText());
        if (Integer.parseInt(this.widthSpinner.getText()) > 0) {
            config.setWidth(this.widthSpinner.getText());
        }
        if (Integer.parseInt(this.heightSpinner.getText()) > 0) {
            config.setHeight(this.heightSpinner.getText());
        }
        config.setViewmode(this.viewmodeCombo.getText());
        config.setAuthor(this.authorText.getText(), this.authorHrefText.getText(), this.authorEmailText.getText());
        config.setLicense(this.licenseText.getText(), this.licenseHrefText.getText(), null);
        config.setDescription(this.descriptionText.getText(), null);
        if (StringUtil.isEmpty((CharSequence)this.licenseText.getText())) {
            this.removeListener();
            this.licenseHrefText.setText("");
            this.msgManager.removeMessage(MESSAGEKEY_LICENSEHREF, (Control)this.licenseHrefText);
            this.addListener();
        }
    }

    @Override
    public void loadStatus(ITizenConfigurator config) {
        String description;
        String licenceURL;
        String license;
        String webSite;
        String email;
        String viewmode;
        String height;
        String name;
        String version;
        this.tizenConfig = config;
        this.removeListener();
        this.identifierText.setText("");
        this.versionText.setText("");
        this.nameText.setText("");
        this.contentText.setText("");
        this.iconSrcText.setText("");
        this.widthSpinner.setSelection(0);
        this.heightSpinner.setSelection(0);
        this.viewmodeCombo.clearSelection();
        String identifier = config.getId();
        this.validateID(identifier);
        if (!StringUtil.isEmpty((CharSequence)identifier)) {
            this.identifierText.setText(identifier);
        }
        if ((version = config.getVersion()) != null) {
            this.versionText.setText(version);
            this.validateVersion(version);
        }
        if ((name = config.getName(null)) != null) {
            this.nameText.setText(name);
        }
        String conent = config.getContentSrc();
        this.msgManager.removeMessage(MESSAGEKEY_CONTENT, (Control)this.contentText);
        if (!StringUtil.isEmpty((CharSequence)conent)) {
            this.contentText.setText(conent);
            if (!ValidationUtil.checkForWidgetContentFileExtension((String)conent) || !WebProjectUtil.isFileInTheProject((IProject)this.tizenConfig.getProject(), (String)conent)) {
                this.msgManager.addMessage(Messages.OverviewPage_ContentTextLabel, (Object)MESSAGEKEY_CONTENT, Messages.OverviewPage_ContentTextValidEmpty, null, 3, (Control)this.contentText);
            }
        } else {
            String profileName;
            TizenProjectDescription tizenDesc = ProjectUtil.getTizenProjectDescription((IProject)config.getProject());
            if (tizenDesc != null && (profileName = tizenDesc.getProfileName()) != null && profileName.equalsIgnoreCase("mobile") && !WebProjectUtil.isFileInTheProject((IProject)config.getProject(), (String)"index.html") && StringUtil.isEmpty((CharSequence)((IMobileConfigurator)config).getTizenContentSrc())) {
                this.msgManager.addMessage(Messages.OverviewPage_ContentTextLabel, (Object)MESSAGEKEY_CONTENT, Messages.Validator_InvalidContentElement, null, 3, (Control)this.contentText);
            }
        }
        String largetIconSrc = config.getIconSrc();
        this.msgManager.removeMessage(MESSAGEKEY_ICON, (Control)this.iconSrcText);
        if (!StringUtil.isEmpty((CharSequence)largetIconSrc)) {
            this.iconSrcText.setText(largetIconSrc);
            if (!ValidationUtil.checkForWidgetIconFileExtension((String)largetIconSrc) || !WebProjectUtil.isFileInTheProject((IProject)this.tizenConfig.getProject(), (String)largetIconSrc)) {
                this.msgManager.addMessage(Messages.OverviewPage_IconTextLabel, (Object)MESSAGEKEY_ICON, MessageFormat.format(Messages.IconErrorMessage, MESSAGEKEY_ICON), null, 3, (Control)this.iconSrcText);
                this.setIconPreview(null);
            } else {
                this.setIconPreview(largetIconSrc);
            }
        } else {
            this.setIconPreview(null);
        }
        String width = this.tizenConfig.getWidth();
        if (width != null) {
            try {
                this.widthSpinner.setSelection(Integer.valueOf(width).intValue());
            }
            catch (NumberFormatException numberFormatException) {
                this.widthSpinner.setSelection(0);
            }
        }
        if ((height = this.tizenConfig.getHeight()) != null) {
            try {
                this.heightSpinner.setSelection(Integer.valueOf(height).intValue());
            }
            catch (NumberFormatException numberFormatException) {
                this.heightSpinner.setSelection(0);
            }
        }
        if ((viewmode = this.tizenConfig.getViewmode()) != null) {
            this.viewmodeCombo.setText(viewmode);
            this.tizenConfig.setViewmode(viewmode);
        }
        this.authorText.setText("");
        this.authorEmailText.setText("");
        this.authorHrefText.setText("");
        this.licenseText.setText("");
        this.licenseHrefText.setText("");
        this.descriptionText.setText("");
        String author = this.tizenConfig.getAuthorContent();
        if (author != null) {
            this.authorText.setText(author);
        }
        if ((email = this.tizenConfig.getAuthorEmail()) != null) {
            this.authorEmailText.setText(email);
        }
        if ((webSite = this.tizenConfig.getAuthorHref()) != null) {
            this.authorHrefText.setText(webSite);
        }
        if ((license = this.tizenConfig.getLicenseContent(null)) != null) {
            this.licenseText.setText(license);
        }
        if ((licenceURL = this.tizenConfig.getLicenseHref(null)) != null) {
            this.licenseHrefText.setText(licenceURL);
        }
        if ((description = this.tizenConfig.getDescription(null)) != null) {
            this.descriptionText.setText(description);
        }
        this.addListener();
    }

    public void setIconPreview(String iconName) {
        try {
            if (!StringUtil.isEmpty((CharSequence)iconName)) {
                SWTUtil.tryDispose((Resource[])new Resource[]{this.currentIcon});
                BufferedImage bimage = ImageUtil.getAWTImage((String)(String.valueOf(this.tizenConfig.getProject().getLocationURI().getPath()) + "/" + iconName), (boolean)false);
                this.currentIcon = ImageUtil.convertImageToSWT((Display)this.iconPreview.getDisplay(), (BufferedImage)ImageUtil.getScaledImage((BufferedImage)bimage, (int)90, (int)90));
                if (this.currentIcon != null) {
                    this.iconPreview.setImage(this.currentIcon);
                    return;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.iconPreview.setImage(this.emptyIcon);
        }
        catch (SWTException sWTException) {
            this.iconPreview.setImage(this.emptyIcon);
        }
        catch (SWTError sWTError) {
            this.iconPreview.setImage(this.emptyIcon);
        }
        this.iconPreview.setImage(this.emptyIcon);
    }

    @Override
    public void addListener() {
        this.createListener();
        if (this.idModifyListener != null) {
            this.identifierText.addModifyListener(this.idModifyListener);
        }
        if (this.versionModifyListener != null) {
            this.versionText.addModifyListener(this.versionModifyListener);
        }
        if (this.nameModifyListener != null) {
            this.nameText.addModifyListener(this.nameModifyListener);
        }
        if (this.contentModifyListener != null) {
            this.contentText.addModifyListener(this.contentModifyListener);
        }
        if (this.iconModifyListener != null) {
            this.iconSrcText.addModifyListener(this.iconModifyListener);
        }
        if (this.authorEmailModifyListener != null) {
            this.authorEmailText.addModifyListener(this.authorEmailModifyListener);
        }
        if (this.authorHrefModifyListener != null) {
            this.authorHrefText.addModifyListener(this.authorHrefModifyListener);
        }
        if (this.licenseHrefModifyListener != null) {
            this.licenseHrefText.addModifyListener(this.licenseHrefModifyListener);
        }
        if (this.modifyListener != null) {
            this.widthSpinner.addModifyListener(this.modifyListener);
            this.heightSpinner.addModifyListener(this.modifyListener);
            this.authorText.addModifyListener(this.modifyListener);
            this.licenseText.addModifyListener(this.modifyListener);
            this.descriptionText.addModifyListener(this.modifyListener);
        }
        if (this.selectionListener != null) {
            this.viewmodeCombo.addSelectionListener(this.selectionListener);
        }
    }

    @Override
    public void removeListener() {
        if (this.idModifyListener != null) {
            this.identifierText.removeModifyListener(this.idModifyListener);
        }
        if (this.versionModifyListener != null) {
            this.versionText.removeModifyListener(this.versionModifyListener);
        }
        if (this.nameModifyListener != null) {
            this.nameText.removeModifyListener(this.nameModifyListener);
        }
        if (this.contentModifyListener != null) {
            this.contentText.removeModifyListener(this.contentModifyListener);
        }
        if (this.iconModifyListener != null) {
            this.iconSrcText.removeModifyListener(this.iconModifyListener);
        }
        if (this.authorEmailText != null) {
            this.authorEmailText.removeModifyListener(this.authorEmailModifyListener);
        }
        if (this.authorHrefText != null) {
            this.authorHrefText.removeModifyListener(this.authorHrefModifyListener);
        }
        if (this.licenseHrefText != null) {
            this.licenseHrefText.removeModifyListener(this.licenseHrefModifyListener);
        }
        if (this.modifyListener != null) {
            this.widthSpinner.removeModifyListener(this.modifyListener);
            this.heightSpinner.removeModifyListener(this.modifyListener);
            this.authorText.removeModifyListener(this.modifyListener);
            this.licenseText.removeModifyListener(this.modifyListener);
            this.descriptionText.removeModifyListener(this.modifyListener);
        }
        if (this.selectionListener != null) {
            this.viewmodeCombo.removeSelectionListener(this.selectionListener);
        }
    }

    @Override
    public void createListener() {
        if (this.idModifyListener == null) {
            this.idModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    OverviewPage.this.markDirty();
                    OverviewPage.this.validateID(OverviewPage.this.identifierText.getText().trim());
                }
            };
        }
        if (this.versionModifyListener == null) {
            this.versionModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    OverviewPage.this.markDirty();
                    OverviewPage.this.validateVersion(OverviewPage.this.versionText.getText());
                }
            };
        }
        if (this.nameModifyListener == null) {
            this.nameModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    OverviewPage.this.markDirty();
                }
            };
        }
        if (this.contentModifyListener == null) {
            this.contentModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    OverviewPage.this.markDirty();
                    String content = OverviewPage.this.contentText.getText().trim();
                    OverviewPage.this.msgManager.removeMessage(OverviewPage.MESSAGEKEY_CONTENT, (Control)OverviewPage.this.contentText);
                    if (!"".equals(content)) {
                        if (!ValidationUtil.checkForWidgetContentFileExtension((String)content) || !WebProjectUtil.isFileInTheProject((IProject)OverviewPage.this.tizenConfig.getProject(), (String)content)) {
                            OverviewPage.this.msgManager.addMessage(Messages.OverviewPage_ContentTextLabel, (Object)OverviewPage.MESSAGEKEY_CONTENT, Messages.OverviewPage_ContentTextValidEmpty, null, 3, (Control)OverviewPage.this.contentText);
                        }
                    } else {
                        String profileName;
                        TizenProjectDescription tizenDesc = ProjectUtil.getTizenProjectDescription((IProject)OverviewPage.this.tizenConfig.getProject());
                        if (tizenDesc != null && (profileName = tizenDesc.getProfileName()) != null && profileName.equalsIgnoreCase("mobile") && !WebProjectUtil.isFileInTheProject((IProject)OverviewPage.this.tizenConfig.getProject(), (String)"index.html") && StringUtil.isEmpty((CharSequence)((IMobileConfigurator)OverviewPage.this.tizenConfig).getTizenContentSrc())) {
                            OverviewPage.this.msgManager.addMessage(Messages.OverviewPage_ContentTextLabel, (Object)OverviewPage.MESSAGEKEY_CONTENT, Messages.Validator_InvalidContentElement, null, 3, (Control)OverviewPage.this.contentText);
                        }
                    }
                }
            };
        }
        if (this.iconModifyListener == null) {
            this.iconModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    OverviewPage.this.markDirty();
                    String icon = OverviewPage.this.iconSrcText.getText();
                    OverviewPage.this.msgManager.removeMessage(OverviewPage.MESSAGEKEY_ICON, (Control)OverviewPage.this.iconSrcText);
                    if (!("".equals(icon) || ValidationUtil.checkForWidgetIconFileExtension((String)icon) && WebProjectUtil.isFileInTheProject((IProject)OverviewPage.this.tizenConfig.getProject(), (String)icon))) {
                        OverviewPage.this.msgManager.addMessage(Messages.OverviewPage_IconTextLabel, (Object)OverviewPage.MESSAGEKEY_ICON, MessageFormat.format(Messages.IconErrorMessage, OverviewPage.MESSAGEKEY_ICON), null, 3, (Control)OverviewPage.this.iconSrcText);
                    }
                }
            };
        }
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    OverviewPage.this.markDirty();
                }
            };
        }
        if (this.selectionListener == null) {
            this.selectionListener = new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    this.widgetDefaultSelected(e);
                    OverviewPage.this.markDirty();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            };
        }
        if (this.authorEmailModifyListener == null) {
            this.authorEmailModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    OverviewPage.this.markDirty();
                    String authorEmail = OverviewPage.this.authorEmailText.getText().trim();
                    if (!authorEmail.isEmpty() && !ValidationUtil.checkForEmail((String)authorEmail)) {
                        OverviewPage.this.msgManager.addMessage(Messages.WidgetPage_AuthorEmailTextLabel, (Object)OverviewPage.MESSAGEKEY_AUTHOREMAIL, Messages.Invalid_Email, null, 2, (Control)OverviewPage.this.authorEmailText);
                    } else {
                        OverviewPage.this.msgManager.removeMessage(OverviewPage.MESSAGEKEY_AUTHOREMAIL, (Control)OverviewPage.this.authorEmailText);
                    }
                }
            };
        }
        if (this.authorHrefModifyListener == null) {
            this.authorHrefModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    OverviewPage.this.markDirty();
                    String authorHref = OverviewPage.this.authorHrefText.getText().trim();
                    if (!authorHref.isEmpty() && !ValidationUtil.checkForURL((String)authorHref)) {
                        OverviewPage.this.msgManager.addMessage(Messages.WidgetPage_AuthorHrefTextLabel, (Object)OverviewPage.MESSAGEKEY_AUTHORHREF, Messages.Validator_MalformedURL, null, 2, (Control)OverviewPage.this.authorHrefText);
                    } else {
                        OverviewPage.this.msgManager.removeMessage(OverviewPage.MESSAGEKEY_AUTHORHREF, (Control)OverviewPage.this.authorHrefText);
                    }
                }
            };
        }
        if (this.licenseHrefModifyListener == null) {
            this.licenseHrefModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    OverviewPage.this.markDirty();
                    String licenseHref = OverviewPage.this.licenseHrefText.getText().trim();
                    if (!licenseHref.isEmpty() && !ValidationUtil.checkForURL((String)licenseHref)) {
                        OverviewPage.this.msgManager.addMessage(Messages.WidgetPage_LicenseHrefTextLabel, (Object)OverviewPage.MESSAGEKEY_LICENSEHREF, Messages.Validator_MalformedURL, null, 2, (Control)OverviewPage.this.licenseHrefText);
                    } else {
                        OverviewPage.this.msgManager.removeMessage(OverviewPage.MESSAGEKEY_LICENSEHREF, (Control)OverviewPage.this.licenseHrefText);
                    }
                }
            };
        }
    }

    @Override
    public void dispose() {
        SWTUtil.tryDispose((Resource[])new Resource[]{this.emptyIcon});
        SWTUtil.tryDispose((Resource[])new Resource[]{this.currentIcon});
        super.dispose();
    }

    private void validateID(String id) {
        if (!StringUtil.isEmpty((CharSequence)id) && !ValidationUtil.checkForIRI((String)id)) {
            this.msgManager.addMessage(Messages.OverviewPage_IdTextLabel, (Object)MESSAGEKEY_ID, Messages.Validator_MalformedIRI, null, 2, (Control)this.identifierText);
        } else {
            this.msgManager.removeMessage(MESSAGEKEY_ID, (Control)this.identifierText);
        }
    }

    private void validateVersion(String version) {
        if (!StringUtil.isEmpty((CharSequence)version) && !ValidationUtil.checkForVersion((String)version)) {
            this.msgManager.addMessage(Messages.OverviewPage_VersionTextLabel, (Object)MESSAGEKEY_VERSION, Messages.Validator_InvalidVersionAttribute, null, 3, (Control)this.versionText);
        } else {
            this.msgManager.removeMessage(MESSAGEKEY_VERSION, (Control)this.versionText);
        }
    }
}

