/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.zimlaunch.cli.command;

import java.text.MessageFormat;
import org.tizen.common.core.command.ExecutionContext;
import org.tizen.common.core.command.Executor;
import org.tizen.common.util.StringUtil;
import org.tizen.web.zimlaunch.cli.command.QueryCommand;

public class WgtInfoCommand
extends QueryCommand {
    private int nName = 1;
    private int nVersion = 2;
    private int nGuid = 3;
    private int nPackageId = 4;
    private int nAppId = 5;
    private static final String NAME = "Name";
    private static final String VERSION = "Version";
    private static final String GUID = "GUID";
    private static final String PACKAGE_ID = "Package ID";
    private static final String APP_ID = "App ID";
    protected String uniqueID;
    protected String packageName;
    private String appId;
    private String guid;
    private String packageId;
    private String version;

    String getUniqueID() {
        return this.uniqueID;
    }

    public String getVersion() {
        return this.version;
    }

    private void setVersion(String version) {
        this.version = version;
    }

    public String getPackageName() {
        return this.packageName;
    }

    void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public WgtInfoCommand(String uniqueID) {
        this.uniqueID = uniqueID;
    }

    @Override
    public void run(Executor executor, ExecutionContext context) throws Exception {
        boolean op = this.isPrintOption();
        this.setPrintOption(false);
        super.run(executor, context);
        this.setPrintOption(op);
        String delim = System.getProperty("line.separator");
        String subdelim = "\\s{2,}";
        String[] lines = StringUtil.split((String)this.getResult(), (String)delim);
        String[] columns = lines[0].split(subdelim);
        this.setAppInfoColumn(columns);
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] appInfos;
            String line = stringArray[n2];
            String[] stringArray2 = appInfos = line.split(subdelim);
            int n3 = appInfos.length;
            int n4 = 0;
            while (n4 < n3) {
                String appInfo = stringArray2[n4];
                if (this.getUniqueID().equals(appInfo)) {
                    this.setPackageName(appInfos[this.nName]);
                    this.setAppId(appInfos[this.nAppId]);
                    this.setPackageId(appInfos[this.nPackageId]);
                    this.setGuid(appInfos[this.nGuid]);
                    this.setVersion(appInfos[this.nVersion]);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        if (this.isPrintOption()) {
            context.getPrompter().notify(MessageFormat.format("''{0}'' package name: {1}", this.getUniqueID(), this.getPackageName()));
        }
    }

    public String getAppId() {
        return this.appId;
    }

    public String getGuid() {
        return this.guid;
    }

    public String getPackageId() {
        return this.packageId;
    }

    private void setPackageId(String packageId) {
        this.packageId = packageId;
    }

    private void setGuid(String guid) {
        this.guid = guid;
    }

    private void setAppId(String appId) {
        this.appId = appId;
    }

    private void setAppInfoColumn(String[] columnNames) {
        int nColumn = 0;
        while (nColumn < columnNames.length) {
            if (columnNames[nColumn].equals(NAME)) {
                this.nName = nColumn;
            } else if (columnNames[nColumn].equals(VERSION)) {
                this.nVersion = nColumn;
            } else if (columnNames[nColumn].equals(GUID)) {
                this.nGuid = nColumn;
            } else if (columnNames[nColumn].equals(PACKAGE_ID)) {
                this.nPackageId = nColumn;
            } else if (columnNames[nColumn].equals(APP_ID)) {
                this.nAppId = nColumn;
            }
            ++nColumn;
        }
    }
}

