/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.initializer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.LibrarySuperType;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathsBlock;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipselabs.jsdt.jquery.api.JQueryApiPlugin;
import org.eclipselabs.jsdt.jquery.api.SimpleVersion;
import org.eclipselabs.jsdt.jquery.api.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenProjectType;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.ProfileInfo;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.PluginUtil;
import org.tizen.common.util.ProjectUtil;
import org.tizen.web.project.initializer.JQueryCAPluginAdapter;
import org.tizen.web.project.initializer.WebLibraryInitializer;

public class ProjectJSScopeUtility {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String SUPER_TYPE_NAME = "Window";
    private static final String SUPER_TYPE_LIBRARY = "org.eclipse.wst.jsdt.launching.baseBrowserLibrary";
    private static final String JSDT_CODE_ASSIST_EXTENSION_POINT_ID = "org.eclipse.wst.jsdt.core.JsGlobalScopeContainerInitializer";
    private static final String JSDT_CODE_ASSIST_EXTENSION_ID_PREFIX = "org.tizen.web.project.initializer.ext";
    private final String[] CONTAINER_IDS = new String[]{"org.tizen.web.project.initializer.WebLibraryInitializer", "org.tizen.web.project.initializer.W3CLibraryInitializer", "org.tizen.web.project.initializer.HTML5LibraryInitializer", "org.tizen.web.project.initializer.TizenLibraryInitializer", "org.tizen.web.project.initializer.ExtraTizenLibraryInitializer"};
    private final Pattern jQueryVersionPattern = Pattern.compile("^(\\d+\\.\\d+).*");

    private String getJqueryVersion(String version) {
        Matcher matcher;
        if (version != null && (matcher = this.jQueryVersionPattern.matcher(version)).matches() && matcher.groupCount() == 1) {
            String canonicalizedVersion = matcher.group(1);
            try {
                Version ver;
                if (SimpleVersion.isVersionString((String)canonicalizedVersion) && (ver = SimpleVersion.fromString((String)canonicalizedVersion)).compareTo((Object)JQueryApiPlugin.MAX_VERSION) <= 0) {
                    this.logger.trace("Supported jQuery version: {}", (Object)canonicalizedVersion);
                    return canonicalizedVersion;
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            this.logger.trace("Not supported jQuery version: {}", (Object)canonicalizedVersion);
        }
        this.logger.trace("Use a default jQuery version for content assist: {}", (Object)JQueryApiPlugin.MAX_VERSION.toString());
        return JQueryApiPlugin.MAX_VERSION.toString();
    }

    private void addCPListElement(IJavaScriptProject javaScriptProject, List<CPListElement> cpList, String pathString) {
        this.addCPListElement(javaScriptProject, cpList, (IPath)new Path(pathString));
    }

    private void addCPListElement(IJavaScriptProject javaScriptProject, List<CPListElement> cpList, IPath containerPath) {
        IIncludePathEntry libraryEntry = JavaScriptCore.newContainerEntry((IPath)containerPath);
        CPListElement libraryElement = CPListElement.createFromExisting((IIncludePathEntry)libraryEntry, (IJavaScriptProject)javaScriptProject);
        cpList.add(libraryElement);
    }

    public void addGlobalScope(IProject project) {
        this.addGlobalScopeByJqueryVersion(project, null, false);
    }

    public void addGlobalScopeByJqueryVersion(IProject project, String version, boolean noConflict) {
        if (version == null) {
            noConflict = false;
        }
        version = this.getJqueryVersion(version);
        IJavaScriptProject javaScriptProject = JavaScriptCore.create((IProject)project);
        try {
            IIncludePathEntry[] entries = javaScriptProject.getRawIncludepath();
            IPath jQueryLibrary_ID = JQueryCAPluginAdapter.createJqueryIncludePath(version, noConflict);
            ArrayList<String> containerList = new ArrayList<String>(Arrays.asList(this.CONTAINER_IDS));
            containerList.add(jQueryLibrary_ID.toString());
            ArrayList<CPListElement> cpList = new ArrayList<CPListElement>();
            int i = entries.length - 1;
            while (i >= 0) {
                boolean existLibrary = false;
                for (String comparableTarget : containerList) {
                    IPath entryPath = entries[i].getPath();
                    if (entryPath.toOSString().compareTo(comparableTarget) != 0 && !entryPath.toOSString().contains(JSDT_CODE_ASSIST_EXTENSION_ID_PREFIX)) continue;
                    existLibrary = true;
                    break;
                }
                if (!existLibrary) {
                    CPListElement cpElement = CPListElement.createFromExisting((IIncludePathEntry)entries[i], (IJavaScriptProject)javaScriptProject);
                    cpList.add(cpElement);
                }
                --i;
            }
            this.addJsLibraries(javaScriptProject, cpList, jQueryLibrary_ID);
            try {
                Object[] extensions;
                Object[] objectArray = extensions = PluginUtil.getExtensionAttribute((String)JSDT_CODE_ASSIST_EXTENSION_POINT_ID, (String)"id");
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    Object extension = objectArray[n2];
                    String extensionID = (String)extension;
                    if (extensionID.contains(JSDT_CODE_ASSIST_EXTENSION_ID_PREFIX)) {
                        this.addCPListElement(javaScriptProject, cpList, extensionID);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            LibrarySuperType superType = new LibrarySuperType(SUPER_TYPE_LIBRARY, javaScriptProject, SUPER_TYPE_NAME);
            try {
                BuildPathsBlock.flush(cpList, (IJavaScriptProject)javaScriptProject, (LibrarySuperType)superType, (IProgressMonitor)new NullProgressMonitor());
                javaScriptProject.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (OperationCanceledException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            catch (CoreException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        catch (JavaScriptModelException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private void addJsLibraries(IJavaScriptProject javaScriptProject, List<CPListElement> cpList, IPath jQueryLibrary_ID) {
        ProfileInfo profileInfo;
        IProject project = javaScriptProject.getProject();
        TizenProjectType projectType = ProjectUtil.getTizenProjectType((IProject)project);
        if (TizenProjectType.TIZEN_WEB_WIDGET_APPLICATION == projectType) {
            this.addCPListElement(javaScriptProject, cpList, "org.tizen.web.project.initializer.WebWidgetECMA3LibraryInitializer");
            this.addCPListElement(javaScriptProject, cpList, "org.tizen.web.project.initializer.WebWidgetTizenLibraryInitializer");
        } else {
            this.addCPListElement(javaScriptProject, cpList, "org.tizen.web.project.initializer.WebLibraryInitializer");
            this.addCPListElement(javaScriptProject, cpList, jQueryLibrary_ID);
            this.addCPListElement(javaScriptProject, cpList, "org.tizen.web.project.initializer.TizenLibraryInitializer");
            this.addCPListElement(javaScriptProject, cpList, "org.tizen.web.project.initializer.HTML5LibraryInitializer");
            this.addCPListElement(javaScriptProject, cpList, "org.tizen.web.project.initializer.W3CLibraryInitializer");
        }
        TizenProjectDescription tProject = ProjectUtil.getTizenProjectDescription((IProject)project);
        if (tProject != null && (profileInfo = InstallPathConfig.getProfileInfo((String)tProject.getProfileName())) != null && profileInfo.isProduct()) {
            this.addCPListElement(javaScriptProject, cpList, "org.tizen.web.project.initializer.ExtraTizenLibraryInitializer");
        }
    }

    public void refreshGlobalScope(IProject project, WebLibraryInitializer initializer, IPath path) {
        IJavaScriptProject create = JavaScriptCore.create((IProject)project);
        try {
            project.touch((IProgressMonitor)new NullProgressMonitor());
            initializer.initialize(path, create);
        }
        catch (JavaScriptModelException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

