/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.common.util;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.tizen.common.core.application.PackageResourceInfo;
import org.tizen.common.util.FileUtil;
import org.tizen.web.common.WebCommonActivator;

public class PackageUtil
extends org.tizen.common.util.PackageUtil {
    public static String getPackagePath(IProject project) {
        return String.valueOf(project.getLocation().toOSString()) + File.separator + PackageUtil.getPackageName(project);
    }

    public static String getPackageName(IProject project) {
        return String.valueOf(project.getName()) + "." + "wgt";
    }

    public static boolean excludeUiFramework(IProject project) {
        return false;
    }

    public static PackageResourceInfo getPackageResourceInfo(String name, int resourceType, List<PackageResourceInfo> list) {
        for (PackageResourceInfo pri : list) {
            if (!pri.getName().equals(name) || pri.getResourceType() != resourceType) continue;
            return pri;
        }
        return null;
    }

    public static boolean contains(PackageResourceInfo res, List<PackageResourceInfo> list) {
        for (PackageResourceInfo pri : list) {
            if (!pri.getName().equals(res.getName()) || pri.getResourceType() != res.getResourceType()) continue;
            return true;
        }
        return false;
    }

    public static String getSignPath(IProject project) {
        return FileUtil.appendPath((String)project.getLocation().toString(), (String)".sign");
    }

    public static String getCompanionAppDestPath() {
        return "res";
    }

    public static boolean needToOptimize(IProject project) throws CoreException {
        String value = project.getPersistentProperty(WebCommonActivator.optimizeResourcesQName);
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }
}

