/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.tizen.common.util.IOUtil;
import org.tizen.web.apptemplate.model.CategoryType;
import org.tizen.web.apptemplate.model.ObjectFactory;
import org.tizen.web.apptemplate.model.TizenAppTemplateType;
import org.tizen.web.apptemplate.model.TizenTemplateConfigType;
import org.tizen.web.apptemplate.model.TizenTemplateLibraries;
import org.tizen.web.model.ITizenTemplateLibraries;
import org.tizen.web.model.TizenAppTemplate;
import org.tizen.web.model.TizenTemplateConfig;
import org.tizen.web.model.impl.TizenAppTemplateImpl;
import org.tizen.web.model.impl.TizenTemplateConfigImpl;
import org.tizen.web.model.impl.TizenTemplateLibrariesImpl;

public class TizenModelFactory {
    public static final String AppTemplateSchemeLocation = "http://www.tizen.org/tizen-app-template tizen-app-template.xsd ";
    static ObjectFactory objFactory = new ObjectFactory();
    static JAXBContext jaxbContext = null;

    private TizenModelFactory() {
    }

    public static JAXBElement<TizenTemplateConfigType> getTemplateConfigRoot(TizenTemplateConfigType value) {
        return objFactory.createTizenTemplateConfig(value);
    }

    public static TizenTemplateConfigType getTemplateConfig() {
        return objFactory.createTizenTemplateConfigType();
    }

    public static CategoryType getTemplateCategory() {
        return objFactory.createCategoryType();
    }

    public static CategoryType getTemplateCategory(int id, String name) {
        CategoryType category = objFactory.createCategoryType();
        category.setId(id);
        category.setName(name);
        return category;
    }

    public static TizenAppTemplateType getAppTemplate() {
        return objFactory.createTizenAppTemplateType();
    }

    public static JAXBElement<TizenAppTemplateType> getAppTemplateRoot(TizenAppTemplateType appTemplateType) {
        return objFactory.createTizenAppTemplate(appTemplateType);
    }

    public static TizenTemplateConfig unmarshalTemplateConfig(String configFilePath) throws FileNotFoundException {
        if (null == configFilePath) {
            return null;
        }
        File configFile = new File(configFilePath);
        return TizenModelFactory.unmarshalTemplateConfig(configFile);
    }

    public static TizenTemplateConfig unmarshalTemplateConfig(File configFile) throws FileNotFoundException {
        if (null == configFile) {
            return null;
        }
        TizenTemplateConfigImpl templateConfig = null;
        try {
            Object configModel = TizenModelFactory.unmarshalObject(configFile);
            templateConfig = new TizenTemplateConfigImpl((JAXBElement<TizenTemplateConfigType>)((JAXBElement)configModel));
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return templateConfig;
    }

    public static TizenAppTemplate unmarshalAppTemplate(String appTemplatePath) throws FileNotFoundException {
        if (null == appTemplatePath) {
            return null;
        }
        File appTemplateFile = new File(appTemplatePath);
        return TizenModelFactory.unmarshalAppTemplate(appTemplateFile);
    }

    public static TizenAppTemplate unmarshalAppTemplate(File appTemplateFile) throws FileNotFoundException {
        if (null == appTemplateFile) {
            return null;
        }
        TizenAppTemplateImpl appTemplate = null;
        try {
            Object configModel = TizenModelFactory.unmarshalObject(appTemplateFile);
            appTemplate = new TizenAppTemplateImpl((JAXBElement<TizenAppTemplateType>)((JAXBElement)configModel));
            appTemplate.setTemplateRoot(appTemplateFile.getParent());
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return appTemplate;
    }

    public static TizenAppTemplate unmarshalAppTemplate(InputStream inputStream) throws FileNotFoundException {
        if (null == inputStream) {
            return null;
        }
        TizenAppTemplateImpl appTemplate = null;
        try {
            Object configModel = TizenModelFactory.unmarshalObject(inputStream);
            appTemplate = new TizenAppTemplateImpl((JAXBElement<TizenAppTemplateType>)((JAXBElement)configModel));
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return appTemplate;
    }

    public static boolean marshalAppTemplate(TizenAppTemplateType appTemplateType, File appTemplateFile) {
        if (null == appTemplateType) {
            return false;
        }
        JAXBElement<TizenAppTemplateType> appTemplateModel = TizenModelFactory.getAppTemplateRoot(appTemplateType);
        TizenModelFactory.marshalAppTemplate(appTemplateModel, appTemplateFile);
        return true;
    }

    public static boolean marshalAppTemplate(JAXBElement<TizenAppTemplateType> appTemplateType, File appTemplateFile) {
        if (null == appTemplateType || null == appTemplateFile) {
            return false;
        }
        try {
            JAXBContext jaxbContextForAppTemplate = JAXBContext.newInstance((Class[])new Class[]{TizenAppTemplateType.class});
            Marshaller marshaller = jaxbContextForAppTemplate.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.schemaLocation", (Object)AppTemplateSchemeLocation);
            marshaller.marshal(appTemplateType, appTemplateFile);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static ITizenTemplateLibraries unmarshalTemplateLibraries(String librariesPath) throws FileNotFoundException {
        if (null == librariesPath) {
            return null;
        }
        File librariesFile = new File(librariesPath);
        return TizenModelFactory.unmarshalTemplateLibraries(librariesFile);
    }

    public static ITizenTemplateLibraries unmarshalTemplateLibraries(File librariesFile) throws FileNotFoundException {
        if (null == librariesFile) {
            return null;
        }
        TizenTemplateLibrariesImpl libraries = null;
        try {
            Object model = TizenModelFactory.unmarshalObject(librariesFile);
            libraries = new TizenTemplateLibrariesImpl((JAXBElement<TizenTemplateLibraries>)((JAXBElement)model));
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return libraries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object unmarshalObject(File sourceFile) throws FileNotFoundException, JAXBException {
        Object object;
        if (null == sourceFile) {
            return null;
        }
        if (!sourceFile.exists()) {
            throw new FileNotFoundException("File does not exist. Check the file path.\n" + sourceFile.getAbsolutePath());
        }
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        FileInputStream is = null;
        try {
            is = new FileInputStream(sourceFile);
            object = unmarshaller.unmarshal((InputStream)is);
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{is});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{is});
        return object;
    }

    private static Object unmarshalObject(InputStream inputStream) throws JAXBException {
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        return unmarshaller.unmarshal(inputStream);
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }
}

