/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sbilib.model.plugin;

import java.util.ArrayList;
import java.util.List;
import org.tizen.sbilib.model.plugin.Plugin;
import org.tizen.sbilib.model.plugin.PluginEnvironmentVariable;
import org.tizen.sbilib.model.plugin.PluginManager;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ActionScript {
    public static String ACTION_SCRIPT_ATTRIBUTE_COMMANDER = "script";
    public static String ACTION_SCRIPT_ATTRIBUTE_TYPE = "type";
    public static String ACTION_SCRIPT_ATTRIBUTE_VALUE = "value";
    public static String ACTION_SCRIPT_ELEMENT_INPUT = "input";
    public static String ACTION_SCRIPT_ELEMENT_SCRIPT = "script";
    private static String TAG_SEPERATOR = ":";
    private Element element = null;
    private ArrayList<String> argList = new ArrayList();

    public ActionScript(Element e) {
        this.element = e;
    }

    public String getCommander() {
        String commander = this.element.getAttribute(ACTION_SCRIPT_ATTRIBUTE_COMMANDER);
        return commander;
    }

    public ArrayList<String> getArguments() {
        NodeList nList = this.element.getElementsByTagName(ACTION_SCRIPT_ELEMENT_INPUT);
        for (int i = 0; i < nList.getLength(); ++i) {
            Element e = (Element)nList.item(i);
            String type = e.getAttribute(ACTION_SCRIPT_ATTRIBUTE_TYPE);
            String value = e.getAttribute(ACTION_SCRIPT_ATTRIBUTE_VALUE);
            String argument = null;
            argument = type.equalsIgnoreCase(InputType.TAG.toString()) ? this.getArgumentFromTag(value) : (type.equalsIgnoreCase(InputType.VARIABLE.toString()) ? this.getArgumentFromVariable(value) : value);
            this.argList.add(argument);
        }
        return this.argList;
    }

    public List<String> getScriptList() {
        ArrayList<String> scriptList = new ArrayList<String>();
        NodeList nList = this.element.getElementsByTagName(ACTION_SCRIPT_ELEMENT_SCRIPT);
        for (int i = 0; i < nList.getLength(); ++i) {
            Element e = (Element)nList.item(i);
            scriptList.add(e.getTextContent());
        }
        return scriptList;
    }

    private String getArgumentFromTag(String value) {
        String tagValue = PluginEnvironmentVariable.changeEnvVarToValue(value);
        if (tagValue == null) {
            return "";
        }
        String[] tagPath = tagValue.split(TAG_SEPERATOR);
        Plugin p = PluginManager.getInstance().getPlugin(tagPath[0]);
        if (p == null) {
            return "";
        }
        NodeList nList = p.getElementsByTagName(tagPath[1]);
        if (nList == null) {
            return "";
        }
        Element tagElement = null;
        for (int i = 0; i < nList.getLength(); ++i) {
            Element e = (Element)nList.item(i);
            if (!e.getAttribute(tagPath[2]).equals(tagPath[3])) continue;
            tagElement = e;
            break;
        }
        if (tagElement == null) {
            return "";
        }
        String argument = tagElement.getAttribute(tagPath[4]);
        return argument;
    }

    private String getArgumentFromVariable(String value) {
        String argument = PluginEnvironmentVariable.getValue(value);
        return argument;
    }

    private static enum InputType {
        TAG("tag"),
        VARIABLE("variable");

        String type = null;

        private InputType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

