/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.compressor.minifier.core;

import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.web.compressor.minifier.core.JavaScriptEvaluatorException;

public class JavaScriptErrorReporter
implements ErrorReporter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
        if (line < 0) {
            this.logger.error(message);
        } else {
            String logMessage = String.valueOf(sourceName) + " : " + line + " : " + lineOffset + " : " + message;
            this.logger.error(logMessage);
        }
        throw new JavaScriptEvaluatorException(message, sourceName, line, lineSource, lineOffset);
    }

    public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
        EvaluatorException exception = null;
        try {
            try {
                this.error(message, sourceName, line, lineSource, lineOffset);
            }
            catch (EvaluatorException e) {
                exception = e;
                if (exception == null) {
                    exception = new EvaluatorException(message, sourceName, line, lineSource, lineOffset);
                }
            }
        }
        finally {
            if (exception == null) {
                exception = new EvaluatorException(message, sourceName, line, lineSource, lineOffset);
            }
        }
        return exception;
    }

    public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
        if (line < 0) {
            this.logger.warn(message);
        } else {
            String logMessage = String.valueOf(sourceName) + " : " + line + " : " + lineOffset + " : " + message;
            this.logger.warn(logMessage);
        }
        throw new JavaScriptEvaluatorException(message, sourceName, line, lineSource, lineOffset);
    }
}

