/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.builder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.tizen.common.builder.BuildResult;
import org.tizen.common.builder.core.AbstractBuilder;
import org.tizen.common.builder.exception.BuildException;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.IResource;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.web.compressor.minifier.core.JavaScriptEvaluatorException;
import org.tizen.web.compressor.minifier.core.JavaScriptMinifier;

public class JSMinifyBuilder
extends AbstractBuilder {
    public JSMinifyBuilder(String output) {
        super(output);
    }

    public JSMinifyBuilder(FileHandler fh) {
        super(fh);
    }

    public boolean canBuild(IResource resource) {
        if (!"js".equalsIgnoreCase(FilenameUtil.getExtension((String)resource.getName()))) {
            return false;
        }
        return super.canBuild(resource);
    }

    protected BuildResult doBuild(IResource resource) throws BuildException {
        BuildResult ret;
        block6: {
            InputStream is = null;
            ByteArrayOutputStream os = null;
            ret = new BuildResult(BuildResult.Status.UNKNOWN);
            try {
                is = resource.getContents();
                os = new ByteArrayOutputStream();
                this.logger.debug("minify : {}", (Object)resource.getPath());
                JavaScriptMinifier jsMin = new JavaScriptMinifier();
                jsMin.compress(is, (OutputStream)os);
                this.addOutputResource(ret, resource, resource.getPath(), os.toByteArray());
            }
            catch (JavaScriptEvaluatorException e) {
                ret.addBuildErrorInfo(resource, e.lineNumber(), e.columnNumber(), 2, e.getLocalizedMessage());
                IOUtil.tryClose((Object[])new Object[]{is, os});
                break block6;
            }
            catch (IOException e) {
                try {
                    throw new BuildException((Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtil.tryClose((Object[])new Object[]{is, os});
                    throw throwable;
                }
            }
            IOUtil.tryClose((Object[])new Object[]{is, os});
        }
        return ret;
    }
}

