/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.page;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.tizen.common.ui.font.TizenFonts;
import org.tizen.common.util.ImageUtil;
import org.tizen.web.editor.configuration.Activator;
import org.tizen.web.editor.configuration.ConfigurationEditor;
import org.tizen.web.editor.configuration.ITizenConfigurator;
import org.tizen.web.editor.configuration.Messages;
import org.tizen.web.editor.configuration.MsgManagerWrapper;
import org.tizen.web.editor.configuration.page.EditorFormToolkit;
import org.tizen.web.editor.configuration.support.IConfigurationDependent;

public abstract class AbstractFormPage
extends FormPage
implements IConfigurationDependent {
    public static final String EMPTY_STRING = "";
    public static final String OVERVIEW_PAGE_IMAGE_PATH = "icons/ConfigurationEditor/40_title_overview.png";
    public static final String PRIVILEGE_PAGE_IMAGE_PATH = "icons/ConfigurationEditor/40_title_privileges.png";
    public static final String FEATURE_PAGE_IMAGE_PATH = "icons/ConfigurationEditor/40_title_features.png";
    public static final String POLICY_PAGE_IMAGE_PATH = "icons/ConfigurationEditor/40_title_policy.png";
    public static final String LOCALIZATION_PAGE_IMAGE_PATH = "icons/ConfigurationEditor/40_title_localization.png";
    public static final String PREFERENCE_PAGE_IMAGE_PATH = "icons/ConfigurationEditor/40_title_preferences.png";
    public static final String TIZEN_PAGE_IMAGE_PATH = "icons/ConfigurationEditor/40_title_tizen.png";
    protected EditorFormToolkit editorToolkit;
    protected ScrolledForm scrolledForm;
    protected Composite body;
    protected MsgManagerWrapper msgManager;
    protected Label notiRegion;
    protected ITizenConfigurator tizenConfig;
    protected ConfigurationEditor configurationEditor;
    protected boolean dirty;

    public AbstractFormPage(ConfigurationEditor editor, String id, String title) {
        super((FormEditor)editor, id, title);
        this.configurationEditor = editor;
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.dirty = false;
        this.scrolledForm = managedForm.getForm();
        this.body = managedForm.getForm().getBody();
        this.editorToolkit = new EditorFormToolkit(this.scrolledForm.getDisplay());
        this.msgManager = new MsgManagerWrapper(this.scrolledForm.getForm());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.body, "org.tizen.ide.web.widget_configuration_editor_context");
    }

    public void setFocus() {
        this.body.setFocus();
    }

    public void doSave(IProgressMonitor monitor) {
        this.dirty = false;
        this.firePropertyChange(257);
        this.saveStatus(this.tizenConfig);
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void loadStatus(ITizenConfigurator configurator) {
    }

    @Override
    public void saveStatus(ITizenConfigurator configurator) {
    }

    public void markDirty() {
        if (this.configurationEditor.getConfig() != null) {
            this.dirty = true;
            this.configurationEditor.editorDirtyStateChanged();
        }
    }

    public void createForm(String title, String titleImagePath) {
        this.scrolledForm.setLayoutData((Object)new GridData(1808));
        GridLayout grid = new GridLayout(1, false);
        grid.verticalSpacing = 0;
        grid.horizontalSpacing = 0;
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        this.body.setLayout((Layout)grid);
        this.createTitle(this.body, title, titleImagePath);
    }

    private void createTitle(Composite parent, String title, String titleImagePath) {
        Composite headComposite = this.editorToolkit.createComposite(parent, 0);
        GridLayout grid = new GridLayout(2, false);
        grid.marginHeight = 20;
        grid.marginLeft = 20;
        grid.horizontalSpacing = 30;
        headComposite.setLayout((Layout)grid);
        GridData data = new GridData();
        data.widthHint = 660;
        data.horizontalAlignment = 2;
        data.grabExcessHorizontalSpace = true;
        headComposite.setLayoutData((Object)data);
        Label iconLabel = new Label(headComposite, 0);
        iconLabel.setBackground(parent.getDisplay().getSystemColor(1));
        iconLabel.setImage(ImageUtil.getImage((Plugin)Activator.getDefault(), (String)titleImagePath));
        Composite msgComposite = this.editorToolkit.createComposite(headComposite, 0);
        grid = new GridLayout(2, false);
        grid.marginHeight = 0;
        grid.marginWidth = 0;
        grid.horizontalSpacing = 8;
        msgComposite.setLayout((Layout)grid);
        msgComposite.setLayoutData((Object)new GridData(768));
        Label titleLabel = new Label(msgComposite, 0);
        titleLabel.setBackground(parent.getDisplay().getSystemColor(1));
        titleLabel.setFont(TizenFonts.getFont((int)3, (int)1));
        titleLabel.setText(title);
        this.notiRegion = new Label(msgComposite, 0);
        this.notiRegion.setBackground(msgComposite.getBackground());
        this.notiRegion.setLayoutData((Object)new GridData(768));
        if (this.msgManager != null) {
            this.msgManager.setNoticeRegion(this.notiRegion);
        }
        Label sepa = new Label(this.body, 258);
        sepa.setLayoutData((Object)new GridData(4, 3, false, false));
    }

    protected Composite createPage(Composite parent) {
        Composite pageComposite = this.editorToolkit.createComposite(parent, 0);
        GridLayout grid = new GridLayout();
        grid.marginWidth = 0;
        grid.marginLeft = 20;
        pageComposite.setLayout((Layout)grid);
        GridData data = new GridData(1040);
        data.widthHint = 660;
        data.horizontalAlignment = 2;
        data.grabExcessHorizontalSpace = true;
        pageComposite.setLayoutData((Object)data);
        Composite page = this.editorToolkit.createComposite(pageComposite, 0);
        page.setLayout((Layout)new GridLayout(1, false));
        data = new GridData(2, 4, false, true);
        data.widthHint = 640;
        page.setLayoutData((Object)data);
        return page;
    }

    public Text createRequiredText(String label, String tooltip, Composite parent) {
        return this.createText(String.valueOf(label) + Messages.Asterisk, tooltip, parent);
    }

    public Text createText(String label, String tooltip, Composite parent) {
        return this.createText(label, tooltip, parent, 2, 0);
    }

    public Text createText(String label, String tooltip, Composite parent, int horizontalSpan, int verticalSpan) {
        Label l = this.editorToolkit.createLabel(parent, label, 0);
        l.setToolTipText(tooltip);
        l.setLayoutData((Object)new GridData(1, 2, false, false));
        Text t = this.createText(parent, EMPTY_STRING, 2048);
        t.setLayoutData((Object)new GridData(4, 4, true, false, horizontalSpan, verticalSpan));
        return t;
    }

    public Text createText(Composite parent, String label, int style) {
        return this.editorToolkit.createText(parent, label, style);
    }

    public Button createButton(Composite parent, String label, int style) {
        return this.editorToolkit.createButton(parent, label, style);
    }

    public abstract void addListener();

    public abstract void removeListener();

    public abstract void createListener();

    public void dispose() {
        super.dispose();
        if (this.editorToolkit != null) {
            this.editorToolkit.dispose();
        }
    }
}

