/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.editor.configuration.policy;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.tizen.web.config.schema.model.Access;
import org.tizen.web.editor.configuration.support.AbstractChangeListener;

public class PolicyEditingSupport
extends EditingSupport {
    private int column;
    private CellEditor editor;
    private AbstractChangeListener listener;

    public PolicyEditingSupport(ColumnViewer viewer, int column) {
        super(viewer);
        this.column = column;
        switch (column) {
            case 0: {
                if (!(viewer instanceof TableViewer)) break;
                this.editor = new TextCellEditor((Composite)((TableViewer)viewer).getTable());
                break;
            }
            case 1: {
                this.editor = new CheckboxCellEditor(null, 40);
                break;
            }
        }
    }

    protected boolean canEdit(Object element) {
        switch (this.column) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    protected CellEditor getCellEditor(Object element) {
        return this.editor;
    }

    protected Object getValue(Object element) {
        if (!(element instanceof Access)) {
            return null;
        }
        Access access = (Access)element;
        switch (this.column) {
            case 0: {
                return access.getOrigin();
            }
            case 1: {
                if (access.getSubdomains() != null) {
                    return Boolean.parseBoolean(access.getSubdomains());
                }
                return false;
            }
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        if (!(element instanceof Access)) {
            return;
        }
        Access access = (Access)element;
        switch (this.column) {
            case 0: {
                access.setOrigin((String)value);
                break;
            }
            case 1: {
                access.setSubdomains(((Boolean)value).toString());
                break;
            }
        }
        this.getViewer().update(element, null);
        if (this.getListener() != null) {
            this.getListener().notifyChange();
        }
    }

    public void setListener(AbstractChangeListener listener) {
        this.listener = listener;
    }

    public void unsetListener() {
        this.listener = null;
    }

    public AbstractChangeListener getListener() {
        return this.listener;
    }
}

