/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.resources.ResourceDropAdapterAssistant;
import org.tizen.common.util.FileUtil;
import org.tizen.web.project.wizard.ui.WebProjectImportWizard;

public class WidgetDropAssistant
extends ResourceDropAdapterAssistant {
    public Object canDrop(TransferData transferData) {
        Object data = FileTransfer.getInstance().nativeToJava(transferData);
        if (data instanceof String[]) {
            String[] fileLocations;
            String[] stringArray = fileLocations = (String[])data;
            int n = fileLocations.length;
            int n2 = 0;
            while (n2 < n) {
                String extension;
                String fileLocation = stringArray[n2];
                File file = new File(fileLocation);
                if (file.exists() && "wgt".equalsIgnoreCase(extension = FileUtil.getFileExtension((String)file.getName()))) {
                    if (fileLocations.length < 2) {
                        return file;
                    }
                    return WidgetDropStatus.CANCEL;
                }
                ++n2;
            }
        } else {
            return WidgetDropStatus.NULL;
        }
        return WidgetDropStatus.DEFAULT;
    }

    public IStatus handleDrop(CommonDropAdapter dropAdapter, DropTargetEvent dropTargetEvent, Object target) {
        Object result = this.canDrop(dropAdapter.getCurrentTransfer());
        if (result instanceof File) {
            this.createProject((File)result);
            return Status.OK_STATUS;
        }
        if (result instanceof WidgetDropStatus && (WidgetDropStatus)((Object)result) == WidgetDropStatus.CANCEL) {
            return Status.CANCEL_STATUS;
        }
        if (result == WidgetDropStatus.NULL) {
            return Status.CANCEL_STATUS;
        }
        return super.handleDrop(dropAdapter, dropTargetEvent, target);
    }

    private void createProject(File file) {
        WebProjectImportWizard wizard = new WebProjectImportWizard(file.getAbsolutePath());
        WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
        dialog.setBlockOnOpen(false);
        dialog.open();
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        Object result = this.canDrop(transferType);
        if (result instanceof File || result instanceof WidgetDropStatus && (WidgetDropStatus)((Object)result) == WidgetDropStatus.NULL) {
            return Status.OK_STATUS;
        }
        return super.validateDrop(target, operation, transferType);
    }

    private static enum WidgetDropStatus {
        CANCEL,
        OK,
        DEFAULT,
        NULL;

    }
}

