/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.project.wizard.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.ProjectUtil;
import org.tizen.web.project.wizard.WizardMessages;

public class UserTemplateExportWizardTemplatePage
extends WizardPage {
    private Combo sourceProject;
    private Text templateNameText;
    private Text exportLocationText;
    private Button checkImportAutomatically;
    private IProject selectedProject;

    public UserTemplateExportWizardTemplatePage(String pageName) {
        super(pageName);
    }

    public UserTemplateExportWizardTemplatePage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        GridData singleColumnGridData = new GridData(768);
        GridData doubleColumnGridData = new GridData(768);
        doubleColumnGridData.horizontalSpan = 2;
        GridData fullColumnGridData = new GridData(768);
        fullColumnGridData.horizontalSpan = 3;
        Label sourceProjectLabel = new Label(composite, 0);
        sourceProjectLabel.setText(WizardMessages.UserTemplateExportWizardTemplatePage_SourceProjectLabel);
        sourceProjectLabel.setLayoutData((Object)new GridData());
        this.sourceProject = new Combo(composite, 2060);
        this.sourceProject.setLayoutData((Object)doubleColumnGridData);
        for (IProject project : this.getAllProjects()) {
            if (!ProjectUtil.isTizenWebProject((IProject)project)) continue;
            this.sourceProject.add(project.getName());
        }
        if (this.selectedProject != null) {
            this.sourceProject.select(this.sourceProject.indexOf(this.selectedProject.getName()));
        }
        this.sourceProject.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UserTemplateExportWizardTemplatePage.this.validatePage();
                UserTemplateExportWizardTemplatePage.this.selectedProject = UserTemplateExportWizardTemplatePage.this.getSpecifiedProject(UserTemplateExportWizardTemplatePage.this.getSourceProject());
            }
        });
        Label templateNameLabel = new Label(composite, 0);
        templateNameLabel.setText(WizardMessages.UserTemplateExportWizardTemplatePage_TemplateNameLabel);
        templateNameLabel.setLayoutData((Object)new GridData());
        this.templateNameText = new Text(composite, 2048);
        this.templateNameText.setText(WizardMessages.UserTemplateExportWizardTemplatePage_DefaultTemplateName);
        this.templateNameText.setLayoutData((Object)doubleColumnGridData);
        this.templateNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UserTemplateExportWizardTemplatePage.this.validatePage();
            }
        });
        Label exportLocationLabel = new Label(composite, 0);
        exportLocationLabel.setText(WizardMessages.UserTemplateExportWizardTemplatePage_ExportLocationLabel);
        exportLocationLabel.setLayoutData((Object)new GridData());
        this.exportLocationText = new Text(composite, 2048);
        this.exportLocationText.setLayoutData((Object)singleColumnGridData);
        this.exportLocationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UserTemplateExportWizardTemplatePage.this.validatePage();
            }
        });
        Button browseButton = new Button(composite, 8);
        browseButton.setText(WizardMessages.UserTemplateExportWizardTemplatePage_BrowseButton);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserTemplateExportWizardTemplatePage.this.handleBrowseButtonPressed();
            }
        });
        this.checkImportAutomatically = new Button(composite, 32);
        this.checkImportAutomatically.setLayoutData((Object)fullColumnGridData);
        this.checkImportAutomatically.setText(WizardMessages.UserTemplateExportWizardTemplatePage_AutoImportButton);
        this.checkImportAutomatically.setSelection(true);
        this.setControl((Control)composite);
        this.validatePage();
    }

    protected void handleBrowseButtonPressed() {
        DirectoryDialog dirDialog = new DirectoryDialog(this.exportLocationText.getShell(), 0x10000000);
        dirDialog.setMessage(WizardMessages.UserTemplateExportWizardTemplatePage_DirDialog);
        dirDialog.setFilterPath(this.getExportLocationText());
        String selectedDirectory = dirDialog.open();
        if (selectedDirectory != null) {
            this.exportLocationText.setText(selectedDirectory);
        }
    }

    protected boolean validatePage() {
        String sourceProjectContent = this.getSourceProject();
        String templateNameContent = this.getTemplateNameText();
        String exportLocationContent = this.getExportLocationText();
        if (sourceProjectContent == null || sourceProjectContent.isEmpty() || templateNameContent == null || templateNameContent.isEmpty() || exportLocationContent == null || exportLocationContent.isEmpty()) {
            this.setErrorMessage(WizardMessages.UserTemplateExportWizardTemplatePage_EmptyTextErrorMsg);
            this.setPageComplete(false);
            return false;
        }
        if (!FilenameUtil.isVaildName((String)templateNameContent)) {
            this.setErrorMessage(WizardMessages.UserTemplateExportWizardTemplatePage_InvalidName);
            this.setPageComplete(false);
            return false;
        }
        File exportLocationFile = new File(exportLocationContent);
        if (!exportLocationFile.isDirectory()) {
            this.setErrorMessage(WizardMessages.UserTemplateExportWizardTemplatePage_InvalidPathErrorMsg);
            this.setPageComplete(false);
            return false;
        }
        String[] fileList = exportLocationFile.list();
        if (fileList == null) {
            this.setErrorMessage(WizardMessages.UserTemplateExportWizardTemplatePage_FailedToValidateLocation);
            this.setPageComplete(false);
            return false;
        }
        this.setMessage(null);
        String[] stringArray = fileList;
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            if (filename.equalsIgnoreCase(templateNameContent)) {
                this.setMessage(WizardMessages.UserTemplateExportWizardTemplatePage_AlreadyExistMsg, 2);
                break;
            }
            ++n2;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
        return true;
    }

    public void setSelectedProject(IProject project) {
        this.selectedProject = project;
    }

    protected List<IProject> getAllProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> result = new ArrayList<IProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible()) {
                result.add(project);
            }
            ++n2;
        }
        return result;
    }

    private IProject getSpecifiedProject(String projectName) {
        for (IProject project : this.getAllProjects()) {
            if (!project.getName().equals(projectName)) continue;
            return project;
        }
        return null;
    }

    public IProject getSelectedProject() {
        return this.selectedProject;
    }

    public boolean isAutomaticallyImport() {
        return this.checkImportAutomatically.getSelection();
    }

    public String getSourceProject() {
        return this.sourceProject.getText().trim();
    }

    public String getTemplateNameText() {
        return this.templateNameText.getText().trim();
    }

    public String getExportLocationText() {
        return this.exportLocationText.getText().trim();
    }
}

