/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.builder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.tizen.common.builder.BuildResult;
import org.tizen.common.builder.core.AbstractBuilder;
import org.tizen.common.builder.exception.BuildException;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.IResource;
import org.tizen.common.util.IOUtil;
import org.tizen.web.compressor.minifier.core.CSSMinifier;

public class CSSMinifyBuilder
extends AbstractBuilder {
    protected final CSSMinifier compressor = new CSSMinifier();

    public CSSMinifyBuilder(String output) {
        super(output);
    }

    public CSSMinifyBuilder(FileHandler fh) {
        super(fh);
    }

    public boolean canBuild(IResource resource) {
        if (super.canBuild(resource)) {
            return this.compressor.canHandle(resource.getName());
        }
        return false;
    }

    protected BuildResult doBuild(IResource resource) throws BuildException {
        BuildResult result = new BuildResult(BuildResult.Status.UNKNOWN);
        InputStream is = null;
        ByteArrayOutputStream os = null;
        try {
            try {
                is = resource.getContents();
                os = new ByteArrayOutputStream();
                this.logger.debug("css minify : {}", (Object)resource.getPath());
                this.compressor.compress(is, (OutputStream)os);
                this.addOutputResource(result, resource, resource.getPath(), os.toByteArray());
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            IOUtil.tryClose((Object[])new Object[]{is, os});
            throw throwable;
        }
        IOUtil.tryClose((Object[])new Object[]{is, os});
        return result;
    }
}

